import React, { SVGProps } from "react";

export function LayersDuotone(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                stroke="currentColor"
                d="M12 4 5 7l7 3 7-3-7-3Z"
                fillOpacity=".24"
                strokeLinejoin="round"
                strokeWidth="1.2"
            />
            <path
                fill="currentColor"
                d="M10.8336 9.4999 12 9.9998l1.1664-.5L19 12l-7 3-7-3 5.8336-2.5001Z"
                clipRule="evenodd"
                fillOpacity=".24"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m10.8336 9.4999.2364-.5515a.6.6 0 0 0-.4727 0l.2363.5515ZM12 9.9998l-.2364.5514a.5999.5999 0 0 0 .4727 0L12 9.9998Zm1.1664-.5.2363-.5514a.6.6 0 0 0-.4727 0l.2364.5515ZM19 12l.2364.5515a.6.6 0 0 0 0-1.103L19 12Zm-7 3-.2364.5515a.6001.6001 0 0 0 .4728 0L12 15Zm-7-3-.2363-.5515a.6.6 0 0 0 0 1.103L5 12Zm5.5973-1.9486 1.1663.4998.4727-1.103-1.1663-.4998-.4727 1.103Zm1.639.4998 1.1664-.4998-.4727-1.103-1.1664.4999.4727 1.1029Zm7.0001.8973-5.8337-2.5001-.4727 1.103 5.8336 2.5001.4728-1.103Zm-7 4.103 7-3-.4728-1.103-7 3 .4728 1.103Zm-7.4727-3 6.9999 3 .4728-1.103-7-3-.4727 1.103Zm5.8336-3.6031-5.8337 2.5001.4727 1.103 5.8337-2.5001-.4727-1.103Z"
            />
            <path
                fill="currentColor"
                d="M10.8333 14.5 12 15l1.1667-.5L19 17l-7 3-7-3 5.8333-2.5Z"
                clipRule="evenodd"
                fillOpacity=".24"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m10.8333 14.5.2364-.5515a.5999.5999 0 0 0-.4727 0l.2363.5515ZM12 15l-.2364.5515a.6001.6001 0 0 0 .4728 0L12 15Zm1.1667-.5.2363-.5515a.5999.5999 0 0 0-.4727 0l.2364.5515ZM19 17l.2364.5515a.6.6 0 0 0 0-1.103L19 17Zm-7 3-.2364.5515a.6001.6001 0 0 0 .4728 0L12 20Zm-7-3-.2363-.5515a.6.6 0 0 0 0 1.103L5 17Zm5.597-1.9485 1.1666.5.4728-1.103-1.1667-.5-.4727 1.103Zm1.6394.5 1.1666-.5-.4727-1.103-1.1667.5.4728 1.103Zm7 .897-5.8334-2.5-.4727 1.103 5.8333 2.5.4728-1.103Zm-7 4.103 7-3-.4728-1.103-7 3 .4728 1.103Zm-7.4727-3 6.9999 3 .4728-1.103-7-3-.4727 1.103Zm5.8333-3.603-5.8333 2.5.4726 1.103 5.8334-2.5-.4727-1.103Z"
            />
        </svg>
    );
}
export default LayersDuotone;
