import React, { SVGProps } from "react";

export function ImgOutBoxDuotoneLine(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="18"
                height="18"
                x="3"
                y="3"
                maskUnits="userSpaceOnUse"
            >
                <path
                    fill="currentColor"
                    d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                />
            </mask>
            <g mask="url(#a)">
                <path
                    fill="currentColor"
                    stroke="currentColor"
                    d="M12.8982 14.788 4.3655 5.402A1.2283 1.2283 0 0 0 3.4566 5C2.1 5 1 6.0999 1 7.4566v8.0444c0 3.7712 0 5.6568 1.1716 6.8284C3.343 23.501 5.2288 23.501 9 23.501h8.0344c.5031 0 .7547 0 .9741-.0243a4 4 0 0 0 3.4223-2.9361c.0574-.2132.0956-.4618.1721-.959v-.0001c.0519-.3371.0778-.5057.0894-.6654a4 4 0 0 0-1.1913-3.1486c-.1144-.112-.2454-.2212-.5074-.4395l-.0001-.0001-1.8162-1.5135c-.2148-.179-.3222-.2684-.4142-.3293-.9281-.6141-2.179-.3524-2.7832.5822-.0599.0926-.1224.2176-.2474.4676v.0001c-.0709.1419-.1064.2128-.1391.2624-.3325.5049-1.0335.6016-1.4902.2056-.0449-.0389-.0983-.0976-.205-.215Z"
                    fillOpacity=".24"
                    strokeWidth="1.2"
                />
            </g>
            <path
                stroke="currentColor"
                d="M21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h1"
                strokeWidth="1.2"
            />
            <path
                fill="currentColor"
                d="M21 3v-.6h.6V3H21Zm-4.6252 4.4685a.6.6 0 1 1-.7496-.937l.7496.937ZM20.4 8V3h1.2v5h-1.2Zm.6-4.4h-5V2.4h5v1.2Zm.3748-.1315-5 4-.7496-.937 5-4 .7496.937Z"
            />
        </svg>
    );
}
export default ImgOutBoxDuotoneLine;
