import React, { SVGProps } from "react";

export function ImgOutBoxDuotone(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="18"
                height="18"
                x="3"
                y="3"
                maskUnits="userSpaceOnUse"
            >
                <path
                    fill="currentColor"
                    d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                />
            </mask>
            <g mask="url(#a)">
                <path
                    fill="currentColor"
                    d="m12.6887 14.5694-1.4969-1.6329c-1.2694-1.3848-1.904-2.0772-2.7292-2.1148-.8252-.0375-1.5202.5943-2.9101 1.8579l-1.9218 1.747c-.2987.2715-.448.4073-.5325.5836a.998.998 0 0 0-.0246.0556C3 15.2469 3 15.4487 3 15.8524c0 3.6682 0 5.5022 1.0833 6.6565a3.984 3.984 0 0 0 .3454.3267c1.2126 1.0177 3.0438.9159 6.7064.7125l3.3119-.184c2.6105-.1451 3.9157-.2176 4.8509-.874a3.999 3.999 0 0 0 1.0986-1.1613C21 20.3586 21 19.0514 21 16.4369v-.1943c0-.4074 0-.6112-.0384-.8044a1.9996 1.9996 0 0 0-.2987-.7209c-.1094-.1638-.2535-.3079-.5416-.596-.6589-.6589-.9884-.9884-1.3559-1.1406a2 2 0 0 0-1.5308 0c-.3675.1522-.697.4817-1.3559 1.1406l-.5065.5065c-.5925.5925-.8888.8888-1.2481.9223a.998.998 0 0 1-.2285-.005c-.3575-.049-.6407-.3579-1.2069-.9757Z"
                    fillOpacity=".24"
                />
            </g>
            <circle cx="6" cy="6" r="2" fill="currentColor" />
            <path
                fill="currentColor"
                d="M20 4v-.6h.6V4H20Zm-5.5757 6.4243a.6001.6001 0 0 1-.8486-.8486l.8486.8486ZM19.4 9V4h1.2v5h-1.2Zm.6-4.4h-5V3.4h5v1.2Zm.4243-.1757-6 6-.8486-.8486 6-6 .8486.8486Z"
            />
        </svg>
    );
}
export default ImgOutBoxDuotone;
