import React, { SVGProps } from "react";

export function ImgLoadBoxDuotone(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="18"
                height="18"
                x="3"
                y="3"
                maskUnits="userSpaceOnUse"
            >
                <path
                    fill="currentColor"
                    d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                />
            </mask>
            <g mask="url(#a)">
                <path
                    fill="currentColor"
                    d="m13.0165 14.9271-2.1639-2.3606c-.943-1.0287-1.4144-1.543-2-1.6881a2.0013 2.0013 0 0 0-.7836-.0357c-.5964.0913-1.1126.5606-2.1452 1.4993-1.0613.9648-1.592 1.4473-2.049 1.3896a1.0004 1.0004 0 0 1-.5246-.2321C3 13.2001 3 12.4829 3 11.0486V7.5679C3 3.9838 3 2.1917 4.0942 1.035 5.1884-.1216 6.9777-.221 10.5562-.4198l2-.1111c3.961-.22 5.9415-.33 7.1927.8535C21 1.506 21 3.4896 21 7.4568v6.4494c0 .5646 0 .8469-.0545 1.0052-.1955.5679-.844.8365-1.3838.5732-.1505-.0734-.3501-.273-.7494-.6723-.37-.37-.5551-.5551-.7426-.6738a2.0003 2.0003 0 0 0-2.1394 0c-.1875.1187-.3726.3038-.7426.6738l-.1585.1585c-.2693.2693-.4039.4039-.5469.4762a1.0001 1.0001 0 0 1-.9401-.0205c-.1397-.0783-.2684-.2187-.5257-.4994Z"
                    fillOpacity=".24"
                />
            </g>
            <path
                fill="currentColor"
                d="M8 16v-.6h.6v.6H8Zm-5.5757 6.4243a.6.6 0 1 1-.8486-.8486l.8486.8486ZM7.4 21v-5h1.2v5H7.4Zm.6-4.4H3v-1.2h5v1.2Zm.4243-.1757-6 6-.8486-.8486 6-6 .8486.8486Z"
            />
            <circle cx="16" cy="8" r="2" fill="currentColor" />
        </svg>
    );
}
export default ImgLoadBoxDuotone;
