import React, { SVGProps } from "react";

export function ImgBoxLight(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                stroke="currentColor"
                d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
            />
            <path
                fill="currentColor"
                d="m18.9976 14.2904-.3432-.3433-.0159-.0158c-.4005-.4006-.7236-.7236-1.0071-.9626-.292-.2461-.5764-.4334-.9093-.5338a2.4996 2.4996 0 0 0-1.4442 0c-.3329.1004-.6173.2877-.9093.5338-.2835.239-.6066.562-1.0071.9626l-.0159.0158c-.2997.2998-.4998.4991-.6624.6336-.1614.1335-.2312.1552-.2595.1601a.4997.4997 0 0 1-.3495-.0673c-.0244-.0151-.0812-.0612-.1814-.245-.1011-.1853-.2128-.4447-.3798-.8343l-.0534-.1246-.0121-.0282c-.3646-.8507-.6544-1.527-.9368-2.0288-.287-.51-.6055-.9142-1.065-1.1446a2.5006 2.5006 0 0 0-1.3306-.2562c-.5121.0432-.958.3003-1.4138.6671-.4486.3611-.9688.8814-1.6233 1.5359l-.0217.0216L5 12.2928v.7071c0 .2463 0 .4817.0004.7066l.763-.763c.681-.6809 1.1635-1.1624 1.565-1.4855.3992-.3214.6541-.4315.8708-.4498a1.5 1.5 0 0 1 .7984.1538c.1944.0974.3903.2944.6416.741.2527.4491.5219 1.0753.9012 1.9605l.0534.1246.0096.0224c.1549.3614.285.6649.4115.8968.1299.2382.2889.4654.533.6165a1.5 1.5 0 0 0 1.0487.202c.2828-.0497.5148-.2016.7238-.3745.2036-.1683.4371-.4018.7151-.6799l.0172-.0172c.4201-.4201.7133-.7126.9603-.9208.2423-.2042.4055-.2964.5537-.3412a1.501 1.501 0 0 1 .8666 0c.1482.0448.3114.137.5537.3412.247.2082.5402.5007.9603.9208l1.0282 1.0283c.0132-.4104.0193-.8705.0221-1.3921Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <circle cx="16.5" cy="7.5" r="1.5" fill="currentColor" />
        </svg>
    );
}
export default ImgBoxLight;
