import React, { SVGProps } from "react";

export function ImgBoxFill(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M3.1716 3.1716C2 4.343 2 6.2288 2 10v4c0 3.7712 0 5.6568 1.1716 6.8284C4.343 22 6.2288 22 10 22h4c3.7712 0 5.6569 0 6.8284-1.1716C22 19.6569 22 17.7712 22 14v-4c0-2.8393 0-4.6098-.5-5.8114V17a3.6213 3.6213 0 0 1-2.5607-1.0607l-.7516-.7516c-.7213-.7213-1.082-1.082-1.4909-1.234a2.0009 2.0009 0 0 0-1.3936 0c-.4089.152-.7696.5127-1.4909 1.234l-.1131.1131c-.5854.5854-.878.878-1.189.9326a1.0004 1.0004 0 0 1-.6992-.1346c-.2685-.1662-.4315-.5466-.7576-1.3075L11 14.6667c-.7496-1.7492-1.1245-2.6238-1.7783-2.9516a2.0008 2.0008 0 0 0-1.0645-.205c-.7288.0615-1.4017.7344-2.7473 2.08L3.5 15.5V2.8874a2.9855 2.9855 0 0 0-.3284.2842Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                stroke="currentColor"
                d="M3 10c0-1.9139.0021-3.2487.1375-4.2558.1316-.9784.3722-1.4965.7412-1.8655s.887-.6096 1.8655-.7412C6.7512 3.0021 8.0862 3 10 3h4c1.9139 0 3.2487.0021 4.2558.1375.9784.1316 1.4965.3722 1.8655.7412s.6096.887.7412 1.8655C20.9979 6.7512 21 8.0862 21 10v4c0 1.9139-.0021 3.2487-.1375 4.2558-.1316.9784-.3722 1.4965-.7412 1.8655s-.8871.6096-1.8655.7412C17.2487 20.9979 15.9139 21 14 21h-4c-1.9139 0-3.2487-.0021-4.2558-.1375-.9784-.1316-1.4965-.3722-1.8655-.7412s-.6096-.8871-.7412-1.8655C3.0021 17.2487 3 15.9139 3 14v-4Z"
                strokeWidth="2"
            />
            <circle cx="15" cy="9" r="2" fill="currentColor" />
        </svg>
    );
}
export default ImgBoxFill;
