import React, { SVGProps } from "react";

export function ImgBoxDuotoneLine(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="18"
                height="18"
                x="3"
                y="3"
                maskUnits="userSpaceOnUse"
            >
                <path
                    fill="currentColor"
                    d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                />
            </mask>
            <g mask="url(#a)">
                <path
                    fill="currentColor"
                    stroke="currentColor"
                    d="m5.4099 12.5901-.1528.1528c-.9806.9806-1.471 1.471-1.7645 2.0729a4.0012 4.0012 0 0 0-.2496.6506c-.1846.6438-.1481 1.3363-.0752 2.7213L3.5 24.5H21v-4.7427c0-1.4514 0-2.1771-.2386-2.8366a3.9944 3.9944 0 0 0-.2337-.5248c-.3306-.6185-.87-1.104-1.9488-2.0749l-.2146-.1931c-.8961-.8065-1.3441-1.2097-1.8565-1.324a1.999 1.999 0 0 0-.9726.0256c-.5057.141-.9319.5672-1.7844 1.4197-.6324.6324-.9485.9485-1.2883.9914a.9999.9999 0 0 1-.6099-.1175c-.2995-.1659-.4784-.5832-.836-1.4178-.7607-1.7749-1.141-2.6624-1.795-2.9902a2.0008 2.0008 0 0 0-1.0644-.205c-.7288.0615-1.4017.7344-2.7473 2.08Z"
                    fillOpacity=".24"
                />
            </g>
            <path
                stroke="currentColor"
                d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                strokeWidth="1.2"
            />
            <circle cx="16.5" cy="7.5" r="1.5" fill="currentColor" />
        </svg>
    );
}
export default ImgBoxDuotoneLine;
