import React, { SVGProps } from "react";

export function ImgBox(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                stroke="currentColor"
                d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                strokeWidth="2"
            />
            <path
                fill="currentColor"
                d="m18.9997 13.5854-.0203-.0203c-.3896-.3897-.7257-.7258-1.0258-.9787-.3169-.2671-.6619-.5019-1.0871-.6302a2.9997 2.9997 0 0 0-1.733 0c-.4252.1283-.7702.3631-1.0871.6302-.3001.2529-.6362.589-1.0258.9787l-.0285.0285c-.3069.3068-.4875.4859-.6276.6018l-.0202.0164-.0126-.0227c-.087-.1596-.1882-.393-.3591-.7919l-.0535-.1246-.022-.0515-.0001-.0001c-.3559-.8306-.6548-1.528-.9506-2.0537-.3048-.5416-.6846-1.0495-1.2766-1.3462a3 3 0 0 0-1.5967-.3075c-.6599.0556-1.2011.3862-1.6853.7758-.4053.3263-.8603.7704-1.3878 1.2965v1.414c0 .5167.0003.9849.003 1.4111l1.114-1.1139c.6891-.6892 1.1494-1.1474 1.5249-1.4496.3709-.2986.5304-.3352.5994-.341a1 1 0 0 1 .5322.1025c.0619.031.1964.1243.43.5392.2363.42.4934 1.0164.8774 1.9123l.0534.1246.0163.0381c.1489.3475.2872.6704.4253.9236.1447.2652.3549.5831.7088.8021.4173.2583.915.3542 1.3984.2693.4099-.0719.7231-.289.956-.4815.2222-.1838.4705-.4322.7378-.6996h.0001l.0293-.0293c.4262-.4262.702-.7008.929-.8921.2173-.1832.3199-.2279.3759-.2448a1.0002 1.0002 0 0 1 .5776 0c.056.0169.1586.0616.3759.2448.227.1913.5028.4659.929.8921l1.3504 1.3504c.0461-.7178.0542-1.6103.0556-2.7728Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <circle cx="16.5" cy="7.5" r="1.5" fill="currentColor" />
        </svg>
    );
}
export default ImgBox;
