import React, { SVGProps } from "react";

export function FireLight(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                stroke="currentColor"
                d="M18.5 12c0 3.5899-2.9101 6.5-6.5 6.5S5.5 15.5899 5.5 12c0-5.6335 5.7303-9.0632 6.4302-9.461a.1397.1397 0 0 1 .1396 0C12.7697 2.9368 18.5 6.3664 18.5 12Z"
                strokeLinejoin="round"
            />
            <path
                fill="currentColor"
                d="m15.4991 11.9216-.4999.0101.0001.0009.4998-.011ZM8.5 12.0002l.5-.0001-.5.0001Zm3.5859-5.4362.3021-.3984-.3021.3983Zm-.474-.3984c-.2844.2157-1.1727.9224-1.9945 1.9342C8.8036 9.1017 8 10.47 7.9999 12h1c0-1.1897.6348-2.3355 1.3937-3.2699.7509-.9245 1.5696-1.576 1.8226-1.7679l-.6043-.7967Zm4.3871 5.7458c-.0306-1.5083-.8333-2.8546-1.6404-3.841-.8149-.996-1.6888-1.6911-1.9706-1.9048l-.6043.7967c.2505.19 1.0559.8308 1.801 1.7414.7528.92 1.3907 2.0508 1.4145 3.228l.9998-.0203Zm-.9997.0212c.0005.0223.0007.0448.0007.0673h1c0-.0298-.0003-.0596-.001-.0893l-.9997.022Zm.0007.0673c0 1.6568-1.3431 3-3 3v1c2.2091 0 4-1.7909 4-4h-1Zm-3 3c-1.6568 0-2.9999-1.343-3-2.9998l-1 .0001c.0002 2.209 1.791 3.9997 4 3.9997v-1Zm-4-2.9998a.5.5 0 0 0 .5.5001v-1a.5.5 0 0 1 .5.4999H8Zm1 0c0-.271-.2188-.4999-.5-.4999v1c-.2812 0-.5-.229-.5-.5l1-.0001Zm3.2162-5.0377a.3585.3585 0 0 1-.4325 0l.6043-.7968a.6415.6415 0 0 0-.7761 0l.6043.7967Z"
            />
            <path stroke="currentColor" d="M12 21v-9" />
            <circle cx="12" cy="12" r="1" fill="currentColor" />
        </svg>
    );
}
export default FireLight;
