import React, { SVGProps } from "react";

export function DownloadDuotoneLine(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="20"
                height="12"
                x="2"
                y="9"
                fill="currentColor"
                maskUnits="userSpaceOnUse"
            >
                <path fill="currentColor" d="M2 9h20v12H2z" />
                <path
                    d="M6 20h12c1.6569 0 3-1.3431 3-3s-1.3431-3-3-3c-.2795 0-.4193 0-.517-.0197-.298-.0599-.4395-.1515-.6163-.3989-.0579-.081-.1395-.2629-.3028-.6266C15.7822 11.2131 14.0328 10 12 10c-2.0328 0-3.7822 1.2131-4.564 2.9548-.1632.3637-.2448.5456-.3027.6266-.1768.2474-.3183.339-.6163.3989C6.4193 14 6.2795 14 6 14c-1.6569 0-3 1.3431-3 3s1.3431 3 3 3Z"
                    clipRule="evenodd"
                    fillRule="evenodd"
                />
            </mask>
            <path
                fill="currentColor"
                d="M6 20h12c1.6569 0 3-1.3431 3-3s-1.3431-3-3-3c-.2795 0-.4193 0-.517-.0197-.298-.0599-.4395-.1515-.6163-.3989-.0579-.081-.1395-.2629-.3028-.6266C15.7822 11.2131 14.0328 10 12 10c-2.0328 0-3.7822 1.2131-4.564 2.9548-.1632.3637-.2448.5456-.3027.6266-.1768.2474-.3183.339-.6163.3989C6.4193 14 6.2795 14 6 14c-1.6569 0-3 1.3431-3 3s1.3431 3 3 3Z"
                clipRule="evenodd"
                fillOpacity=".24"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m7.1333 13.5814-.4882-.3488.4882.3488Zm-.6163.3989.1184.5882-.1184-.5882Zm10.966 0-.1184.5882.1184-.5882Zm-.6163-.3989-.4881.3489.4881-.3489ZM12 19.4H6v1.2h6v-1.2Zm6 0h-6v1.2h6v-1.2Zm2.4-2.4c0 1.3255-1.0745 2.4-2.4 2.4v1.2c1.9882 0 3.6-1.6118 3.6-3.6h-1.2ZM18 14.6c1.3255 0 2.4 1.0745 2.4 2.4h1.2c0-1.9882-1.6118-3.6-3.6-3.6v1.2Zm-.8887-1.8909C16.2364 10.7597 14.2776 9.4 12 9.4v1.2c1.7879 0 3.3281 1.0665 4.0165 2.6005l1.0948-.4914ZM12 9.4c-2.2776 0-4.2364 1.3597-5.1113 3.3091l1.0948.4914C8.6719 11.6665 10.212 10.6 12 10.6V9.4Zm-6 4c-1.9882 0-3.6 1.6118-3.6 3.6h1.2c0-1.3255 1.0745-2.4 2.4-2.4v-1.2ZM2.4 17c0 1.9882 1.6118 3.6 3.6 3.6v-1.2c-1.3255 0-2.4-1.0745-2.4-2.4H2.4Zm4.4887-4.2909a23.2774 23.2774 0 0 1-.1854.4074c-.0492.1035-.064.1241-.0582.1161l.9763.6977c.0637-.0891.1188-.2.1656-.2986.0516-.1084.116-.252.1965-.4312l-1.0948-.4914ZM6 14.6c.2442 0 .4631.0032.6354-.0315l-.2368-1.1764c.0015-.0003-.0175.0035-.0899.0057-.071.0021-.1652.0022-.3087.0022v1.2Zm.6451-1.3674c-.0658.092-.0938.1105-.1005.1149-.0067.0043-.035.0223-.146.0446l.2368 1.1764c.1871-.0376.3785-.0954.5612-.2137.1828-.1183.3139-.2692.4248-.4245l-.9763-.6977ZM18 13.4c-.1435 0-.2377-.0001-.3087-.0022-.0724-.0022-.0914-.006-.0899-.0057l-.2368 1.1764c.1723.0347.3913.0315.6354.0315v-1.2Zm-1.9835-.1995c.0805.1792.1449.3228.1965.4312.0468.0986.1019.2095.1656.2986l.9763-.6977c.0057.008-.009-.0126-.0582-.1161a24.0557 24.0557 0 0 1-.1854-.4074l-1.0948.4914Zm1.5849.1916c-.1109-.0223-.1393-.0403-.146-.0446-.0067-.0044-.0347-.0229-.1005-.1149l-.9763.6977c.1109.1553.242.3062.4248.4245.1827.1183.3741.1761.5612.2137l.2368-1.1764Z"
                fillOpacity=".24"
                mask="url(#a)"
            />
            <path
                fill="currentColor"
                d="M9.5 11.379a4.4176 4.4176 0 0 0-1.5165 1.8218l-.0032.0071c-.079.1759-.1424.3172-.1933.4242-.0468.0986-.1019.2094-.1656.2985-.111.1553-.242.3063-.4248.4246-.1827.1183-.3741.176-.5612.2137-.1587.0319-.357.0317-.578.0315H6c-1.3255 0-2.4 1.0745-2.4 2.4 0 1.3254 1.0745 2.4 2.4 2.4h12c1.3255 0 2.4-1.0746 2.4-2.4 0-1.3255-1.0745-2.4-2.4-2.4h-.0573c-.2211.0002-.4194.0004-.5781-.0315-.1871-.0377-.3785-.0954-.5612-.2137-.1828-.1183-.3139-.2693-.4248-.4246-.0637-.0891-.1188-.1999-.1657-.2985-.0509-.1071-.1143-.2484-.1933-.4244l-.0031-.0069A4.4176 4.4176 0 0 0 14.5 11.379V9.988a5.6222 5.6222 0 0 1 2.6113 2.7215c.0828.1845.1409.3137.1854.4073.0353.0743.0529.1059.0578.1149.002.0035.002.0035.0004.0012.0658.0921.0938.1106.1005.1149.0067.0043.0351.0224.146.0447-.0001 0-.0001 0 0 0 .0017.0003.023.0037.0899.0057.0709.0021.1652.0022.3087.0022 1.9882 0 3.6 1.6117 3.6 3.6 0 1.9882-1.6118 3.6-3.6 3.6H6c-1.9882 0-3.6-1.6118-3.6-3.6 0-1.9883 1.6118-3.6 3.6-3.6.1435 0 .2377-.0001.3087-.0022.0669-.002.0882-.0054.0899-.0057.0001 0 .0001 0 0 0 .1109-.0223.1393-.0404.146-.0447.0066-.0043.0347-.0228.1005-.1149-.0016.0023-.0016.0023.0003-.0012.005-.009.0226-.0406.0579-.1149.0445-.0936.1025-.2228.1854-.4073A5.6225 5.6225 0 0 1 9.5 9.988v1.391Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m12 3-.4243-.4243L12 2.1515l.4243.4242L12 3Zm.6 10a.6.6 0 1 1-1.2 0h1.2ZM7.5757 6.5757l4-4 .8486.8486-4 4-.8486-.8486Zm4.8486-4 4 4-.8486.8486-4-4 .8486-.8486ZM12.6 3v10h-1.2V3h1.2Z"
            />
        </svg>
    );
}
export default DownloadDuotoneLine;
