import React, { SVGProps } from "react";

export function BookFill(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M6.5 16H16c1.8856 0 2.8284 0 3.4142-.5858C20 14.8284 20 13.8856 20 12V7c0-1.8856 0-2.8284-.5858-3.4142C18.8284 3 17.8856 3 16 3H8c-1.8856 0-2.8284 0-3.4142.5858C4 4.1716 4 5.1144 4 7v11.5C4 17.1193 5.1193 16 6.5 16ZM9 6c-1.1046 0-2 .8954-2 2s.8954 2 2 2h6c1.1046 0 2-.8954 2-2s-.8954-2-2-2H9Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m19.4142 15.4142-.7071-.7071.7071.7071Zm0-11.8284-.7071.707.7071-.707ZM9 6V5v1Zm0 4V9v1Zm6 0v1-1Zm0-4V5v1Zm1 9H6.5v2H16v-2Zm2.7071-.2929c-.0761.0761-.2121.1703-.6458.2286C17.5988 14.9979 16.9711 15 16 15v2c.9145 0 1.701.0021 2.3278-.0821.6555-.0882 1.2839-.2869 1.7935-.7966l-1.4142-1.4142ZM19 12c0 .9711-.0021 1.5988-.0643 2.0613-.0583.4337-.1525.5697-.2286.6458l1.4142 1.4142c.5097-.5096.7084-1.138.7966-1.7935C21.0021 13.701 21 12.9145 21 12h-2Zm0-5v5h2V7h-2Zm-.2929-2.7071c.0761.0761.1703.212.2286.6458C18.9979 5.4012 19 6.0289 19 7h2c0-.9145.0021-1.701-.0821-2.3278-.0882-.6555-.2869-1.2839-.7966-1.7935l-1.4142 1.4142ZM16 4c.9711 0 1.5988.0021 2.0613.0643.4337.0583.5697.1525.6458.2286l1.4142-1.4142c-.5096-.5097-1.138-.7084-1.7935-.7966C17.701 1.998 16.9145 2 16 2v2ZM8 4h8V2H8v2Zm-2.7071.2929c.0761-.0761.212-.1703.6458-.2286C6.4012 4.0021 7.0289 4 8 4V2c-.9145 0-1.701-.0021-2.3278.0821-.6555.0882-1.2839.287-1.7935.7966l1.4142 1.4142ZM5 7c0-.971.0021-1.5988.0643-2.0613.0583-.4337.1525-.5697.2286-.6458L3.8787 2.8787c-.5097.5096-.7084 1.138-.7966 1.7935C2.998 5.299 3 6.0855 3 7h2Zm0 11.5V7H3v11.5h2ZM6.5 15C4.567 15 3 16.567 3 18.5h2c0-.8284.6716-1.5 1.5-1.5v-2ZM8 8c0-.5523.4477-1 1-1V5C7.3431 5 6 6.3431 6 8h2Zm1 1c-.5523 0-1-.4477-1-1H6c0 1.6569 1.3431 3 3 3V9Zm6 0H9v2h6V9Zm1-1c0 .5523-.4477 1-1 1v2c1.6569 0 3-1.3431 3-3h-2Zm-1-1c.5523 0 1 .4477 1 1h2c0-1.6569-1.3431-3-3-3v2ZM9 7h6V5H9v2Zm2 13H6.5v2H11v-2Zm-8-1.5C3 20.433 4.567 22 6.5 22v-2c-.8284 0-1.5-.6716-1.5-1.5H3Z"
            />
            <path stroke="currentColor" d="M20 21H10" strokeWidth="2" />
        </svg>
    );
}
export default BookFill;
