import React, { SVGProps } from "react";

export function BookCheckFill(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M6.5 16H16c1.8856 0 2.8284 0 3.4142-.5858C20 14.8284 20 13.8856 20 12V7c0-1.8856 0-2.8284-.5858-3.4142C18.8284 3 17.8856 3 16 3H8c-1.8856 0-2.8284 0-3.4142.5858C4 4.1716 4 5.1144 4 7v11.5C4 17.1193 5.1193 16 6.5 16Zm9.9142-6.5858c.7811-.781.7811-2.0474 0-2.8284-.781-.781-2.0474-.781-2.8284 0L11 9.1716l-.5858-.5858c-.781-.781-2.0474-.781-2.8284 0-.781.781-.781 2.0474 0 2.8284l1.2929 1.2929c1.1716 1.1716 3.071 1.1716 4.2426 0l3.2929-3.2929Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m19.4142 15.4142-.7071-.7071.7071.7071Zm0-11.8284-.7071.707.7071-.707Zm-3 3 .7071-.7071-.7071.707Zm0 2.8284-.7071-.707.7071.707Zm-2.8284-2.8284-.7071-.7071.7071.707ZM11 9.1716l-.7071.707.7071.7072.7071-.7071L11 9.1716Zm-.5858-.5858-.707.707.707-.707Zm-2.8284 0 .707.707-.707-.707Zm0 2.8284.707-.7071-.707.7071Zm1.2929 1.2929-.7071.7071.707-.7071Zm4.2426 0L12.4142 12l.7071.7071ZM16 15H6.5v2H16v-2Zm2.7071-.2929c-.0761.0761-.2121.1703-.6458.2286C17.5988 14.9979 16.9711 15 16 15v2c.9145 0 1.701.0021 2.3278-.0821.6555-.0882 1.2839-.2869 1.7935-.7966l-1.4142-1.4142ZM19 12c0 .9711-.0021 1.5988-.0643 2.0613-.0583.4337-.1525.5697-.2286.6458l1.4142 1.4142c.5097-.5096.7084-1.138.7966-1.7935C21.0021 13.701 21 12.9145 21 12h-2Zm0-5v5h2V7h-2Zm-.2929-2.7071c.0761.0761.1703.212.2286.6458C18.9979 5.4012 19 6.0289 19 7h2c0-.9145.0021-1.701-.0821-2.3278-.0882-.6555-.2869-1.2839-.7966-1.7935l-1.4142 1.4142ZM16 4c.9711 0 1.5988.0021 2.0613.0643.4337.0583.5697.1525.6458.2286l1.4142-1.4142c-.5096-.5097-1.138-.7084-1.7935-.7966C17.701 1.998 16.9145 2 16 2v2ZM8 4h8V2H8v2Zm-2.7071.2929c.0761-.0761.212-.1703.6458-.2286C6.4012 4.0021 7.0289 4 8 4V2c-.9145 0-1.701-.0021-2.3278.0821-.6555.0882-1.2839.287-1.7935.7966l1.4142 1.4142ZM5 7c0-.971.0021-1.5988.0643-2.0613.0583-.4337.1525-.5697.2286-.6458L3.8787 2.8787c-.5097.5096-.7084 1.138-.7966 1.7935C2.998 5.299 3 6.0855 3 7h2Zm0 11.5V7H3v11.5h2ZM6.5 15C4.567 15 3 16.567 3 18.5h2c0-.8284.6716-1.5 1.5-1.5v-2Zm9.2071-7.7071c.3905.3905.3905 1.0237 0 1.4142l1.4142 1.4142c1.1716-1.1715 1.1716-3.071 0-4.2426l-1.4142 1.4142Zm-1.4142 0c.3905-.3905 1.0237-.3905 1.4142 0l1.4142-1.4142c-1.1716-1.1716-3.071-1.1716-4.2426 0l1.4142 1.4142Zm-2.5858 2.5858 2.5858-2.5858-1.4142-1.4142-2.5858 2.5858 1.4142 1.4142Zm-2-.5858.5858.5858 1.4142-1.4142-.5858-.5858-1.4142 1.4142Zm-1.4142 0c.3905-.3905 1.0237-.3905 1.4142 0l1.4142-1.4142c-1.1715-1.1716-3.071-1.1716-4.2426 0l1.4142 1.4142Zm0 1.4142c-.3905-.3905-.3905-1.0237 0-1.4142L6.8787 7.8787c-1.1716 1.1715-1.1716 3.071 0 4.2426l1.4142-1.4142ZM9.5858 12l-1.293-1.2929-1.4141 1.4142 1.2929 1.2929L9.5858 12Zm2.8284 0c-.781.781-2.0474.781-2.8284 0l-1.4142 1.4142c1.562 1.5621 4.0947 1.5621 5.6568 0L12.4142 12Zm3.2929-3.2929L12.4142 12l1.4142 1.4142 3.2929-3.2929-1.4142-1.4142ZM11 20H6.5v2H11v-2Zm-8-1.5C3 20.433 4.567 22 6.5 22v-2c-.8284 0-1.5-.6716-1.5-1.5H3Z"
            />
            <path stroke="currentColor" d="M20 21H10" strokeWidth="2" />
        </svg>
    );
}
export default BookCheckFill;
