import React, { SVGProps } from "react";

export function BellPin(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M14.4553 2.4736A6.5694 6.5694 0 0 0 12 2C8.644 2 5.8246 4.5235 5.454 7.859l-.2519 2.2662-.006.0541a7.0002 7.0002 0 0 1-.939 2.7818l-.028.0466-.578.9634-.0242.0403c-.2415.4024-.4603.7671-.606 1.0765-.1482.3145-.3065.7407-.2303 1.2238.0754.4776.3211.9116.6919 1.222.375.3139.8219.3973 1.1678.4321.3404.0343.7656.0342 1.235.0342h12.2293c.4694 0 .8947.0001 1.2351-.0342.3458-.0348.7927-.1182 1.1678-.4321a2 2 0 0 0 .6918-1.222c.0763-.4831-.0821-.9093-.2302-1.2238-.1458-.3094-.3646-.6741-.6061-1.0765l-.0242-.0403-.578-.9634-.0279-.0466a6.9986 6.9986 0 0 1-.8148-2.0471A5.023 5.023 0 0 1 18 11c-.384 0-.7578-.0433-1.117-.1252a9.0014 9.0014 0 0 0 1.1412 3.1091l.0316.0528.5781.9634c.2735.4559.4383.7329.5358.94l.0147.0319a2.3108 2.3108 0 0 1-.0349.0039c-.2278.0229-.5502.0241-1.0818.0241H5.9322c-.5316 0-.854-.0012-1.0817-.0241a2.3372 2.3372 0 0 1-.035-.0039 2.11 2.11 0 0 1 .0147-.0319c.0976-.2071.2624-.4841.5359-.94l.578-.9634.0316-.0528a9.0003 9.0003 0 0 0 1.2073-3.5766l.0069-.0612.2518-2.2662C7.6997 5.7572 9.663 4 12 4c.463 0 .9113.069 1.3347.1977a5.004 5.004 0 0 1 1.1206-1.724Zm2.5268 1.8044C16.3942 4.6263 16 5.2671 16 6c0 .145.0154.2865.0447.4227.1204.2249.2228.4613.305.7075C16.7101 7.6555 17.3148 8 18 8c.1918 0 .3774-.027.5531-.0775l-.0071-.0635a6.564 6.564 0 0 0-1.5639-3.581Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                stroke="currentColor"
                d="M9.1022 17.6647c.171.9568.5476 1.8023 1.0715 2.4054.5239.603 1.1659.9299 1.8263.9299.6604 0 1.3024-.3269 1.8263-.9299.5239-.6031.9006-1.4486 1.0715-2.4054"
                strokeWidth="2"
            />
            <circle
                cx="18"
                cy="6"
                r="2.5"
                fill="currentColor"
                stroke="currentColor"
            />
        </svg>
    );
}
export default BellPin;
