---
title: Fiction Announces Launch of World's First Professional Generative Media Platform
description: On March 15th, Fiction launched the world's first platform focused on helping professionals create with AI.
authorName: Andrew R. Powers
authorWebsite: https://www.andrewpowers.com
authorEmail: andrew@fiction.com
authorTwitter: arpowers
publishDate: 2023-3-15
---

## Summary

- Fiction is the first no-code AI platform that helps professionals create images, videos and media with AI
- The Fiction platform reduces friction when sourcing and customizing media. It helps users create exactly what they're looking for, in the style they want it, in the moment they need it.
- Fiction allows non-technical users to train custom AI models by uploading images, then they can use those models to generate new images, videos with a growing list of AI tools
- Fiction features no-code multi-concept training that can be used to combine people, styles, objects, and into the same pictures. A common professional use case being stylizing media to match brand guidelines.
- Fiction also integrates a growing list of leading open-source AI Tools like [Stable Diffusion WebUI](https://github.com/AUTOMATIC1111/stable-diffusion-webui). Fiction is the first platform to integrate this tool into a no-code platform.
- Fiction is available to try free at [fiction.com](https://www.fiction.com). After trial, pricing is based on the amount of GPU time used.

![Fiction AI Platform](./image.jpg)

## Press Release

_IRVINE--(BUSINESS WIRE)--_ Today, Fiction.com came out of stealth to launch the world's first AI media generation platform focused on professionals. The new platform is built to address the friction professionals face when sourcing and customizing media. The platform helps users create exactly what they're looking for, in the style they want it, in the moment they need it.

Fiction allows non-technical marketers, writers, designers, and other professionals to train custom AI models by uploading images, then they can use those models to generate new images, videos with a growing list of AI tools. Fiction features no-code multi-concept training that can be used to combine people, styles, objects, and into the same pictures.

"The primary pain point we're solving is reducing the time, energy, and collaboration needed to create professional grade media assets. Right now, it's a very manual process that requires a lot of back and forth between teams. We're making it easy for anyone to do quality work in minutes, not days or weeks," said Fiction CEO Andrew Powers.

To help with customization and fine-tuning, Fiction also integrates a growing list of leading open-source AI Tools like [Automatic1111 SD WebUI](https://github.com/AUTOMATIC1111/stable-diffusion-webui). Which is the leading open-source tool for image editing with AI.

Stable Diffusion WebUI is an amazing tool that includes inpainting, outpainting, batching, and more but currently must be self-hosted or run via Python notebooks. Fiction is the first platform to integrate this tool into a no-code platform.

"Before Fiction, working with AI was a very technical process. You needed to know how to code, and you needed to know how to use complicated tools like Python notebooks. When I started, I remember how frustrating it was debugging GPU libraries and Python dependencies. That's when it occured to me there was an opportunity to make this easier for people." said Fiction CEO Andrew Powers.

Unlike existing AI tools Fiction differentiates itself by procuring a dedicated GPU for every customer. This allows customers to work at their own pace, without worrying about quotas. The experience is also more reliable, as customers don't have to worry about other customers using up all the GPU time.

"What makes Fiction unique is that it gives every customer their own dedicated server and GPU. This allows them to work with files and data that are too large to be processed on a shared server. It also allows them to train and retrain models with full control. On the other hand, it allows us to cultivate an amazing experience, by abstracting away all the bugs, coding, and technical issues." said Fiction CEO Andrew Powers.

Fiction is available to try free at [fiction.com](https://www.fiction.com). After trial, pricing is based on the amount of GPU time used.

## Resources

- [Video: Walkthrough/Tutorial](https://youtu.be/_XFEtyo2tz4)
- [Video: What makes us human?](https://youtu.be/CMzmXX4fgW4)
- [Video: Explore the Impossible](https://youtu.be/_HvYXAF4Ea8)

Andrew Powers
[andrew@fiction.com](mailto:andrew@fiction.com)
