---
title: Introducing Fiction, The AI Platform for Designers
description: Fiction is the first no-code AI platform that helps professionals create images, videos and media with AI
authorName: Andrew R. Powers
authorWebsite: https://www.andrewpowers.com
authorEmail: andrew@fiction.com
authorTwitter: arpowers
publishDate: 2023-3-15
---

<iframe width="100%" height="400" src="https://www.youtube.com/embed/CMzmXX4fgW4?rel=0&modestbranding=1&showinfo=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Introducing Fiction

Hey, everyone! We're excited to share the launch of [Fiction](https://www.fiction.com), an AI platform that will help you create images, videos, and other media with AI.

If you're a creator, marketer, or someone who wants to explore the possibilities of AI, we created Fiction for you.

## Professional Image Generation

As a professional, you want to create images and media of specific concepts.

For example:

- **Avatars:** you might want a linkedin profile picture that looks like you, or you might want to create a custom avatar for your game.
- **Images:** You might want to create ads for your brand or product, or you might want to create a custom website image in a specific style.

But to create images of specific concept, you need to train AI models. Which is tough because you'll need to know how to code, and you'll need to know how to use a command line.

Fiction was created to make this process easy.

In essence, Fiction is a no-code platform for creating "custom" AI models, that you can use to suit your purpose.

## Fiction's Superpowers

If you have a specific concept, for example a specific person, style or design, Fiction allows you to model it and generate infinite renditions of it.

A few features Fiction excels at:

- **Generate Avatars for Yourself Or Friends**: It's really fun to create your own AI generated avatars. Unlike avatar generators which just email you some images made with canned prompts, Fiction lets you train your own models and render as many images as you want until you get the perfect result.
- **Creating Mockups For Clients**: Train a model to understand a design style or concept, then use it to render different ideas for your clients. It's a great way to ideate, get feedback, and iterate on designs.
- **Product Ads, Social Media, and More**: Have a post or ad on a specific subject? Quickly train a model to create images for the posts and thumbs. For example, if you're making a youtube video about a specific topic, you can train a model to create images for the thumbnail.
- **Videos, Image Editing**: Fiction also includes Stable Diffusion WebUI and other professional AI tools. You can use these to create videos, edit images, and more.

Check out this video demo of Fiction:

<iframe width="100%" height="400" src="https://www.youtube.com/embed/_XFEtyo2tz4?rel=0&modestbranding=1&showinfo=0`" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Your AI Toolkit

Fiction gives every organization it's own AI toolkit, your own "server" tuned for AI.

This allows you to do some awesome stuff you just won't find elsewhere.

Some examples...

- **More Control, No Quotas**: Train and retrain your own AI models as much as you want. Since you control your server, you don't need to worry about quotas or deal with wait times. It's all about trial and error!
- **Infinite Render, Better Results**: With your own models, you can render as many images and videos as you want until you get the perfect result.
- **Pro Tools In the Box**: Fiction preinstalls popular tools like [Stable Diffusion WebUI](https://github.com/AUTOMATIC1111/stable-diffusion-webui). Just start your server and you're ready to go! More coming soon...
- **Your Workspace** You have access to all your files via Fiction's web-based file manager. You can also upload your own files if needed.

## What's on the Horizon?

We're just getting started and are eager for feedback. Here's what we're working on:

- **More Tools**: We're adding more tools to Fiction and simplifying the process of installing your own.
- **More Models**: There's a vast array of models out there, and we're taking requests for the next additions

## Start Building Your AI Toolkit

Give Fiction a try for free at [fiction.com](https://studio.fiction.com). After the trial, pricing is simply based on the amount of GPU time used. You can also [contact us](mailto:hello@fiction.com) with specific questions.
