import type { MediaObject } from '@fiction/core'
import FictionLogo from '../brand/FictionLogo.svg?raw'
import Lorem1 from './img/lorem1.svg?raw'
import Lorem2 from './img/lorem2.svg?raw'
import Lorem3 from './img/lorem3.svg?raw'
import Lorem4 from './img/lorem4.svg?raw'
import Lorem5 from './img/lorem5.svg?raw'
import Lorem6 from './img/lorem6.svg?raw'
import Lorem7 from './img/lorem7.svg?raw'
import Lorem8 from './img/lorem8.svg?raw'
import Lorem9 from './img/lorem9.svg?raw'

export type LocalMediaKeys = keyof typeof localMedia

export const localMedia = {
  fictionLogo: {
    format: 'html',
    html: FictionLogo,
    tags: ['brand', 'logo'],
  },
  fictionIconInline: {
    format: 'html',
    html: `<svg preserveAspectRatio="xMidYMid meet" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M34.5005 41H17.187C16.0637 41 15.0057 40.5523 14.211 39.7352L1.01935 26.2084C0.0221016 25.1882 -0.272797 23.6627 0.265224 22.3287C0.805496 20.9924 2.06388 20.1269 3.47534 20.1269H19.6407V3.55352C19.6407 2.11105 20.4827 0.820906 21.7838 0.266998C23.0647 -0.279986 24.591 0.0315868 25.5702 1.03554L38.7686 14.5671C39.5633 15.3864 40 16.4688 40 17.6182V35.364C39.9977 38.4728 37.5328 41 34.5005 41ZM17.9119 34.9024H34.0525V18.3544L25.5882 9.67651V26.2245H9.4476L17.9119 34.9024Z" fill="currentColor" /></svg>`,
  },
  stripeBadgeInline: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" ><g fill="none" fill-rule="evenodd">   <rect     width="173"     height="27"     x=".5"     y=".5"     stroke="currentColor"     opacity=".5"     rx="6"   />   <path     fill="currentColor"     d="M79.79 11.12L77.1 18h-1.44l-2.7-6.88h1.71l1.71 4.63 1.71-4.63h1.7zm.78 6.88v-6.88h4.34v1.36h-2.67v1.37h2.28v1.31h-2.28v1.48h2.75V18h-4.42zm7.34-5.56v1.82h.76c.57 0 .98-.39.98-.91 0-.54-.41-.91-.98-.91h-.76zM86.28 18v-6.88h2.61c1.42 0 2.43.92 2.43 2.23 0 .89-.47 1.61-1.26 1.99L91.59 18h-1.78l-1.34-2.43h-.56V18h-1.63zm6.4 0v-6.88h1.67V18h-1.67zm3.31 0v-6.88h4.34v1.36h-2.67v1.63h2.28v1.36h-2.28V18h-1.67zm5.47 0v-6.88h1.67V18h-1.67zm3.31 0v-6.88h4.34v1.36h-2.67v1.37h2.28v1.31h-2.28v1.48h2.75V18h-4.42zm5.71 0v-6.88h2.73c1.99 0 3.4 1.43 3.4 3.44S115.2 18 113.21 18h-2.73zm1.67-5.52v4.16h.98c1.05 0 1.78-.85 1.78-2.08s-.73-2.08-1.78-2.08h-.98zm8.17 5.52v-6.88h2.65c1.44 0 2.46.94 2.46 2.27s-1.02 2.25-2.46 2.25h-1.02V18h-1.63zm1.63-5.56v1.89h.8c.59 0 1.02-.39 1.02-.94 0-.57-.43-.95-1.02-.95h-.8zm3.12 5.56l2.7-6.88h1.44L131.9 18h-1.62l-.53-1.42h-2.53L126.7 18h-1.63zm3.42-4.87l-.81 2.21h1.61l-.8-2.21zm5.82-.69v1.82h.76c.57 0 .98-.39.98-.91 0-.54-.41-.91-.98-.91h-.76zM132.68 18v-6.88h2.61c1.42 0 2.43.92 2.43 2.23 0 .89-.47 1.61-1.26 1.99l1.53 2.66h-1.78l-1.34-2.43h-.56V18h-1.63zm7.64 0v-5.52h-1.99v-1.36h5.63v1.36h-1.98V18h-1.66zm4.7 0v-6.88h1.44l3.1 4.24v-4.24h1.55V18h-1.44l-3.09-4.24V18h-1.56zm7.73 0v-6.88h4.34v1.36h-2.67v1.37h2.28v1.31h-2.28v1.48h2.75V18h-4.42zm7.34-5.56v1.82h.76c.57 0 .98-.39.98-.91 0-.54-.41-.91-.98-.91h-.76zM158.46 18v-6.88h2.61c1.42 0 2.43.92 2.43 2.23 0 .89-.47 1.61-1.26 1.99l1.53 2.66h-1.78l-1.34-2.43h-.56V18h-1.63zM51 10.068L65 7v10.935L51 21V10.068zm5.323 6.469a.778.778 0 001.07-.004l3.814-3.664a.726.726 0 000-1.048.778.778 0 00-1.078 0l-3.27 3.129-.986-.9a.778.778 0 00-1.078 0 .726.726 0 000 1.048l1.528 1.439zM42.97 15.07h-4.428c.1 1.093.877 1.415 1.759 1.415.899 0 1.606-.194 2.223-.516v1.88c-.615.351-1.427.605-2.508.605-2.204 0-3.748-1.423-3.748-4.237 0-2.376 1.31-4.263 3.462-4.263 2.15 0 3.27 1.886 3.27 4.276 0 .225-.02.714-.03.84zm-3.254-3.214c-.566 0-1.195.44-1.195 1.492h2.34c0-1.05-.59-1.492-1.145-1.492zm-7.037 6.598c-.791 0-1.275-.345-1.6-.59l-.005 2.64-2.262.496-.001-10.89h1.992l.118.576a2.495 2.495 0 011.773-.732c1.588 0 3.085 1.476 3.085 4.192 0 2.965-1.48 4.308-3.1 4.308zm-.526-6.434c-.52 0-.845.196-1.08.463l.013 3.467c.219.245.536.443 1.067.443.836 0 1.397-.94 1.397-2.196 0-1.22-.57-2.177-1.397-2.177zm-6.538-1.91h2.271v8.177h-2.27v-8.178zm0-2.612L27.885 7v1.9l-2.27.498v-1.9zm-2.346 5.245v5.544h-2.262v-8.178h1.956l.143.69c.529-1.004 1.587-.8 1.888-.69v2.145c-.288-.096-1.19-.235-1.725.489zm-4.775 2.675c0 1.375 1.427.947 1.717.827v1.9c-.301.17-.848.309-1.588.309-1.343 0-2.35-1.02-2.35-2.401l.01-7.486 2.209-.484.002 2.026h1.718v1.99h-1.718v3.319zm-2.746.398c0 1.68-1.296 2.638-3.178 2.638a6.11 6.11 0 01-2.474-.53v-2.227c.76.426 1.727.745 2.477.745.504 0 .868-.14.868-.57 0-1.115-3.44-.695-3.44-3.278 0-1.652 1.224-2.64 3.059-2.64.75 0 1.499.119 2.248.427v2.197c-.688-.383-1.562-.6-2.25-.6-.474 0-.769.14-.769.505 0 1.05 3.46.551 3.46 3.333z"/></g></svg>`,
  },
  lorem1: { format: 'html', html: Lorem1, tags: ['lorem', 'image'] },
  lorem2: { format: 'html', html: Lorem2, tags: ['lorem', 'image'] },
  lorem3: { format: 'html', html: Lorem3, tags: ['lorem', 'image'] },
  lorem4: { format: 'html', html: Lorem4, tags: ['lorem', 'image'] },
  lorem5: { format: 'html', html: Lorem5, tags: ['lorem', 'image'] },
  lorem6: { format: 'html', html: Lorem6, tags: ['lorem', 'image'] },
  lorem7: { format: 'html', html: Lorem7, tags: ['lorem', 'image'] },
  lorem8: { format: 'html', html: Lorem8, tags: ['lorem', 'image'] },
  lorem9: { format: 'html', html: Lorem9, tags: ['lorem', 'image'] },
  logoCoke: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="-29.999685 -16.372025 259.99727 98.23215"><path d="M167.1059 55.846c-.003 0-.6185.5488-.6185.5488-.8795.7863-1.7845 1.628-2.877 1.207-.3018-.1097-.514-.5117-.565-.8237-.0497-2.2505.9637-4.3358 1.9465-6.3662l.252-.531c2.827-4.7202 6.113-10.282 10.939-14.142.8132-.5868 1.6958-1.0798 2.6272-.6953.2142.2008.4637.5488.4637.896 0 .1103-.0977.4028-.1542.4938-1.3478 2.1782-2.6315 4.465-3.8798 6.6602-2.4395 4.3365-4.9702 8.8185-8.134 12.753zm-26.149-11.124c-.1847.1288-3.445-.9694-4.075-3.9881-.5345-2.599 1.2552-4.6298 2.9868-5.6535.7432-.5858 1.8628-.7865 2.684-.495.7622.513.9688 1.4285.9688 2.415 0 .605-.0803 1.2265-.151 1.7935l-.0158.1285c-.5432 2.0302-1.3745 4.0248-2.3978 5.7998zm-12.454 12.277c-.3325-.494-.4428-1.0341-.4538-1.6181-.0638-3.5875 3.796-10.012 6.5205-13.512h.006c1.1418 2.5 3.7272 4.107 5.288 4.7842-1.9385 4.3182-8.5868 13.566-11.36 10.346zm47.054.637c-.6453.439-1.5518.1016-1.2128-.9044.8442-2.5615 4.2008-7.7815 4.2008-7.7815l9.349-16.582h-6.404c-.3043.5-.9553 1.6482-.9553 1.6482-.2962-.4935-1.1822-1.591-1.547-1.828-1.5645-.9888-3.86-.5213-5.4435.375-6.8848 4.0258-11.908 11.98-15.87 18.182 0 0-4.1702 6.895-6.4852 7.4078-1.8072.1465-1.6208-2.288-1.5425-2.8552.6988-4.099 2.3215-7.9958 3.9565-11.527 3.3252-2.3052 7.1202-5.324 10.569-8.6355 7.4845-7.1545 13.794-15.26 14.716-17.071 0 0-.9982.2015-2.177.2377-5.758 8.032-17.541 19.706-21.113 21.443 1.5825-3.8062 11.807-21.974 20.508-30.664l1.3693-1.3178c2.117-2.0675 4.3108-4.1898 6.0202-4.5375.1805-.0182.413 0 .6137.4215.0763 1.6098-.523 2.7992-1.2105 4.153l-.9635 1.9763s1.3648-.2562 2.261-.5497c1.04-1.9568 2.1918-4.153 1.7672-6.7688-.1417-.8418-.751-1.482-1.5472-1.6285-2.5955-.494-5.4242 1.4265-7.7002 2.9822l-.092.0545c-11.7 9.1665-21.58 22.377-30.218 40.417-.626.475-3.0448 1.0428-3.456.768.853-1.756 1.927-4.1168 2.4645-6.6782.093-.732.1795-1.4818.1795-2.2135 0-1.5748-.378-3.0562-1.7888-4.0805-1.654-.8235-3.6982-.439-5.0765.1827-6.1745 2.5615-10.789 8.8925-14.119 14.106-1.791 3.3125-3.5768 6.8602-4.0712 10.923-.3483 3.183.3607 5.2322 2.1705 6.2572 1.8612.9508 4.2038-.0375 5.124-.5127 6.2552-3.2932 10.626-9.8978 14.071-15.936.137-.018 2.018-.0725 3.4408-.439.019 0 .027 0 .0585.0192-.0815.2732-.8168 2.4695-.8168 2.4695-2.1835 6.4032-3.1932 10.758-1.1308 13.338 2.9472 3.6412 7.8265-.1275 11.796-5.105-.852 5.9645 2.2392 6.898 4.5955 6.441 2.7068-.7315 5.723-3.623 7.1228-5.1045-.4495 1.7378-.3272 4.8485 2.135 5.1592 1.6878.312 2.9508-.606 4.4122-1.393 5.2422-2.8545 11.518-12.366 13.147-15.116h-2.1362c-2.316 3.5002-5.2632 8.0895-8.9705 10.268zm-80.761-35.518h5.9998l3.3862-5.5h-6.001zm95.841-14.611c-4.5748 2.5986-9.317 4.2814-15.058 3.696-1.591 1.7936-3.14 3.6413-4.5678 5.5439 8.0572 2.0492 16.599-2.5065 21.363-6.8422 5.0395-4.373 7.6238-9.8797 7.6238-9.8797s-3.7775 4.3175-9.3612 7.4822zm-50.45-1.39c-.954 10.941-9.4588 17.364-11.563 17.875-1.2752.2558-3.4512-.311-1.5088-4.9027 2.8608-6.1848 7.7448-11.435 12.985-14.125.1275.4575.1242.7495.0867 1.1525zm-16.572 27.572c-.6093-1.317-2.0558-2.1587-3.5972-2.0674-5.0058.4577-9.902 4.5742-12.473 10.484-1.349 3.0375-2.0852 5.5438-2.568 9.5322 1.5565-1.7925 4.7315-4.738 8.3345-6.3482 0 0 .4902-3.8238 2.9902-7.227.946-1.4092 2.8392-3.6778 4.965-3.0742 1.8572.6225 1.2045 5.7638-1.264 10.739-1.8265 3.6598-4.6215 7.32-7.4495 9.8442-2.5002 2.1225-6.1995 4.6838-9.436 2.708-2.0385-1.207-3.0782-3.7325-2.8585-6.9892.974-9.2392 5.1798-17.107 11.198-26.072 6.206-8.3248 13.047-16.869 22.263-21.426 1.8798-.9513 3.6205-1.1708 5.1252-.5853 0 0-8.651 4.757-12.775 13.558-1.049 2.2325-2.508 5.2505-1.0388 7.922.7677 1.3902 2.131 1.5002 3.2285 1.427 5.0548-1.1712 8.3205-5.8915 10.989-10.209 1.547-3.275 2.922-6.5318 2.922-10.155 0-.439-.0228-1.0242-.06-1.4638 2.415-1.2802 7.367.988 7.367.988 3.8698 1.2812 12.11 7.5938 14.889 8.8008 1.3558-1.5732 3.5838-3.9515 4.8382-5.141l-1.816-1.1162c-2.9075-1.7748-5.9808-3.4582-9.0058-5.123-6.8698-3.7502-12.462-2.4332-15.308-1.4085-1.1185.4023-2.1408.75-2.1408.75-2.112-2.3052-5.5758-2.0862-8.128-1.4637-9.1785 2.6345-17.7 9.0562-26.836 20.199-6.717 8.7275-10.884 16.266-13.104 23.712-1.7118 5.0128-2.232 12.386 1.946 16.759 3.5522 3.713 8.2625 2.9088 11.589 1.5735 7.2068-3.5495 13.684-11.198 16.912-19.998.7788-2.616 1.6432-6.3118.3023-9.1298zm-79.885-8.4887c-.012.0365-1.224 2.8172-1.224 2.8172-.1752.1462-.4522.0733-.7697 0l-.544-.092c-1.7082-.5303-2.9968-1.6648-3.394-3.0185-.548-2.6348 1.7028-4.7022 2.6945-5.452.9515-.6593 2.4308-1.0068 3.2898-.3295.5297.6222.7305 1.427.7305 2.3058.0002 1.189-.3668 2.5245-.783 3.769zm-2.6035 5.287s-.055.1652-.0822.2192c-.007 0-2.755 4.482-2.755 4.482-1.6585 2.2142-3.7292 4.996-6.3178 6.331-.7672.2563-1.8278.4213-2.3682-.2552-1.1458-1.3725-.5552-3.2752-.0755-4.812l.1698-.549c1.3755-3.732 3.558-7.026 5.6822-10.082.0265-.018.086-.0362.1075-.0362.005.0183.0135.0183.0172.055 1.333 2.561 3.8325 3.7498 5.7018 4.2995.0113 0 .0233.0182.0233.055.0002.0545-.0303.1282-.103.2922zm34.376-2.9455c1.2292-1.7012 4.807-6.2572 5.6792-7.0255 2.9335-2.5808 4.106-1.4452 4.2075-.6408-2.7378 4.9032-5.969 10.52-9.007 15.57.006-.018-.9507 1.4452-.9507 1.4452-1.3418 2.0488-2.6928 3.8052-4.8965 5.031-.3143.092-.8323.1288-1.177-.1282-.415-.2745-.5788-.732-.532-1.208.132-1.573 1.7338-6.384 6.6765-13.044zm-30.465-11.124c-3.7925-2.4882-11.415 2.2688-17.52 10.428-5.583 7.3192-7.9938 15.826-5.3702 19.76 3.9028 4.6288 11.148-2.104 14.229-5.7078l.3975-.4213c2.0952-2.2505 3.714-4.9585 5.2808-7.5568 0 0 1.44-2.3785 1.5088-2.4885.89-.164 1.962-.4202 3.17-.768-.0172.0545-4.6218 7.794-4.152 11.636.1463 1.172.0345 5.4532 4.2145 6.752 5.571.9338 10.02-3.3848 13.944-7.227 0 0 .6688-.6397 1.047-1.005a215.179 215.179 0 00-.2205.8945c-1.631 5.672.5675 6.862 1.9428 7.3012 4.1562 1.2082 9.1215-4.83 9.1375-4.83-.1287 1.902-.5052 3.4755 1.4998 4.738 1.8925.6775 3.8078-.3552 5.2635-1.325 5.2438-3.6958 9.4682-9.48 12.88-14.48h-2.1765c-.0257 0-5.3708 7.747-8.8415 9.4308-.005 0-.637.3243-1.001.0677-.4505-.3845-.2727-1.1835.005-1.7495.0175-.037 13.401-23.249 13.401-23.249h-6.319s-.6902 1.1168-.7465 1.19c-.0425-.0365-.1437-.2285-.214-.3205-3.915-5.4155-12.781 2.9145-19.456 12.574-2.5698 3.7145-5.8415 7.8968-9.234 10.916 0 0-5.0258 4.607-7.1732 1.297-.785-1.3908-.5435-3.424-.1007-4.7592 2.5002-7.1172 6.8085-13.576 11.711-17.474 1.384-1.0788 2.8882-1.3908 3.6348-.9332.7112.4215.826 1.4635.376 2.1772-1.1418-.0365-2.0565.3105-2.8002 1.079-1.465 1.537-1.974 3.0192-1.5082 4.41 2.2628 3.22 6.7755-3.1472 6.5572-7.026-.078-1.3908-.82-2.7078-1.9272-3.3488-1.6502-.9875-4.1678-.7318-5.797.0555-2.181.823-5.6335 3.6952-7.6488 5.9278-2.537 2.7998-6.888 5.9098-8.2488 5.5615.4457-1.1898 4.121-8.7092.2547-11.526zm31.762 40.709c-7.442-4.794-17.542-5.6352-33.83-1.1162-17.364 4.0805-23.154 6.6962-30.757 1.4452-2.921-2.5795-3.9683-6.7328-3.1862-12.715 1.8138-9.7525 6.7152-19.138 15.422-29.548 4.8598-5.4155 9.3675-10.063 15.32-11.929 4.562-1.1708 4.1355 2.4145 3.5835 2.9272-.5825 0-1.561.0918-2.3172.5852-.6137.476-2.2985 2.013-2.389 4.0805-.1305 3.165 3.145 2.5062 4.5578.7685 1.5228-1.9582 3.7732-5.7083 2.003-9.2033-.742-1.244-2.024-2.1037-3.6158-2.3965-5.4505-.3115-10.527 2.2867-15.212 5.1592-10.243 7.117-18.439 16.979-23.076 27.774-2.6738 6.5132-5.0918 15.843-1.4672 23.437 2.8038 5.269 8.6248 8.0678 15.57 7.4825 4.8708-.5117 10.76-2.086 14.722-3.0365 3.9612-.952 24.238-7.9222 30.901 4.209 0 0 2.2155-4.3008 7.7522-4.3925 4.552-.42 11.119 1.3178 15.901 4.83-1.5932-2.396-6.1102-5.9272-9.8785-8.361z" fill="currentColor"/></svg>`,
  },
  logoRoblox: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="-150 -43.45625 1300 260.7375"><path fill="currentColor" style="line-height:125%;-inkscape-font-specification:'Gill Sans Ultra Bold, Bold';text-align:start;isolation:auto;mix-blend-mode:normal;solid-opacity:1" d="M198.435 0l-35.826 137.998 137.998 35.827 35.826-137.998zM0 15.34v143.165h63.327v-53.006c8.944 0 15.51 4.315 19.7 12.946 4.253 8.631 6.975 21.984 8.163 40.06h65.766c-3.003-28.083-12.228-50.942-27.677-68.58 10.883-7.63 16.325-18.2 16.325-31.71 0-12.26-4.628-22.454-13.885-30.584-9.256-8.194-21.985-12.29-38.184-12.29zm350.645 0v143.165h99.915c15.511 0 27.551-3.596 36.12-10.789 8.631-7.192 12.946-16.793 12.946-28.802 0-7.693-1.906-14.103-5.722-19.232-3.815-5.191-9.413-9.726-16.793-13.604 12.446-7.068 18.67-17.324 18.67-30.771 0-12.322-4.691-22.048-14.073-29.178-9.319-7.192-23.142-10.788-41.467-10.788zm168.125 0v143.165h118.96v-35.932h-55.54V15.341zm298.476 0l55.915 70.738-55.915 72.427h68.861l21.86-28.426 22.703 28.426H1000l-57.603-72.802 54.133-70.362h-68.768l-20.17 26.362-21.11-26.362zm-159.75.286V158.2H800.07V15.626zm-243.43 28.516h3.846c11.133 0 16.7 4.629 16.7 13.885 0 5.129-1.44 8.756-4.316 10.883-2.877 2.064-7.755 3.096-14.635 3.096h-1.595zm-350.74.657h3.847c5.379 0 9.225 1.438 11.539 4.315 2.314 2.815 3.472 6.1 3.472 9.852 0 8.944-5.692 13.415-17.075 13.415h-1.782zm176.328 25.327l26.652 6.92-6.92 26.653-26.65-6.92zm475.36 3.019h27.537v27.535h-27.536zM414.067 96.023h4.409c11.82 0 17.732 5.378 17.732 16.136 0 5.441-1.564 9.288-4.69 11.54-3.066 2.19-8.226 3.283-15.48 3.283h-1.971z" color="currentColor" font-weight="700" font-size="314" font-family="Gill Sans Ultra Bold"/></svg>`,
  },
  logoTesla: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="-41.8008 -9.08425 362.2736 54.5055"><path fill="currentColor" d="M238.077 14.382v21.912h7.027V21.705h25.575v14.589h7.022V14.42l-39.624-.038m6.244-7.088h27.02c3.753-.746 6.544-4.058 7.331-7.262h-41.681c.779 3.205 3.611 6.516 7.33 7.262m-27.526 29.014c3.543-1.502 5.449-4.1 6.179-7.14h-31.517l.02-29.118-7.065.02v36.238h32.383M131.874 7.196h24.954c3.762-1.093 6.921-3.959 7.691-7.136h-39.64v21.415h32.444v7.515l-25.449.02c-3.988 1.112-7.37 3.79-9.057 7.327l2.062-.038h39.415V14.355h-32.42V7.196m-61.603.069h27.011c3.758-.749 6.551-4.058 7.334-7.265H62.937c.778 3.207 3.612 6.516 7.334 7.265m0 14.322h27.011c3.758-.741 6.551-4.053 7.334-7.262H62.937c.778 3.21 3.612 6.521 7.334 7.262m0 14.717h27.011c3.758-.747 6.551-4.058 7.334-7.263H62.937c.778 3.206 3.612 6.516 7.334 7.263M0 .088c.812 3.167 3.554 6.404 7.316 7.215h11.37l.58.229v28.691h7.1V7.532l.645-.229h11.38c3.804-.98 6.487-4.048 7.285-7.215v-.07H0v.07"/></svg>`,
  },
  logoBalenciaga: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="-19.2 -3.75 166.4 22.5"><path fill="currentColor" d="M121.61 2.586h.087c.2.948.287 1.38.49 2.068l1.18 4.656h-3.455l1.18-4.656c.173-.688.288-1.12.517-2.068m3.137 12.213H128L123.914.285h-4.434L115.364 14.8h3.08l.92-3.248h4.462zm-16.435.2c1.785 0 3.512-.43 4.636-.89V6.84h-5.01v2.327h2.045v3.246c-.375.23-1.01.375-1.698.375-2.13 0-2.793-1.063-2.793-4.137V6.78c0-3.045.632-4.54 2.59-4.54 1.353 0 1.816.92 1.846 1.898h3.08C112.973 1.58 111.133 0 108.08 0c-4.262 0-5.814 2.47-5.814 6.467v2.127c-.03 4.338 1.44 6.406 6.044 6.406M93.892 2.586h.088c.2.948.288 1.38.488 2.068L95.65 9.31h-3.455l1.18-4.656c.172-.688.287-1.12.517-2.068M97.03 14.8h3.25L96.196.285H91.76L87.648 14.8h3.08l.92-3.248h4.46l.922 3.247zm-15.545 0h3.08V.285h-3.08zm-8.462.2c3.424 0 5.094-1.582 5.18-4.538h-3.107c-.058 1.436-.52 2.326-1.986 2.326-1.668 0-2.3-1.177-2.3-4.194V6.467c0-3.047.632-4.195 2.3-4.195 1.556 0 1.814 1.035 1.87 2.127h3.108C78.058 1.87 76.62.06 73.024.06c-4.002 0-5.468 2.5-5.468 6.407v2.127c0 3.936 1.465 6.406 5.467 6.406m-20.84-.2h2.736V6.38c0-1.178-.06-2.615-.118-3.794h.09c.43 1.494.66 2.27 1.063 3.39L59.15 14.8h4.49V.285h-2.735v8.078c0 1.06.03 2.47.058 3.82h-.086c-.23-1.007-.434-2.013-1.038-3.65L56.846.286h-4.69V14.8zm-12.55 0h8.376v-2.33h-5.296V8.447h4.805V6.093h-4.806V2.586h5.095V.258H39.63v14.54zm-11.253 0h8.06v-2.33h-4.98V.286h-3.08zM18.824 2.585h.087c.2.948.29 1.38.49 2.068l1.18 4.656h-3.453l1.18-4.656c.172-.688.288-1.12.517-2.068M21.962 14.8h3.253L21.127.285h-4.432L12.578 14.8h3.08l.92-3.248h4.463l.922 3.247zM3.108 12.586V8.364H4.98c1.583 0 2.33.718 2.33 2.124 0 1.55-.978 2.128-2.388 2.128H3.108zm0-6.437V2.5h1.93c1.408 0 2.013.63 2.013 1.81 0 1.18-.687 1.84-1.984 1.84H3.108zM.028 14.8h5.44c3.05 0 4.92-1.095 4.92-4.11 0-1.926-1.12-3.246-3.194-3.45v-.084c1.84-.316 2.936-1.322 2.936-3.247 0-2.502-1.44-3.622-4.518-3.622H0V14.8z"/></svg>`,
  },
  logoSpaceX: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 400 50"><g class="letter_s"><path fill="currentColor" d="M37.5 30.5H10.9v-6.6h34.3c-.9-2.8-3.8-5.4-8.9-5.4H11.4c-5.7 0-9 2.1-9 6.7v4.9c0 4 3.4 6.3 8.4 6.3h26.9v7H1.5c.9 3.8 3.8 5.8 9 5.8h27.1c5.7 0 8.5-2.2 8.5-6.9v-4.9c0-4.3-3.3-6.6-8.6-6.9z"/></g><g class="letter_p"><path fill="currentColor" d="M91.8 18.6H59v30.7h9.3V37.5h24.2c6.7 0 10.4-2.3 10.4-7.7v-3.4c-.1-5-4.3-7.8-11.1-7.8zm3 9.8c0 2.2-.4 3.4-4 3.4H68.3l.1-8h22c4 0 4.5 1.2 4.5 3.3v1.3z"/></g><g class="letter_a"><polygon fill="currentColor" points="129.9,17.3 124.3,24.2 133.8,37.3 114,37.3 109.1,42.5 137.7,42.5 142.6,49.3 153.6,49.3"/></g><g class="letter_c"><path fill="currentColor" d="M171.4 23.9h34.8c-.9-3.6-4.4-5.4-9.4-5.4h-26c-4.5 0-8.8 1.8-8.8 6.7v17.2c0 4.9 4.3 6.7 8.8 6.7h26.3c6 0 8.1-1.7 9.1-5.8h-34.8V23.9z"/></g><g class="letter_e"><polygon fill="currentColor" points="228.3,43.5 228.3,34.1 247,34.1 247,28.9 218.9,28.9 218.9,49.3 260.4,49.3 260.4,43.5"/><rect fill="currentColor" width="41.9" height="5.4" x="219.9" y="18.6"/></g><g class="letter_x"><path fill="currentColor" d="M287.6 18.6H273l17.2 12.6c2.5-1.7 5.4-3.5 8-5l-10.6-7.6zm21.2 15.7c-2.5 1.7-5 3.6-7.4 5.4l13 9.5h14.7l-20.3-14.9z"/></g><g class="letter_swoosh"><path fill="currentColor" d="M399 .7c-80 4.6-117 38.8-125.3 46.9l-1.7 1.6h14.8C326.8 9.1 384.3 2 399 .7z"/></g></svg>`,
  },
  logoBBC: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="-150 -71.25325 1300 427.5195"><path fill="currentColor" d="M541.817 184.201c0 30.971-38.541 29.133-38.541 29.133h-38.54v-55.963h38.54c39.663-.266 38.541 26.83 38.541 26.83M464.736 72.023h29.368c30.496 1.611 29.345 24.316 29.345 24.316 0 28.216-33.721 28.676-33.721 28.676h-24.992zm69.952 63.997s26.38-11.241 26.145-41.057c0 0 4.012-48.864-60.729-54.824h-71.838v204.849h82.344s68.802.205 68.802-57.799c-.001 0 1.626-39.473-44.724-51.169M348.773 0h302.453v285.013H348.773zM193.041 184.201c0 30.971-38.541 29.133-38.541 29.133h-38.543v-55.963H154.5c39.666-.266 38.541 26.83 38.541 26.83M115.957 72.023h29.374c30.497 1.611 29.343 24.316 29.343 24.316 0 28.216-33.719 28.676-33.719 28.676h-24.998zm69.958 63.997s26.384-11.241 26.147-41.057c0 0 4.009-48.864-60.732-54.824H79.489v204.849h82.349s68.801.205 68.801-57.799c0 0 1.621-39.473-44.724-51.169M0 0h302.453v285.013H0zm938.301 54.825v37.846s-36.942-22.702-77.764-23.159c0 0-76.161-1.495-79.594 73.005 0 0-2.751 68.513 78.676 72.417 0 0 34.165 4.115 80.514-25.441v39.195s-62.173 36.939-134.197 8.488c0 0-60.545-22.109-62.851-94.659 0 0-2.518-74.619 78.23-99.389 0 0 21.563-8.255 60.313-4.586.001-.001 23.161 2.29 56.673 16.283M697.547 285.013H1000V0H697.547z"/></svg>`,
  },
  logoNewspaper: {
    format: 'html',
    html: `<svg viewBox="0 0 193 35" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M186.346 19.3908L182.323 13.5788L181.651 13.8028L185.674 19.8388L186.346 19.3908ZM189.922 16.7078L182.098 22.7428V25.4268L185.004 28.1088L188.133 25.6498L180.981 31.4608L176.51 27.8848V15.5898C179.194 15.1428 182.545 13.5778 185.674 10.8958L189.922 16.7078ZM185.451 19.8378L182.097 14.9198V22.5198L185.451 19.8378ZM181.428 30.5658L177.405 27.4368V15.5898H176.735V27.8828L180.981 31.2368L181.428 30.5658ZM173.381 13.5778H170.252V14.4718H172.711L173.381 13.5778ZM169.805 30.5658L165.782 27.4368V13.5778H162.428L161.758 14.4718H164.887V27.6598L169.135 31.2358L169.805 30.5658ZM175.84 26.0958L169.135 31.4588L164.664 27.8828V14.6958H161.535V14.4718L163.992 11.1188H164.664V9.10682L163.992 7.76582C166.676 7.31882 168.687 3.96582 170.699 3.96582C171.146 3.96582 171.594 3.96582 171.816 4.18982C170.921 5.08382 170.252 6.20082 170.252 7.76582V11.1188H175.393L172.934 14.6948H170.252V25.4248L173.158 27.8818L175.615 26.0948L175.84 26.0958ZM165.781 11.1198V8.66082L165.111 7.54382C164.886 7.76682 164.216 7.99081 164.216 7.99081L164.886 9.10882V11.1208L165.781 11.1198Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M160.416 13.5778H157.287V14.4718H159.746L160.416 13.5778ZM156.84 30.5658L152.817 27.4368V13.5778H149.465L148.793 14.4718H151.924V27.6598L156.17 31.2358L156.84 30.5658ZM162.875 26.0958L156.17 31.4588L151.699 27.8828V14.6958H148.57V14.4718L151.029 11.1188H151.699V9.10682L151.029 7.76582C153.711 7.31882 155.722 3.96582 157.734 3.96582C158.181 3.96582 158.629 3.96582 158.851 4.18982C157.956 5.08382 157.287 6.20082 157.287 7.76582V11.1188H162.428L159.969 14.6948H157.287V25.4248L160.193 27.8818L162.652 26.0948L162.875 26.0958ZM152.816 11.1198V8.66082L152.146 7.54382C151.923 7.76682 151.251 7.99081 151.251 7.99081L151.923 9.10882V11.1208L152.816 11.1198ZM140.301 30.3418L136.278 27.2128V15.1428C136.053 15.3658 135.831 15.3658 135.606 15.3658V27.4368L139.629 30.7888L140.301 30.3418ZM148.57 16.4838L140.746 22.5198V25.2018L143.652 27.6608L146.781 25.2018L147.006 25.4268L139.629 31.0148L135.383 27.6608V15.1428C137.842 14.6958 141.194 13.3538 144.547 10.4488L148.57 16.4838ZM144.324 19.6128L140.97 14.6958L140.745 22.2948L144.324 19.6128ZM144.994 18.9428L140.971 13.1308L140.301 13.5778L144.324 19.6128L144.994 18.9428ZM128.453 30.5658C127.336 29.6708 125.099 29.0018 123.76 29.0018C122.418 29.0018 121.078 29.4488 119.737 30.1188C120.632 29.8938 122.196 29.8938 123.313 29.8938C125.325 29.8938 126.442 30.3408 127.784 31.2358L128.453 30.5658ZM128.23 15.5898C127.111 15.8138 125.771 15.8138 124.654 15.8138C122.865 15.8138 120.631 15.3668 119.066 14.2498L118.171 14.9198C119.958 16.0378 121.747 16.4838 123.982 16.4838C125.547 16.4838 126.666 16.0368 128.23 15.5898ZM134.488 26.0958L128.006 31.4588C126.666 30.5658 125.547 30.1188 123.313 30.1188C121.301 30.1188 119.29 30.5658 117.725 31.0138H117.5L123.76 22.9668H118.842L121.971 18.7188H126.889L129.348 15.3658C127.559 16.2598 125.772 16.7068 123.983 16.7068C121.749 16.7068 119.737 16.0368 118.172 14.9188L116.608 16.2598H116.383L122.865 10.8958C124.429 12.0138 125.994 12.4598 128.23 12.4598C129.794 12.2368 131.359 12.0128 132.253 11.5658V11.7898L127.11 18.7188L132.253 18.4958H132.476L129.122 22.7418L123.981 22.9668L121.299 26.3188C122.863 25.8718 124.653 25.4258 126.217 25.4258C128.451 25.4258 130.686 26.0958 132.252 27.6598L134.264 25.8708L134.488 26.0958ZM129.57 21.8498H119.736L119.066 22.7428H128.9L129.57 21.8498Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M113.031 30.5659L109.23 27.6599V16.7079L106.101 14.0259L105.206 14.4729L108.56 17.1549V28.1079L112.359 31.0139L113.031 30.5659ZM118.395 26.5429L112.36 31.2359L108.337 28.1069L103.421 31.4589C100.515 29.6719 98.7256 27.4379 98.7256 24.5309C98.7256 20.2829 101.185 18.7189 104.091 18.7189C105.431 18.7189 106.103 19.1659 106.55 19.8379C106.103 17.6019 104.538 15.8139 102.974 15.3659C100.738 14.2489 99.8426 14.0249 99.8426 12.6839C99.8426 11.3429 100.962 10.8959 101.855 10.8959C102.974 10.8959 103.867 11.5659 103.867 12.4599C103.867 13.5779 103.197 14.2489 102.527 14.4719C102.75 14.6959 102.974 14.6959 103.422 14.6959C105.656 14.6959 107.668 12.4609 109.01 10.6729L113.703 14.4729V25.4269L116.385 27.8839L118.395 26.5429ZM108.336 27.6599V17.3779L105.207 14.4719C104.537 14.9189 104.09 14.9189 103.42 14.9189H102.748C105.43 15.8129 106.996 18.9429 106.996 21.1769C106.996 22.2939 106.549 22.9659 106.101 23.1889H105.876C106.323 22.7419 106.771 22.2939 106.771 21.1769C106.771 19.6129 105.876 19.3899 104.984 19.3899C103.865 19.3899 103.642 20.2829 103.642 21.8489C103.642 25.6479 106.101 28.1069 107.665 28.1069C107.889 28.1069 108.113 28.1069 108.336 27.6599ZM104.09 30.5659C101.631 29.4489 99.8416 26.5429 99.8416 24.5309C99.8416 22.2949 100.289 20.9549 100.961 19.8379C100.066 20.5079 98.9486 21.8499 98.9486 24.5309C98.9486 27.6599 100.961 29.8939 103.42 31.2359L104.09 30.5659ZM71.9026 24.3069C74.1376 28.3299 78.1606 30.3419 81.9606 30.7889C78.8316 29.8939 75.2546 27.8829 73.2436 24.3069H77.4906C78.1606 25.2019 78.6076 26.3189 79.5026 26.9909L79.7256 26.7659V24.3069H79.9496V26.5429L80.8436 26.0959V24.3069H83.7496L79.5026 27.2129C81.0666 28.7769 83.5256 30.1189 85.5376 30.1189C85.9846 30.1189 86.6556 29.8939 87.1026 29.8939V24.3059H87.3266V29.6709C87.5496 29.6709 87.7736 29.4479 88.2206 29.4479V24.3049H88.4436V29.2229C90.2316 28.3279 91.5726 26.0939 92.2436 24.3049H92.4676C92.0206 25.8689 91.1266 27.2109 90.0096 28.1059L90.2326 28.3289C91.3506 27.6589 92.6916 26.3169 93.3626 24.3059H97.3866C95.5976 28.7769 89.7856 31.2359 85.0926 31.2359C79.0576 31.2359 74.1396 28.7769 71.6816 24.3059L71.9026 24.3069Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M71.6791 24.3068C70.7841 22.5198 70.3381 20.2838 70.3381 17.8268C70.3381 7.99078 78.1611 4.41378 82.6311 3.96778L82.8551 4.41478C79.2791 6.20278 77.0431 8.66178 76.1491 13.1328L89.5601 3.96778C90.4541 5.30878 91.5721 5.75578 92.6891 5.75578C94.7011 5.75578 96.2651 5.53278 97.3841 4.86178L97.6071 5.08578C91.1251 10.6738 87.9961 13.5798 87.9961 13.5798C92.2431 13.3558 98.0551 14.6978 98.0551 21.1798C98.0551 22.2968 97.8301 23.1918 97.3851 24.3088H93.3611C93.5841 23.4158 93.5841 22.7448 93.5841 21.8518C93.5841 17.1568 90.4551 15.8158 88.8901 15.5918C90.6781 16.4858 92.6901 18.2738 92.6901 21.8518C92.6901 22.7448 92.4661 23.4158 92.4661 24.3088H92.2421V23.8618C91.5721 23.4168 91.1251 23.1918 90.4541 23.1918C89.7841 23.1918 88.8901 23.4168 88.4421 23.8618V24.3088H88.2201V15.5898C87.7731 15.5898 87.7731 15.3658 87.3261 15.3658V24.3058H87.1021V15.3658H86.6551C86.2081 15.3658 85.7611 15.5898 85.3141 15.8128V23.1888L83.7491 24.3058H80.8431V10.2258L79.9491 10.6728V24.3068H79.7251V10.8958L76.1491 13.3538C76.1491 14.2488 75.9251 15.1428 75.9251 16.7068C75.9251 19.3898 76.5951 22.0718 77.4901 24.3058H73.2431C72.1251 22.2938 71.4551 20.2828 71.4551 17.6008C71.4551 12.4598 73.0191 10.2248 74.5841 7.98978H74.3611C73.0201 9.10778 70.5611 12.4598 70.5611 17.8258C70.5611 20.2828 71.0081 22.5188 71.9021 24.3058L71.6791 24.3068ZM93.5841 8.21278C92.6901 8.43678 92.0201 8.65978 89.7841 8.65978C87.5481 8.65978 86.2081 7.54278 85.5371 6.87178L84.6431 7.31878C85.9841 8.65978 87.1021 9.55378 89.3371 9.55378C91.1251 9.55478 92.4661 9.10778 93.5841 8.21278ZM92.9141 9.10778C92.0201 9.33178 90.9021 9.77778 89.1141 9.77778C87.5491 9.77778 86.2081 8.88378 85.3141 8.21278V15.3658L92.9141 9.10778ZM92.2431 20.0608C91.5731 17.8268 90.2311 16.2608 88.4431 15.5898V20.0608C88.8901 20.5078 89.7841 20.9558 90.4551 20.9558C91.1251 20.9548 91.5721 20.7298 92.2431 20.0608ZM92.4661 21.8498C92.4661 21.4028 92.4661 20.9548 92.2421 20.2838C92.0191 20.7308 91.3481 21.1788 90.4541 21.1788C89.5601 21.1788 88.8901 20.7318 88.4421 20.5088V23.6378C88.8891 23.1908 89.5601 22.9678 90.4541 22.9678C91.3491 22.9678 92.0191 23.4148 92.2421 23.6378C92.4661 22.9668 92.4661 22.5198 92.4661 21.8498ZM60.9501 18.7188L56.9261 12.9078L56.2561 13.3548L60.2791 19.1668L60.9501 18.7188ZM64.5261 16.0368L56.7031 22.2948V24.9788L59.6091 27.4378L62.7381 24.9788H62.9622L55.5861 30.7898L51.1161 27.2138V14.9188C53.7981 14.4718 57.1512 13.1308 60.5042 10.2248L64.5261 16.0368ZM60.0561 19.3908L56.7031 14.4728V22.0728L60.0561 19.3908ZM56.2561 30.1188L52.2332 26.9898V14.9188C51.7862 14.9188 51.5622 14.9188 51.3382 15.1428V27.2128L55.5851 30.5668L56.2561 30.1188ZM35.2451 30.5658L31.2221 27.4368V7.76678L30.5521 6.64878L29.8811 7.09578L30.5521 7.98978V27.8828L34.5751 31.2368L35.2451 30.5658ZM50.4451 26.5428L44.4101 31.4588L39.9391 27.8828V16.4838L37.0331 14.2488L35.6922 15.3658V24.9778L39.0451 27.8818L34.5751 31.4578L30.3281 27.8818V8.21278L29.4341 6.87178C32.1161 6.20078 34.1281 3.07178 36.3631 3.07178C36.5871 3.07178 37.0331 3.07178 37.2571 3.29578C36.3631 3.96578 35.6931 5.08378 35.6931 6.87178V15.1428L41.2811 10.6718L45.5281 13.8018V24.9778L48.4341 27.8818L50.4461 26.3178L50.4451 26.5428ZM44.8571 30.5658L41.0571 27.4368V16.0368L37.9282 13.5778L37.2581 14.0248L40.1642 16.4828V27.8818L44.4111 31.2358L44.8571 30.5658ZM4.17615 20.9548C4.40015 26.7658 9.76415 31.4588 15.1291 31.4588H16.2471C10.2121 31.2358 5.29415 26.3178 5.07115 20.9548H9.54215C10.2121 23.4138 11.7771 25.4258 14.0121 26.5428L14.4591 26.3178L15.3531 25.6478V20.9548H19.8231V22.7418L14.2351 26.7648C15.5761 27.2118 17.3641 27.6598 19.1521 27.6598C20.2691 27.6598 21.8341 27.2128 23.1751 26.9898V20.9548V26.7658C23.6221 26.5428 23.8451 26.5428 24.2921 26.3188V20.9558H24.5161V26.3188C26.0801 25.4258 27.6451 24.0848 28.5391 22.7428L28.7631 22.9678C26.5281 27.8838 23.1751 31.6848 15.1281 31.6848C9.54015 31.6848 4.17515 26.9918 3.95215 20.9558L4.17615 20.9548Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M3.95296 20.9549V20.7299C3.95296 17.8259 4.62296 15.8129 5.74096 14.0249C4.17596 13.5779 2.83496 12.9069 2.83496 10.6719C2.83496 6.4249 6.18796 3.2959 10.211 3.2959C15.352 3.2959 21.163 6.8719 24.516 6.8719C26.975 6.8719 27.869 5.3079 28.092 3.7429H28.316C28.316 3.9659 28.54 4.4129 28.54 4.8599C28.54 7.0949 27.199 10.0009 24.517 10.8949V20.9539H24.293V10.8959C23.846 11.1199 23.623 11.1199 23.176 11.1199H22.281C21.387 11.1199 20.717 11.1199 19.823 10.8959V20.9549H15.353V13.8019L14.459 14.4719L9.31796 18.0489V19.1659C9.31796 19.8379 9.31796 20.5079 9.54196 20.9549H5.06996V20.5079C5.06996 17.6019 5.29396 15.8139 6.63396 13.1319C4.84596 15.3669 4.17596 18.0489 4.17596 20.7309V20.9559L3.95296 20.9549ZM19.375 10.8959C15.575 9.7779 10.658 7.5429 7.52896 7.5429C5.06996 7.5429 3.05796 9.1069 3.05796 10.8959C3.05796 12.6849 4.17596 13.5779 5.74096 13.8019C8.19896 10.6719 10.658 9.7779 13.341 9.3309L13.564 9.5539C10.659 11.7889 9.76396 14.0249 9.31696 17.8249L19.375 10.8959ZM26.528 9.3319C25.411 10.0019 24.293 10.2259 22.952 10.2259C18.705 10.2259 11.553 6.6489 7.97596 6.6489C6.18796 6.6489 5.06996 7.5439 4.84696 7.9899C5.29396 7.7659 6.18796 7.3199 7.75296 7.3199C11.776 7.3199 18.258 10.8959 22.505 10.8959C24.292 10.8959 25.857 10.2259 26.528 9.3319Z" fill="currentColor"/>
</svg>`,
  },
  logoOmega: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 512 506.522"><path fill="currentColor" fill-rule="nonzero" d="M0 392.217h13.513c.973 17.285 6.086 29.337 15.338 36.153 9.251 6.818 23.98 10.226 44.188 10.226h99.697l-.73-24.468c-38.711-7.791-74.013-29.337-105.906-64.639-31.893-35.302-47.84-79.855-47.84-133.66 0-59.648 22.216-110.531 66.647-152.65C129.339 21.06 187.344.001 258.922 0c69.386.001 126.112 19.904 170.179 59.709 44.066 39.807 66.099 90.75 66.1 152.833-.001 50.397-13.695 93.185-41.084 128.365-27.39 35.18-64.457 59.587-111.201 73.221l-3.652 24.468h101.523c23.129 0 38.406-4.382 45.832-13.147 7.425-8.764 11.381-19.842 11.869-33.232H512v114.305H307.492l9.495-110.288c62.813-19.72 94.219-77.786 94.22-174.197-.001-63.056-15.399-111.383-46.197-144.981-30.798-33.598-66.891-50.396-108.28-50.397-44.066.001-80.525 17.834-109.375 53.501-28.85 35.667-43.275 81.256-43.275 136.764 0 40.172 6.452 76.752 19.355 109.741 12.904 32.989 37.615 56.178 74.134 69.569l6.939 110.288H0V392.217z"/></svg>`,
  },
  logoNyt: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 300 60" >
<style>.B{fill:currentColor}</style><g transform="translate(1.181 5.339) scale(.7874)"><defs><path id="A" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="B"><use xlink:href="#A"/></clipPath><path d="M13 39.2V25.5l-4.5 1.8s-1.1 2.3-.9 5.7c.1 2.7 1.7 5.8 2.9 7.2zM25.1 11c1 .1 2.7.6 3.9 1.6 1.3 1.2 1.6 3.1 1.2 4.8-.4 1.5-.9 2.3-2.5 3.4S24.9 22 24.9 22v6.6L28 31l-3.1 2.8v9s2.6-2.1 4.6-6.2c0 0 .1-.2.3-.7.2 1.1.1 3.4-1.2 6.2-1 2.2-2.7 4.2-5 5.4-3.9 2.1-6.9 2.3-10 1.7-3.7-.7-7.1-2.7-9.3-6.2C2.7 40.5 2 37.7 2 34.6c.1-6.1 4.8-11.3 10.2-13.3.7-.2.9-.4 1.8-.5-.4.3-.9.6-1.5 1-1.7 1.1-3.2 3.3-3.9 5L19 22.3v14.1l-8.3 4.1c1 1.3 3.9 3.2 6.4 3.5 4.2.5 7-1.1 7-1.1v-9.2L21 31l3.1-2.4V22c-1.8-.2-4.3-1-5.5-1.3-1.9-.4-8.1-2.1-9.1-2.3-1-.1-2.2-.1-2.9.5s-1.2 1.8-.9 2.8c.2.6.6.9.9 1.2 0 0-.4 0-1-.4-1.2-.7-2.1-2-2.2-3.7A6.2 6.2 0 0 1 6 13.4c1.6-1 3.4-1.6 5.5-1.3 3.1.4 7.2 2.1 10.9 3 1.4.3 2.5.4 3.5-.1.5-.3 1.3-1.2.6-2.3-.8-1.3-2.3-1.3-3.6-1.5 1.2-.2 1.4-.2 2.2-.2" clip-path="url(#B)" class="B"/><defs><path id="C" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="D"><use xlink:href="#C"/></clipPath><path d="M65.8 35.6 61 39V27.8zm-.2-10.8-5.3 3.1-5 2.6v13L53.4 45l.3.3 1.9-1.5 5.9 5.1 10.2-7.8-.2-.3-5.7 4.3L61 41v-1.6l9.3-6.6z" clip-path="url(#D)" class="B"/><defs><path id="E" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="F"><use xlink:href="#E"/></clipPath><path d="M38.8 54c1.3.3 3.7.5 6.6-.9 3.2-1.5 4.4-4.8 4.4-8.1l.1-4.7V29.9l2-1.5-.2-.3-2 1.5-4.3-5-6.6 4.9V12.9l-6.7 5.5c.3.2 1.8.4 1.8 1.8v23.3l-3.5 2.2.2.3 1.5-1.1 4.2 3.8 6.6-5.1-.2-.3-1.6 1.2-2.2-1.5V30l2.6-1.6 3.6 3.7v11.2c0 3-.8 6.5-2.4 8.3s-2.2 1.9-3.9 2.4" clip-path="url(#F)" class="B"/><defs><path id="G" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="H"><use xlink:href="#G"/></clipPath><path d="M84.6 52.8c-2.6-.3-3.7-1.8-3.7-3.1 0-.8.8-2.3 2.4-2.5s3.2.5 4.6 2.1l6.1-6.5-.3-.3-1.6 1.8c-1.7-1.8-3.7-3-6.1-3.3V21.1L101.5 49s.4.3 1.1.3c.6 0 .4-.4.4-.4V20.8c1.3 0 3-.7 4-1.7 3-3 1.8-6.3 1.5-6.7-.2 1.4-1.3 2.9-3.2 2.9-2.5 0-4-1.8-4-1.8L95 20.3l.3.3 1.7-1.9c2.1 1.9 3.3 2.1 4.9 2.2v16.3L90.6 16.5c-1.1-1.7-2.7-3.2-5.2-3.2-2.9 0-5 2.5-5.3 4.6-.3 2.4 0 3 0 3s.4-2.7 2.1-2.7c1.5 0 2 .8 2.7 1.8v6.6c-1.6.1-5.4.3-5.7 4.5 0 1.6 1 3.2 1.9 3.7 1.1.7 2 .7 2 .7s-1.3-.7-.9-2.1c.4-1.2 2.7-1.4 2.8-.9v8.4c-1.3 0-5 .1-6.9 3.5-1.1 2-1 4.3.1 5.9 1 1.4 3 3.1 6.4 2.5" clip-path="url(#H)" class="B"/><defs><path id="I" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="J"><use xlink:href="#I"/></clipPath><path d="M118.2 35.6 113 39V27.8zm-.2-10.8-5.4 3.1-4.7 2.6v13L106 45l.3.3 1.9-1.5 5.5 5.1 10.2-7.8-.2-.3-5.7 4.3-4.6-4.2v-1.6l9.3-6.6z" clip-path="url(#J)" class="B"/><defs><path id="K" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="L"><use xlink:href="#K"/></clipPath><path d="m132.4 49.2-5-4-2.2 1.5-.2-.3 2.2-1.6V33.5c.1-4.6-4.4-3.5-4.1-8.4.1-2.2 2.3-3.8 3.4-4.3 1.2-.6 2.4-.6 2.4-.6s-2.1 1.2-1.6 3c.8 2.8 5.6 3 5.7 6.7v12.8l3.1 2.8.9-.7V30.9l-1.4-1.9 5-4.3 4.6 3.9-2.1 1.8v12.3l4.6 3.4.8-.5V30.9l-1.9-1.8 5-4.4 4.7 3.7 1.9-1.6.2.3-4.2 3.6v12l-10.7 6.4L138 45z" clip-path="url(#L)" class="B"/><defs><path id="M" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="N"><use xlink:href="#M"/></clipPath><g class="B"><path d="M352.3 35.6 347 39V27.8zm-.1-10.8-5.4 3.1-4.9 2.6v13l-2.1 1.5.3.3 1.9-1.5 5.9 5.1 10.2-7.8-.2-.3-5.7 4.3-4.7-4.2v-1.6l9.3-6.6z" clip-path="url(#N)"/><path d="m317 29.7 1.1-.9 2.9 3.6v10.7l-.9 1.2 4.2 4.5 4.5-4.3-1.8-1.7v-13l1.3-1 3.7 3.5V43l-1.5 1 4.7 4.9 6.2-5.5-.3-.3-1.5 1.3L337 42V29.8l2.5-1.7-.2-.3-2.3 1.7-4.2-4.6-6 4.6-4.3-4.4-5.8 4.4-4.3-4.4-6.2 5.2.2.3 2-1.6 2.8 3.1v10.8l-1.4 1.2 4.5 4.9 4.6-4.4-1.9-1.9zm-8.7 14.1-.2-.3-1.8 1.5-2.4-2.7V30.2l2.1-1.7-.3-.3-2 1.7-4.3-4.9-6.4 5 .8.2 1.6-1.3 2.6 2.9v12.3l-1.8 1.5.2.3 1.9-1.6 4.1 4.6zm-8.6-28 3.6 3.9-4.5 3.9-3.6-3.8z"/></g><defs><path id="O" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="P"><use xlink:href="#O"/></clipPath><path d="M275.2 39.2V25.5l-4.2 1.8s-1.1 2.3-.9 5.7c.1 2.7 1.7 5.8 2.9 7.2zm12-28.2c1.1.1 2.7.6 3.9 1.6 1.3 1.2 1.6 3.1 1.2 4.8-.4 1.5-.9 2.3-2.5 3.4s-2.8 1-2.8 1v6.6l3 2.6-3 2.6v8.9s2.5-1.8 4.6-5.9c0 0 .1-.2.3-.7.2 1.1.1 3.4-1.2 6.2-1 2.2-2.7 4.2-5 5.4-3.9 2.1-6.9 2.3-10 1.7-3.7-.7-7.1-2.7-9.3-6.2-1.6-2.5-2.3-5.3-2.3-8.4.1-6.1 4.8-11.3 10.2-13.3.6-.2.9-.4 1.8-.5-.4.3-.9.6-1.5 1-1.7 1.1-3.2 3.3-3.9 5l10.3-4.3v14.1l-8.2 3.9c1 1.3 3.9 3.2 6.4 3.5 4.2.5 6.9-1.3 6.9-1.3v-9.2l-3-2.6 3-2.6v-6.6c-1.8-.2-4.1-.8-5.4-1.1-1.9-.4-8.1-2.1-9.1-2.3-1-.1-2.2-.1-2.9.5s-1.2 1.8-.9 2.8c.2.6.6.9.9 1.2 0 0-.4 0-1-.4-1.2-.7-2.1-2-2.2-3.7a6.2 6.2 0 0 1 2.6-5.4c1.6-1 3.4-1.6 5.5-1.3 3.1.4 7.2 2.1 10.9 3 1.4.3 2.5.4 3.5-.1.5-.3 1.3-1.2.6-2.3-.8-1.3-2.3-1.3-3.6-1.5 1.1-.1 1.4-.1 2.2-.1" clip-path="url(#P)" class="B"/><defs><path id="Q" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="R"><use xlink:href="#Q"/></clipPath><path d="M365 27.4v6.5l2.8 1.9s4.8-3.8 6.6-7.2c0 0-2.2 2.9-5.1 2-2.5-.7-3.7-3.1-3.7-3.1m-5.5 17s2.1-3.4 5.8-2.7c3.5.7 5.1 4.3 5.1 4.3v-8.2l-2.9-2c-2.6 2.6-7.4 6.3-8 8.6m3.5 6.2c-.7.2-3.6-.5-4.3-3.5-.7-2.9 1.4-4.8 4.5-7.9l-3.7-3.3v-6.2s2.7-1.3 4.8-2.6l4.3-2.7s1.6 1.9 3.4 1.8c2.8-.2 2.7-2.4 2.6-2.9.5.8 1.8 3.3-3.2 8.8l4 3.1v8.1s-4.6 2.3-9.1 5.5c0 0-2.5-3-4.6-1.6-1.4 1.1-.7 2.7 1.3 3.4" clip-path="url(#R)" class="B"/><defs><path id="S" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="T"><use xlink:href="#S"/></clipPath><path d="m202 41.5 5.2 4.5V32.2l-5.2-4.6zm11.1-11.3 1.8-1.6.3.3-2.2 1.6v12.9l-5.2 3-4.8 2.8-6.1-5-1.6 1.4-.3-.3 2.1-1.4v-14h-.3l5.3-2.6 4.6-2.6z" clip-path="url(#T)" class="B"/><defs><path id="U" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="V"><use xlink:href="#U"/></clipPath><path d="m225.2 28.9 3.9-3.9s.5.5 1 .7c.3.1 1.5.7 2.5.1.6-.3.7-.4 1.3-1 .1 3-1.4 5.1-3.2 6-.8.4-3.4 1-5.8-1.7V43l2.9 2.1 2.1-1.6.2.3-6.4 5.2-4.9-4.3-1.8 1.6-.3-.3 2.2-2.3V31.8l-1.6-2.6-1.8 1.5-.3-.3 6.2-5.4z" clip-path="url(#V)" class="B"/><defs><path id="W" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="X"><use xlink:href="#W"/></clipPath><path d="m241.6 34.7 7.2-10.1s1 1.1 2.6 1.5c2.2.6 4.2-1.5 4.2-1.5-.4 2.7-1.8 5.8-4.7 6.3-2.6.4-5-1.5-5-1.5l-.5.7 10 14.6 2-1.7.3.3-6.9 5.8z" clip-path="url(#X)" class="B"/><defs><path id="Y" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="Z"><use xlink:href="#Y"/></clipPath><path d="M236 21.1c0-2.2-1.3-3.5-2.5-3.4l7.5-5.3v30.2l2.4 2.1 1.6-1.3.3.3L239 49l-4.3-3.9-1.7 1.5-.3-.3 3.4-2.5V21.1z" clip-path="url(#Z)" class="B"/><defs><path id="a" d="m375.3 11 .7 50.8H2L1.3 11z"/></defs><clipPath id="b"><use xlink:href="#a"/></clipPath><path d="M185.2 29.6s-.9 1-2.2 1c-1.4 0-2-1-2-1v4.1s.6-1 2-1 2.2.9 2.2.9zm-.2-8.8-2.5-2.6-1.5 1.1V29s.9 1.1 2.3 1.1S185 29 185 29zm-4 27.4s1.8.5 3.2-.6c1.5-1.2.8-2.8.8-2.8V34.4s-.4-1.1-1.7-1.1c-1.4 0-2.3 1.1-2.3 1.1zm-11-27.6c0-2-.9-3.2-2.2-3.2-2 0-2.5 2.7-2.5 2.7s-.4-2.1 1.5-4c1-1.1 2.9-2.6 5.9-1.9 3.1.7 4.3 3 4.3 5.1v28.1a15.4 15.4 0 0 0 1.6.3c.9.2 1.4.4 1.4.4V14.3h1v4.6l6.1-4.9 4.6 4 2.2-1.8.2.3-2.2 1.9v26.1c-.1 1.7-.4 3.4-2.1 4.4-3.7 2.1-8.2-.3-12.2-.9-3-.4-7.6-1-8.8 1.7-.4.9-.4 2.2 1 3.1 2.7 1.7 14.7-2.9 18.8-1.1 3.7 1.7 3.7 4.4 3.2 6.2-1 3.4-5.5 4.1-5.5 4.1s2.2-1.2 1.6-3.3c-.3-1-1-1.3-3.4-1.1-5.1.6-11.3 3-15.4 1.3-2.1-.9-3.6-3.4-3.5-6 .1-3.6 4.5-5.1 4.5-5.1V34.3c-.1-.5-2.4-.4-3 .6-.8 1.5 1 2.2 1 2.2s-1.4.2-2.6-1.1c-.6-.6-1.8-2.9-.2-5.1 1.3-1.8 2.9-2.1 4.9-2.3z" clip-path="url(#b)" class="B"/></g></svg>
`,
  },
  logoGuardian: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 295 97"><path fill="currentColor" d="M66.9 51.7c1-.5 2.1-1.1 3.1-1.6.4-.2 1.8-.7 2-1.1.1-.2 0-.8 0-1.1v-2.4-17.1-16.7-2.2c0-.1.1-.8 0-.9-.1-.1-.9 0-1 0h-2.2c-.8 0-.7.1-1.2.7-1.9 2.5-3.8 5-5.7 7.6-.9 1.2-1.8 2.3-2.6 3.5-.6.8-.6.9-1.7.9l.3-6.6c.1-1.6.1-3.2.2-4.8 0-.6.1-1.2.1-1.8 0-.2-.1-.8 0-.9.2-.3 2-.1 2.5-.1h37.4c.2 0 1.1-.1 1.3 0 .2.1.1.7.1 1 .1 1.3.1 2.7.2 4 .1 2.9.2 5.7.4 8.6v.6c-.5 0-.9.1-1.3-.2-.4-.3-.7-.9-1-1.3-1.2-1.6-2.4-3.3-3.7-4.9l-3.6-4.8c-.2-.3-.5-1-.9-1.2-.3-.2-.9-.1-1.3-.1h-1.6c-.2 0-1-.1-1.2 0-.1.1 0 .1-.1.3-.2.8 0 1.8 0 2.6v34.8c0 .7-.2 1.7 0 2.4s1.8 1.2 2.5 1.5c.7.4 1.9.7 2.5 1.3.2.2.4 1.2.2 1.5-.1.1-.6 0-.7 0h-22c-.2 0-.9.1-1 0-.1-.4 0-1.2 0-1.5zm37.1-1.8V35.3 11.4 7.5c0-.6.2-1.5 0-2.1-.2-.7-1.4-.8-2.1-1.1-.4-.1-1.7-.4-1.9-.8v-.8h.3c.4-.2 1.2-.2 1.7-.3.9-.2 1.8-.3 2.6-.5 2-.4 4.1-.8 6.1-1.1 1.2-.2 2.4-.5 3.6-.7.3 0 1.5-.2 1.6 0 .1.1 0 .5 0 .6V21.4c3.8-3.8 10.4-5.9 15.7-4.6 4.6 1.1 6.1 5.4 6.1 9.8.1 5.6 0 11.1 0 16.7v4.5c0 .5-.2 1.7 0 2.2.1.2.5.3.7.5.7.4 1.5.8 2.2 1.2.1.1.4.2.4.3.1.1.1 1 0 1.1-.1.2-.1.1-.4.1-1.1.2-2.3 0-3.3 0H122.9c-.1 0-.6.1-.7 0-.1-.1-.1-1.2 0-1.3.3-.4 1.5-.8 1.9-1.1.3-.2 1.2-.5 1.4-.8.2-.3 0-1.4 0-1.7v-4.1c0-5.8.1-11.7 0-17.5 0-1.7-.3-3.7-2-4.6-.9-.5-2.1-.6-3.1-.6-.8 0-1.6.2-2.3.4-.6.2-1.7.6-2.1 1.1-.3.4-.1 1-.1 1.5V48.1c0 .5-.2 1.5 0 1.9.1.2.5.4.8.5.7.4 1.6.8 2.3 1.2.1.1.3.1.3.2.1.1.1 1 0 1.1-.1.1-.2.1-.4.1-1.1.1-2.3 0-3.4 0H101.1c-.1 0-.6.1-.7 0-.1-.1 0-1.1.1-1.3.3-.4 1.4-.8 1.8-1 .7-.3 1.2-.6 1.7-.9zm47.5-13.8c.2 4.4 1.6 9.3 5.6 11.7 2.1 1.2 4.7 1.6 7.1 1.4 2.9-.3 5.3-1.7 7.8-3 0 .4.1 1.1 0 1.5-.2.4-.7.9-1 1.2-.4.4-.9.9-1.4 1.3-1.7 1.4-3.6 2.4-5.6 3.1-3.8 1.3-8.2 1.2-12.1.2-3.1-.8-5.9-2.3-8-4.7-2.1-2.4-3.3-5.5-3.8-8.7-1.1-6.9.2-14.8 5.9-19.4 5-4 13-4.8 18.9-2.4 7.2 2.9 8.4 11.1 8.4 17.9h-19.1c-.9-.1-1.8-.1-2.7-.1zm-.2-1.7c2-.1 4-.2 6.1-.4 1.2-.1 2.5-.1 3.7-.2.2 0 .7 0 .9-.1.3-.2.1-2.2.1-2.6-.1-3.6-.2-8-2.3-11.1-1.5-2.2-3.8-1.8-5.2.2-2.9 3.9-3.3 9.7-3.3 14.2zM-.1 70.9c0-5.6 1.1-11.4 4.2-16.1 3-4.6 7.8-7.6 13-9.1 6.3-1.8 13.3-1.6 19.8-.4 1.4.3 2.8.6 4.1 1 .2.1 1.1.3 1.2.5v.3c.3 1.2.1 2.7.1 3.9.1 3.1.1 6.3.2 9.4-.4 0-1.1.1-1.4 0-.2-.1-.4-.6-.5-.8-.8-1.2-1.6-2.4-2.3-3.7-1.7-2.7-3.5-5.4-5.2-8.1-.9-1.5-3.4-1.5-5-1.5-1.8 0-3.6.3-5.1 1.2-3.4 2.1-5 6.2-5.9 9.9-1.4 5.9-1.3 12.1-1 18.1.3 4.6.7 9.5 2.5 13.7 1.1 2.6 3 4.9 5.9 5.5.9.2 1.8.2 2.8.1.6-.1 2.7-.2 3-.8.1-.2 0-.7 0-.9v-1.7-10.6-4.1c0-.7.2-1-.4-1.4-.7-.4-1.5-.8-2.2-1.3-.5-.3-1.5-.6-1.8-1-.2-.2-.3-1.3-.1-1.5.1-.2.1-.1.4-.1.9-.2 2.1 0 3 0h15.5c1 0 2.1-.1 3.1 0h.4c.1.1.1 1.5 0 1.7-.2.3-1.2.7-1.6.9-.7.4-1.5.8-2.2 1.3-.8.4-.7.4-.7 1.3v16.3c0 .2.1.7 0 .9-.2.5-2.3.8-2.9 1-1.7.5-3.5.9-5.3 1.2-3.5.6-7 .8-10.5.7-5.6-.2-11.5-1.4-16.1-4.8-4-2.9-6.6-7.3-7.8-12.1C.2 77-.1 73.9-.1 70.9zM46 61.8c0-.2-.1-1 0-1.1.1-.1.2 0 .3-.1.6-.3 1.4-.3 2.1-.4 2.3-.4 4.6-.8 7-1.2 1.8-.3 3.6-.7 5.3-.9.5-.1 1.1-.1 1.6.1.5.1.3 0 .4.4.2 1.2 0 2.6 0 3.8v20.9c0 2.5-.7 7.1 1.7 8.6 1.2.8 2.9.8 4.3.5 1.1-.2 3.2-1 3.6-2.2.1-.3 0-.7 0-1v-2.1-13.9-6.4-2.1c0-.2.1-.8 0-1-.3-.3-1.3-.6-1.6-.7-.6-.2-1.1-.5-1.7-.7-.2-.1-.9-.2-1-.4-.1-.1-.1-1 0-1.1.1-.1.1 0 .2-.1.5-.3 1.4-.2 1.9-.3 4.1-.7 8.3-1.6 12.5-2.2.5-.1 1-.1 1.5 0s.3-.1.4.4c.2 1 0 2.4 0 3.5v28.8c0 .3-.1.8 0 1.2.1.3 0 .2.5.4 1 .4 2.1.9 3.1 1.3.3.1.4.1.5.3.1.2.1.9 0 .9-.2.2-1.2.1-1.4.2-2.2.3-4.4.5-6.7.8-2 .2-4 .5-5.9.7-.4.1-.8.1-1.2 0-.2 0-.8 0-.9-.1-.1-.2 0-1 0-1.2v-1.7c0-.3.2-1.1 0-1.4-.2-.3-.6.1-.9.3-.8.7-1.7 1.4-2.6 1.9-3.3 2-7.4 2.9-11.2 2.1-2.8-.6-5.2-2.2-6.4-4.9-.9-1.9-1.1-4-1.1-6V73.8 67v-2.3c0-.2.1-.8 0-1-.2-.3-1.4-.6-1.7-.8-1-.4-1.8-.7-2.6-1.1zm94.3-3.8c.2 0 1.1 0 1.2.2.1.1 0 .8 0 .9v8.8c0 .3-.1.8 0 1.1v.2c.4.4.5-.9.6-1 .9-3.7 2.6-8 6.4-9.5.7-.3 1.4-.4 2.1-.5.6 0 2.3-.2 2.6.3.1.2 0 .7 0 .9V69.6c-2.4-.5-5.1-.4-7.4.1-1.1.2-2.1.5-3.1 1-.5.2-.6.1-.7.5-.1.4 0 1.1 0 1.5V92c0 .2-.1.5 0 .7.2.3.9.5 1.2.6.5.3 1.1.6 1.6.9.2.1.5.2.6.4.1.1.1 1.3 0 1.4-.1.1-.7 0-.9 0h-16.6c-.5 0-1.4.2-1.8 0h-.3c-.1-.1 0-1.2 0-1.3.2-.6 1.5-1 2.1-1.3.4-.2 1.2-.5 1.4-.9.1-.2 0-.8 0-1v-2.1-25.7c0-.1.1-.6 0-.7-.1-.1-.6-.2-.8-.2-.6-.2-1.2-.4-1.8-.5-.6-.2-2.1-.3-1.6-1.3.1-.3.5-.2.9-.3 4.4-.8 8.7-1.6 13.1-2.4.4-.2.8-.2 1.2-.3zm37.7.9v-8-2.3c0-.3.1-.9 0-1.2-.1-.2-.5-.3-.8-.4-.8-.3-1.6-.6-2.5-.9-.6-.2-.9-.1-.9-.8 0-.6-.1-.4.4-.5 1.1-.4 2.4-.4 3.5-.6 3.3-.6 6.5-1.2 9.8-1.8.7-.1 1.4-.3 2.1-.2.8.1.9-.1.9.6.1 1.6 0 3.3 0 4.9v43.8c0 .4-.1.4.2.6.6.4 1.6.6 2.2.8.4.1 1.5.3 1.7.6.1.1.1 1.2 0 1.3-.1.1-.7.1-.8.1-1.4.2-2.7.4-4.1.5-3.1.4-6.2.8-9.4 1.2-.5.1-1.7.3-1.9-.1-.2-.4 0-1.7 0-2.1 0-.3.2-1.6 0-1.8-.2-.2-2.4 1.8-2.7 2-1.2.8-2.5 1.4-3.9 1.8-2.2.6-4.7.6-6.9.1-9.6-2.2-11.6-13.6-10.8-21.9.4-4.4 1.8-8.8 4.8-12 2.8-2.9 6.6-4.4 10.5-4.7 3-.3 5.9-.1 8.6 1zm0 31.9V66.2v-4.6c0-.6-.1-.7-.8-1.1-1.4-.8-3.2-1.1-4.7-.5-2.3.9-3.4 3.6-4 5.8-1.2 4-1.3 8.3-1.2 12.5.1 3.6.2 8 2.2 11.2 1.8 2.8 5.9 3.5 8.5 1.3zM211.1 58c.5.1 1.1-.1 1.3.4.1.3 0 1 0 1.3V91c0 .4-.1 1 0 1.4.1.4.5.5.9.7.6.3 1.1.6 1.7.9.2.1.8.3.9.6 0 .1.1 1.3 0 1.4h-.3c-.6.1-1.4 0-2.1 0h-15.2c-.4 0-1.5.2-1.8 0-.2-.1-.3-1.3-.1-1.5.2-.3.9-.5 1.2-.6.6-.3 1.2-.7 1.8-1 .5-.3.4-.2.4-.6.2-1.5 0-3.2 0-4.7v-7.9-14.4c0-.4.1-1.1 0-1.5-.1-.4-.6-.4-1-.6-.7-.3-1.3-.5-2-.8-.2-.1-1-.2-1.2-.5-.1-.1-.1-1.1 0-1.2.1-.1.3 0 .4-.1.8-.3 1.7-.3 2.6-.5 1.3-.2 2.5-.5 3.8-.7 2.5-.4 4.9-.9 7.4-1.3.5.1.9 0 1.3-.1zm1.4-9.3c-.2 6-8.3 8.6-12 3.9-1.7-2.2-1.8-5.2-.3-7.5s4.4-3.3 7.1-2.7c3 .6 5.2 3.2 5.2 6.3zm43.8 43.9V68.5v-4.6c0-.1.1-.6 0-.7-.1-.2-.7-.3-.9-.3l-1.8-.6c-.3-.1-1.1-.2-1.3-.5-.2-.2-.1-.7-.1-1 0-.6.2-.5.8-.6l6.6-1.2 6.6-1.2c.4-.1.7-.2 1.1-.2.2 0 1.2 0 1.4.1.1.1 0 .7 0 .9v1.9c0 .3-.2 1.2 0 1.5.2.4.6 0 .9-.3.9-.7 1.8-1.3 2.8-1.8 3.6-2 7.9-2.9 12-2.3 2.8.4 5.1 1.9 6.1 4.6.7 1.9.8 3.9.8 5.9v22.8c0 .4-.1 1.1 0 1.5.1.4.4.5.9.7.5.3 1.1.6 1.6.9.2.1.9.3 1 .6.1.2.1 1.2 0 1.3-.1.2.1 0-.2.1-.4.2-1.3 0-1.8 0h-14.3c-.6 0-2.9.3-3.2-.1-.1-.1-.1-1.2 0-1.4.1-.2.7-.4.9-.5.6-.3 1.1-.6 1.7-.9.2-.1.8-.3.9-.5.1-.2 0-.6 0-.8v-2.2-7-13.5c0-1.6.1-3.4-.9-4.8-.8-1.2-2.2-1.5-3.6-1.6-1.1 0-2.1.1-3.1.4-.5.2-2 .6-2.3 1.2-.1.2 0 .6 0 .8V91c0 .3-.1 1 0 1.3.1.4.7.5 1 .7.5.3 1.1.6 1.6.9.2.1.6.3.7.4.1.1.1 1.3 0 1.4 0 .1-.1 0-.2 0-.4.2-1.4 0-1.8 0h-16.8c-.5 0-.6.1-.7-.2-.1-.2-.1-1.1 0-1.3.1-.2.7-.4.9-.5 1-.1 1.8-.6 2.7-1.1zm-21.2-18.4c0-2.6.1-5.3-.1-8-.3-2.9-1.1-6.1-4.4-6.7-1-.2-2.8-.5-3.5.3-.7.7-1.2 1.7-1.8 2.5l-5.1 6.9c-.3.4-.6 1.2-1 1.4-.1.1-1.1.1-1.1 0-.1-.1 0-.8 0-1v-8.1c0-.3-.1-.8 0-1.1.2-.5 2.4-.8 2.9-1 2.8-.7 5.7-1.2 8.6-1.4 4.1-.3 8.7-.2 12.5 1.6 3 1.4 4.9 3.9 5.4 7.1.3 1.6.2 3.4.2 5v20c0 .3-.2 1.1 0 1.3.1.1.6.2.7.2.8.2 1.5.4 2.3.6.5.1.6.1.6.6s.1.5-.5.7c-.7.3-1.4.6-2.1.8-3.7 1.1-9.5 1.4-12.2-2-.2-.3-.8-1.6-1.1-1.7-.4-.1-1.6 1.5-2 1.8-1.6 1.4-3.7 2.2-5.8 2.5-3.9.5-8.1-.3-10.5-3.7-2-2.9-2.4-7.4-.9-10.6 2.7-6.1 10.7-6.7 16.5-7.7.7 0 1.5-.2 2.4-.3zm0 16.6V76c-3 .2-6.1.4-7.2 3.7-.8 2.2-.8 4.8-.5 7.1.2 1.6.6 3.6 2.1 4.6 1.6 1.1 4.3.9 5.6-.6zM108.5 74.2c0-2.6.1-5.3-.1-8-.3-2.9-1.1-6.1-4.4-6.7-1-.2-2.8-.5-3.5.3-.7.7-1.2 1.7-1.8 2.5l-5.1 6.9c-.3.4-.6 1.2-1 1.4-.1.1-1.1.1-1.1 0-.1-.1 0-.8 0-1v-8c0-.3-.1-.8 0-1.1.2-.5 2.3-.8 2.9-1 2.8-.7 5.7-1.2 8.5-1.4 4.1-.3 8.7-.2 12.5 1.6 3 1.4 4.9 3.9 5.4 7.1.3 1.6.2 3.4.2 5v20c0 .3-.2 1.1 0 1.3.1.1.6.2.7.2.8.2 1.5.4 2.3.6.5.1.6.1.6.6s.1.5-.5.7c-.7.3-1.4.6-2.1.8-3.7 1.1-9.5 1.4-12.2-2-.2-.3-.8-1.6-1.1-1.7-.4-.1-1.6 1.5-1.9 1.8-1.6 1.4-3.7 2.2-5.8 2.5-3.9.5-8.1-.3-10.5-3.7-2-2.9-2.4-7.4-.9-10.6 2.7-6.1 10.7-6.7 16.4-7.7.8-.1 1.6-.3 2.5-.4zm0 16.6V76c-3 .2-6.1.4-7.2 3.7-.8 2.2-.8 4.8-.5 7.1.2 1.6.6 3.6 2.1 4.6 1.6 1.1 4.3.9 5.6-.6z"/></svg>`,
  },
  logoTechcrunch: {
    format: 'html',
    html: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 60"><path fill="currentColor" d="M13.53 41.967v10H9.86v-10h-3.7v-3.2h11.07v3.2zm12.26 6.04h-5.85a1.56 1.56 0 0 0 1.68 1.59 5.17 5.17 0 0 0 2.57-.7l1.33 2.2a7.68 7.68 0 0 1-4 1.14c-3 0-4.63-2.12-4.63-5.16 0-3.42 1.93-5.18 4.53-5.18s4.42 1.8 4.42 5.48c-.04.24-.04.45-.05.62zm-4.5-3.63c-.78 0-1.2.53-1.32 1.52h2.83c-.17-1-.5-1.52-1.5-1.52zm10.82 7.83c-2.9 0-4.64-1.85-4.64-5.2 0-3 1.54-5.14 4.72-5.14a4.13 4.13 0 0 1 3.81 2.24l-2.34 1.8c-.47-.86-.8-1.28-1.53-1.28s-1.3.87-1.3 2.44.47 2.38 1.4 2.38c.64 0 1.1-.36 1.72-1.3l2.15 1.68c-1.16 1.7-2.23 2.37-4 2.37zm11.6-.2v-5.63c0-1.3-.43-1.63-1.13-1.63s-1.16.34-1.16 1.6v5.67h-3.4v-12.4l3.4-1.36v4.5a3.84 3.84 0 0 1 2.5-.87c2.17 0 3.2 1.46 3.2 4.06v6.07z" fill="currentColor"/><path fill="currentColor" d="M55.27 52.207c-3.93 0-6-2.9-6-6.82 0-4.25 2.5-6.82 6-6.82 3.25 0 4.53 1.4 5.44 3.9l-3.32 1.3c-.48-1.23-.93-2-2.14-2-1.53 0-2.2 1.53-2.2 3.63s.64 3.62 2.23 3.62c1.15 0 1.64-.62 2.36-1.87l3.1 1.65a5.69 5.69 0 0 1-5.48 3.42zm13.86-6.4a2.13 2.13 0 0 0-1.58-.83c-.83 0-1.34.4-1.34 1.6v5.4h-3.4v-9.9h3.4v.72a3 3 0 0 1 3.72-.51zm8.1 6.18v-.66a3.76 3.76 0 0 1-2.48.87c-2.17 0-3.2-1.46-3.2-4.07v-6.03h3.4v5.6c0 1.28.44 1.62 1.14 1.62s1.13-.34 1.13-1.58v-5.64h3.42v9.92zm11.56 0v-5.63c0-1.3-.44-1.63-1.13-1.63s-1.16.34-1.16 1.6v5.67h-3.4v-9.9h3.4v.66a3.84 3.84 0 0 1 2.5-.87c2.17 0 3.2 1.46 3.2 4.06v6.07zm10.05.2c-2.9 0-4.65-1.85-4.65-5.2 0-3 1.55-5.14 4.72-5.14a4.16 4.16 0 0 1 3.82 2.24l-2.34 1.77c-.48-.86-.8-1.28-1.53-1.28s-1.3.87-1.3 2.44.47 2.38 1.4 2.38c.64 0 1.1-.36 1.72-1.3l2.15 1.68c-1.15 1.74-2.23 2.4-3.98 2.4zm11.6-.2v-5.63c0-1.3-.43-1.63-1.13-1.63s-1.15.34-1.15 1.6v5.67h-3.4v-12.4l3.4-1.36v4.5a3.79 3.79 0 0 1 2.49-.87c2.18 0 3.2 1.46 3.2 4.06v6.07z"/><path d="M34.525 7.753v7.936h7.925v15.86h7.936v-15.86h7.925V7.753zm31.722 15.86v-7.925H58.31v15.86h23.797v-7.936zm0-15.86h15.86v7.936h-15.86z" fill="currentColor"/></svg>`,
  },
} satisfies Record<string, MediaObject>
