export const systemIcons = [
  // Essential UI Icons (Most Common)
  { name: 'Menu', iconId: 'menu', iconClass: 'i-tabler-menu-2' },
  { name: 'Close', iconId: 'close', iconClass: 'i-tabler-x' },
  { name: 'Search', iconId: 'search', iconClass: 'i-tabler-search' },
  { name: 'Add', iconId: 'add', iconClass: 'i-tabler-plus' },
  { name: 'Remove', iconId: 'remove', iconClass: 'i-tabler-minus' },
  { name: 'Check', iconId: 'check', iconClass: 'i-tabler-check' },
  { name: 'More', iconId: 'more', iconClass: 'i-tabler-dots-horizontal' },
  { name: 'More Vertical', iconId: 'more-vertical', iconClass: 'i-tabler-dots-vertical' },
  { name: 'Settings', iconId: 'settings', iconClass: 'i-tabler-settings' },
  { name: 'Filter', iconId: 'filter', iconClass: 'i-tabler-filter' },
  { name: 'Sort', iconId: 'sort', iconClass: 'i-tabler-sort-ascending' },
  { name: 'Refresh', iconId: 'refresh', iconClass: 'i-tabler-refresh' },
  { name: 'Bolt', iconId: 'bolt', iconClass: 'i-tabler-bolt' },
  { name: 'Airplane', iconId: 'airplane', iconClass: 'i-tabler-airplane' },
  { name: 'Wand', iconId: 'wand', iconClass: 'i-tabler-wand' },
  { name: 'World', iconId: 'world', iconClass: 'i-tabler-world' },

  // Navigation & Direction
  { name: 'Chevron Down', iconId: 'chevron-down', iconClass: 'i-tabler-chevron-down' },
  { name: 'Chevron Up', iconId: 'chevron-up', iconClass: 'i-tabler-chevron-up' },
  { name: 'Chevron Left', iconId: 'chevron-left', iconClass: 'i-tabler-chevron-left' },
  { name: 'Chevron Right', iconId: 'chevron-right', iconClass: 'i-tabler-chevron-right' },
  { name: 'Arrow Left', iconId: 'arrow-left', iconClass: 'i-tabler-arrow-left' },
  { name: 'Arrow Right', iconId: 'arrow-right', iconClass: 'i-tabler-arrow-right' },
  { name: 'Arrow Up', iconId: 'arrow-up', iconClass: 'i-tabler-arrow-up' },
  { name: 'Arrow Down', iconId: 'arrow-down', iconClass: 'i-tabler-arrow-down' },
  { name: 'Arrow Up Right', iconId: 'arrow-up-right', iconClass: 'i-tabler-arrow-up-right' },
  { name: 'Arrow Down Right', iconId: 'arrow-down-right', iconClass: 'i-tabler-arrow-down-right' },
  { name: 'External Link', iconId: 'external-link', iconClass: 'i-tabler-external-link' },
  { name: 'Home', iconId: 'home', iconClass: 'i-tabler-home' },
  { name: 'Back', iconId: 'back', iconClass: 'i-tabler-arrow-back' },

  // Common Actions
  { name: 'Edit', iconId: 'edit', iconClass: 'i-tabler-edit' },
  { name: 'Delete', iconId: 'delete', iconClass: 'i-tabler-trash' },
  { name: 'Copy', iconId: 'copy', iconClass: 'i-tabler-copy' },
  { name: 'Share', iconId: 'share', iconClass: 'i-tabler-share' },
  { name: 'Download', iconId: 'download', iconClass: 'i-tabler-download' },
  { name: 'Upload', iconId: 'upload', iconClass: 'i-tabler-upload' },
  { name: 'Save', iconId: 'save', iconClass: 'i-tabler-device-floppy' },
  { name: 'Print', iconId: 'print', iconClass: 'i-tabler-printer' },
  { name: 'Undo', iconId: 'undo', iconClass: 'i-tabler-arrow-back-up' },
  { name: 'Redo', iconId: 'redo', iconClass: 'i-tabler-arrow-forward-up' },

  // User Interface
  { name: 'Grid', iconId: 'grid', iconClass: 'i-tabler-layout-grid' },
  { name: 'List', iconId: 'list', iconClass: 'i-tabler-list' },
  { name: 'Layout', iconId: 'layout', iconClass: 'i-tabler-layout-2' },
  { name: 'Table', iconId: 'table', iconClass: 'i-tabler-table' },
  { name: 'Columns', iconId: 'columns', iconClass: 'i-tabler-columns' },
  { name: 'Rows', iconId: 'rows', iconClass: 'i-tabler-rows' },
  { name: 'Cursor', iconId: 'cursor', iconClass: 'i-tabler-click' },
  { name: 'Move', iconId: 'move', iconClass: 'i-tabler-arrows-move' },
  { name: 'Resize', iconId: 'resize', iconClass: 'i-tabler-arrows-maximize' },
  { name: 'Drag', iconId: 'drag', iconClass: 'i-tabler-drag-drop' },

  // Status & Notifications
  { name: 'Success', iconId: 'success', iconClass: 'i-tabler-circle-check' },
  { name: 'Warning', iconId: 'warning', iconClass: 'i-tabler-alert-triangle' },
  { name: 'Error', iconId: 'error', iconClass: 'i-tabler-alert-circle' },
  { name: 'Info', iconId: 'info', iconClass: 'i-tabler-info-circle' },
  { name: 'Loading', iconId: 'loading', iconClass: 'i-tabler-loader' },
  { name: 'Bell', iconId: 'bell', iconClass: 'i-tabler-bell' },
  { name: 'Lock', iconId: 'lock', iconClass: 'i-tabler-lock' },
  { name: 'Unlock', iconId: 'unlock', iconClass: 'i-tabler-lock-open' },
  { name: 'Eye', iconId: 'eye', iconClass: 'i-tabler-eye' },
  { name: 'Eye Off', iconId: 'eye-off', iconClass: 'i-tabler-eye-off' },
  { name: 'Notification', iconId: 'notification', iconClass: 'i-tabler-notification' },
  { name: 'Messages', iconId: 'messages', iconClass: 'i-tabler-messages' },

  // Content & Media
  { name: 'Image', iconId: 'image', iconClass: 'i-tabler-photo' },
  { name: 'Video', iconId: 'video', iconClass: 'i-tabler-video' },
  { name: 'Audio', iconId: 'audio', iconClass: 'i-tabler-volume' },
  { name: 'File', iconId: 'file', iconClass: 'i-tabler-file' },
  { name: 'Link', iconId: 'link', iconClass: 'i-tabler-link' },
  { name: 'Unlink', iconId: 'unlink', iconClass: 'i-tabler-unlink' },
  { name: 'Attachment', iconId: 'attachment', iconClass: 'i-tabler-paperclip' },
  { name: 'Play', iconId: 'play', iconClass: 'i-tabler-player-play' },
  { name: 'Pause', iconId: 'pause', iconClass: 'i-tabler-player-pause' },
  { name: 'Stop', iconId: 'stop', iconClass: 'i-tabler-player-stop' },
  { name: 'Newspaper', iconId: 'newspaper', iconClass: 'i-tabler-newspaper' },
  { name: 'School', iconId: 'school', iconClass: 'i-tabler-school' },
  { name: 'Microphone', iconId: 'microphone', iconClass: 'i-tabler-microphone' },
  { name: 'Camera', iconId: 'camera', iconClass: 'i-tabler-camera' },
  { name: 'Gallery', iconId: 'gallery', iconClass: 'i-tabler-gallery' },
  { name: 'Slideshow', iconId: 'slideshow', iconClass: 'i-tabler-slideshow' },
  { name: 'Film', iconId: 'film', iconClass: 'i-tabler-film' },
  { name: 'Book Open', iconId: 'book-open', iconClass: 'i-tabler-book-open' },
  { name: 'Book Closed', iconId: 'book-closed', iconClass: 'i-tabler-book-closed' },
  { name: 'Sparkles', iconId: 'sparkles', iconClass: 'i-tabler-sparkles' },
  { name: 'Rss', iconId: 'rss', iconClass: 'i-tabler-rss' },

  // Text Editing
  { name: 'Bold', iconId: 'bold', iconClass: 'i-tabler-bold' },
  { name: 'Italic', iconId: 'italic', iconClass: 'i-tabler-italic' },
  { name: 'Underline', iconId: 'underline', iconClass: 'i-tabler-underline' },
  { name: 'Strike', iconId: 'strike', iconClass: 'i-tabler-strikethrough' },
  { name: 'List Bullet', iconId: 'list-bullet', iconClass: 'i-tabler-list-check' },
  { name: 'List Number', iconId: 'list-number', iconClass: 'i-tabler-list-numbers' },
  { name: 'Quote', iconId: 'quote', iconClass: 'i-tabler-quote' },
  { name: 'Code', iconId: 'code', iconClass: 'i-tabler-code' },
  { name: 'Align Left', iconId: 'align-left', iconClass: 'i-tabler-align-left' },
  { name: 'Align Center', iconId: 'align-center', iconClass: 'i-tabler-align-center' },
  { name: 'Align Right', iconId: 'align-right', iconClass: 'i-tabler-align-right' },
  { name: 'Align Justify', iconId: 'align-justify', iconClass: 'i-tabler-align-justified' },

  // User & Account
  { name: 'User', iconId: 'user', iconClass: 'i-tabler-user' },
  { name: 'User Circle', iconId: 'user-circle', iconClass: 'i-tabler-user-circle' },
  { name: 'Users', iconId: 'users', iconClass: 'i-tabler-users' },
  { name: 'Profile', iconId: 'profile', iconClass: 'i-tabler-user-circle' },
  { name: 'Login', iconId: 'login', iconClass: 'i-tabler-login' },
  { name: 'Logout', iconId: 'logout', iconClass: 'i-tabler-logout' },
  { name: 'Key', iconId: 'key', iconClass: 'i-tabler-key' },
  { name: 'Shield', iconId: 'shield', iconClass: 'i-tabler-shield' },
  { name: 'Verified', iconId: 'verified', iconClass: 'i-tabler-check-circle' },

  // Data & Analytics
  { name: 'Chart', iconId: 'chart', iconClass: 'i-tabler-chart-line' },
  { name: 'Chart Dots', iconId: 'chart-dots', iconClass: 'i-tabler-chart-dots' },
  { name: 'Chart Bar', iconId: 'chart-bar', iconClass: 'i-tabler-chart-bar' },
  { name: 'Chart Line', iconId: 'chart-line', iconClass: 'i-tabler-chart-line' },
  { name: 'Chart Pie', iconId: 'chart-pie', iconClass: 'i-tabler-chart-pie' },
  { name: 'Chart Area', iconId: 'chart-area', iconClass: 'i-tabler-chart-area' },
  { name: 'Dashboard', iconId: 'dashboard', iconClass: 'i-tabler-dashboard' },
  { name: 'Analytics', iconId: 'analytics', iconClass: 'i-tabler-activity' },
  { name: 'Target', iconId: 'target', iconClass: 'i-tabler-target' },
  { name: 'Trending Up', iconId: 'trending-up', iconClass: 'i-tabler-trending-up' },
  { name: 'Trending Down', iconId: 'trending-down', iconClass: 'i-tabler-trending-down' },

  // Design & Creative
  { name: 'Brush', iconId: 'brush', iconClass: 'i-tabler-brush' },
  { name: 'Palette', iconId: 'palette', iconClass: 'i-tabler-palette' },
  { name: 'Magic Wand', iconId: 'magic-wand', iconClass: 'i-tabler-wand' },
  { name: 'Crop', iconId: 'crop', iconClass: 'i-tabler-crop' },
  { name: 'Vector', iconId: 'vector', iconClass: 'i-tabler-vector-triangle' },
  { name: 'Layers', iconId: 'layers', iconClass: 'i-tabler-layers-intersect' },
  { name: 'Component', iconId: 'component', iconClass: 'i-tabler-components' },
  { name: 'Template', iconId: 'template', iconClass: 'i-tabler-template' },
  { name: 'Puzzle', iconId: 'puzzle', iconClass: 'i-tabler-puzzle' },

  // Theme & Display
  { name: 'Sun', iconId: 'sun', iconClass: 'i-tabler-sun' },
  { name: 'Moon', iconId: 'moon', iconClass: 'i-tabler-moon' },
  { name: 'Contrast', iconId: 'contrast', iconClass: 'i-tabler-contrast' },
  { name: 'Brightness', iconId: 'brightness', iconClass: 'i-tabler-brightness' },
  { name: 'Desktop', iconId: 'desktop', iconClass: 'i-tabler-device-desktop' },
  { name: 'Mobile', iconId: 'mobile', iconClass: 'i-tabler-device-mobile' },
  { name: 'Tablet', iconId: 'tablet', iconClass: 'i-tabler-device-tablet' },

  // Communication
  { name: 'Mail', iconId: 'mail', iconClass: 'i-tabler-mail' },
  { name: 'Phone', iconId: 'phone', iconClass: 'i-tabler-phone' },
  { name: 'Message', iconId: 'message', iconClass: 'i-tabler-message' },
  { name: 'Chat', iconId: 'chat', iconClass: 'i-tabler-messages' },
  { name: 'Send', iconId: 'send', iconClass: 'i-tabler-send' },
  { name: 'Reply', iconId: 'reply', iconClass: 'i-tabler-arrow-back-up' },

  // Developer Tools
  { name: 'Code Block', iconId: 'code-block', iconClass: 'i-tabler-code-dots' },
  { name: 'Terminal', iconId: 'terminal', iconClass: 'i-tabler-terminal' },
  { name: 'Git Branch', iconId: 'git-branch', iconClass: 'i-tabler-git-branch' },
  { name: 'Database', iconId: 'database', iconClass: 'i-tabler-database' },
  { name: 'Api', iconId: 'api', iconClass: 'i-tabler-api' },
  { name: 'Bug', iconId: 'bug', iconClass: 'i-tabler-bug' },

  // Commerce
  { name: 'Cart', iconId: 'cart', iconClass: 'i-tabler-shopping-cart' },
  { name: 'Tag', iconId: 'tag', iconClass: 'i-tabler-tag' },
  { name: 'Tags', iconId: 'tags', iconClass: 'i-tabler-tags' },
  { name: 'Credit Card', iconId: 'credit-card', iconClass: 'i-tabler-credit-card' },
  { name: 'Dollar', iconId: 'dollar', iconClass: 'i-tabler-currency-dollar' },
  { name: 'Receipt', iconId: 'receipt', iconClass: 'i-tabler-receipt' },
  { name: 'Discount', iconId: 'discount', iconClass: 'i-tabler-discount' },
  { name: 'Gift', iconId: 'gift', iconClass: 'i-tabler-gift' },
  { name: 'Store', iconId: 'store', iconClass: 'i-tabler-building-store' },
  { name: 'Package', iconId: 'package', iconClass: 'i-tabler-package' },
  { name: 'Truck', iconId: 'truck', iconClass: 'i-tabler-truck-delivery' },

  // Productivity & Organization
  { name: 'Calendar', iconId: 'calendar', iconClass: 'i-tabler-calendar' },
  { name: 'Clock', iconId: 'clock', iconClass: 'i-tabler-clock' },
  { name: 'Timer', iconId: 'timer', iconClass: 'i-tabler-timer' },
  { name: 'Folder', iconId: 'folder', iconClass: 'i-tabler-folder' },
  { name: 'Archive', iconId: 'archive', iconClass: 'i-tabler-archive' },
  { name: 'Bookmark', iconId: 'bookmark', iconClass: 'i-tabler-bookmark' },
  { name: 'Flag', iconId: 'flag', iconClass: 'i-tabler-flag' },
  { name: 'Pin', iconId: 'pin', iconClass: 'i-tabler-pin' },
  { name: 'Star', iconId: 'star', iconClass: 'i-tabler-star' },
  { name: 'Heart', iconId: 'heart', iconClass: 'i-tabler-heart' },
  { name: 'Tasks', iconId: 'tasks', iconClass: 'i-tabler-list-check' },
  { name: 'Notes', iconId: 'notes', iconClass: 'i-tabler-notes' },
  { name: 'Clipboard', iconId: 'clipboard', iconClass: 'i-tabler-clipboard' },
  { name: 'Book', iconId: 'book', iconClass: 'i-tabler-book' },
  { name: 'Article', iconId: 'article', iconClass: 'i-tabler-article' },

  // Business & Marketing
  { name: 'Presentation', iconId: 'presentation', iconClass: 'i-tabler-presentation' },
  { name: 'Graph', iconId: 'graph', iconClass: 'i-tabler-chart-dots' },
  { name: 'Briefcase', iconId: 'briefcase', iconClass: 'i-tabler-briefcase' },
  { name: 'Rocket', iconId: 'rocket', iconClass: 'i-tabler-rocket' },
  { name: 'Bulb', iconId: 'bulb', iconClass: 'i-tabler-bulb' },
  { name: 'Trophy', iconId: 'trophy', iconClass: 'i-tabler-trophy' },
  { name: 'Target', iconId: 'target', iconClass: 'i-tabler-target' },
  { name: 'Megaphone', iconId: 'megaphone', iconClass: 'i-tabler-megaphone' },
  { name: 'Focus', iconId: 'focus', iconClass: 'i-tabler-focus' },
  { name: 'Building', iconId: 'building', iconClass: 'i-tabler-building' },
  { name: 'Building Skyscraper', iconId: 'building-skyscraper', iconClass: 'i-tabler-building-skyscraper' },
  { name: 'Activity', iconId: 'activity', iconClass: 'i-tabler-activity' },

  // Navigation & Location
  { name: 'Map', iconId: 'map', iconClass: 'i-tabler-map' },
  { name: 'Location', iconId: 'location', iconClass: 'i-tabler-map-pin' },
  { name: 'Navigation', iconId: 'navigation', iconClass: 'i-tabler-navigation' },
  { name: 'Compass', iconId: 'compass', iconClass: 'i-tabler-compass' },
  { name: 'Globe', iconId: 'globe', iconClass: 'i-tabler-world' },
  { name: 'Direction', iconId: 'direction', iconClass: 'i-tabler-directions' },

  // Content Types
  { name: 'Document', iconId: 'document', iconClass: 'i-tabler-file-text' },
  { name: 'Spreadsheet', iconId: 'spreadsheet', iconClass: 'i-tabler-file-spreadsheet' },
  { name: 'Presentation File', iconId: 'presentation-file', iconClass: 'i-tabler-file-presentation' },
  { name: 'PDF', iconId: 'pdf', iconClass: 'i-tabler-file-type-pdf' },
  { name: 'Archive File', iconId: 'archive-file', iconClass: 'i-tabler-file-zip' },
  { name: 'Music', iconId: 'music', iconClass: 'i-tabler-music' },

  // Web Development
  { name: 'Browser', iconId: 'browser', iconClass: 'i-tabler-browser' },
  { name: 'Code Brackets', iconId: 'code-brackets', iconClass: 'i-tabler-brackets' },
  { name: 'HTML', iconId: 'html', iconClass: 'i-tabler-brand-html5' },
  { name: 'CSS', iconId: 'css', iconClass: 'i-tabler-brand-css3' },
  { name: 'JavaScript', iconId: 'javascript', iconClass: 'i-tabler-brand-javascript' },
  { name: 'Responsive', iconId: 'responsive', iconClass: 'i-tabler-device-mobile-rotate' },
  { name: 'SEO', iconId: 'seo', iconClass: 'i-tabler-chart-arrows' },
  { name: 'Sitemap', iconId: 'sitemap', iconClass: 'i-tabler-sitemap' },

  // System & Settings
  { name: 'Cog', iconId: 'cog', iconClass: 'i-tabler-settings' },
  { name: 'Sliders', iconId: 'sliders', iconClass: 'i-tabler-adjustments' },
  { name: 'Toggle', iconId: 'toggle', iconClass: 'i-tabler-toggle-right' },
  { name: 'Power', iconId: 'power', iconClass: 'i-tabler-power' },
  { name: 'Cloud', iconId: 'cloud', iconClass: 'i-tabler-cloud' },
  { name: 'Wifi', iconId: 'wifi', iconClass: 'i-tabler-wifi' },
  { name: 'Bluetooth', iconId: 'bluetooth', iconClass: 'i-tabler-bluetooth' },

  // Social Media (Essential)
  { name: 'Facebook', iconId: 'facebook', iconClass: 'i-tabler-brand-facebook' },
  { name: 'X', iconId: 'x', iconClass: 'i-tabler-brand-x' },
  { name: 'Instagram', iconId: 'instagram', iconClass: 'i-tabler-brand-instagram' },
  { name: 'LinkedIn', iconId: 'linkedin', iconClass: 'i-tabler-brand-linkedin' },
  { name: 'YouTube', iconId: 'youtube', iconClass: 'i-tabler-brand-youtube' },
  { name: 'GitHub', iconId: 'github', iconClass: 'i-tabler-brand-github' },
  { name: 'Stripe', iconId: 'stripe', iconClass: 'i-tabler-brand-stripe' },
  { name: 'Discord', iconId: 'discord', iconClass: 'i-tabler-brand-discord' },

  // AI & Machine Learning
  { name: 'Robot', iconId: 'robot', iconClass: 'i-tabler-robot' },
  { name: 'Brain', iconId: 'brain', iconClass: 'i-tabler-brain' },
  { name: 'Network', iconId: 'network', iconClass: 'i-tabler-network' },
  { name: 'Processor', iconId: 'processor', iconClass: 'i-tabler-cpu' },
  { name: 'Algorithm', iconId: 'algorithm', iconClass: 'i-tabler-binary' },
  { name: 'Magic', iconId: 'magic', iconClass: 'i-tabler-wand' },

  // Accessibility
  { name: 'Accessibility', iconId: 'accessibility', iconClass: 'i-tabler-accessible' },
  { name: 'Contrast High', iconId: 'contrast-high', iconClass: 'i-tabler-contrast-2' },
  { name: 'Text Size', iconId: 'text-size', iconClass: 'i-tabler-text-size' },
  { name: 'Keyboard', iconId: 'keyboard', iconClass: 'i-tabler-keyboard' },
  { name: 'Voice', iconId: 'voice', iconClass: 'i-tabler-microphone' },
  { name: 'Caption', iconId: 'caption', iconClass: 'i-tabler-closed-captioning' },
  { name: 'Help', iconId: 'help', iconClass: 'i-tabler-help' },
] as const

export type IconId = typeof systemIcons[number]['iconId']
