import type Stripe from 'stripe'
import { vi } from 'vitest'

export const mockStripeCustomer: Stripe.Customer = {
  id: 'cus_test123',
  object: 'customer',
  address: null,
  balance: 0,
  created: Math.floor(Date.now() / 1000),
  currency: 'usd',
  default_source: null,
  delinquent: false,
  description: 'Test customer for testing',
  discount: null,
  email: 'mock@example.com',
  invoice_prefix: 'TEST',
  invoice_settings: {
    custom_fields: null,
    default_payment_method: null,
    footer: null,
    rendering_options: null,
  },
  livemode: false,
  metadata: {
    orgId: 'test_org_id',
    stripeMode: 'test',
    deployMode: 'test',
  },
  name: 'Test Customer',
  next_invoice_sequence: 1,
  phone: null,
  preferred_locales: [],
  shipping: null,
  tax_exempt: 'none',
  test_clock: null,
}

export const mockStripeSubscription: Stripe.Subscription = {
  id: 'sub_test123',
  object: 'subscription',
  application: null,
  application_fee_percent: null,
  discount: null,
  automatic_tax: {
    enabled: false,
    liability: null,
  },
  billing_cycle_anchor: Math.floor(Date.now() / 1000),
  billing_cycle_anchor_config: null,
  billing_thresholds: null,
  cancel_at: null,
  cancel_at_period_end: false,
  canceled_at: null,
  cancellation_details: {
    comment: null,
    feedback: null,
    reason: null,
  },
  collection_method: 'charge_automatically',
  created: Math.floor(Date.now() / 1000),
  currency: 'usd',
  current_period_end: Math.floor(Date.now() / 1000) + 30 * 24 * 60 * 60,
  current_period_start: Math.floor(Date.now() / 1000),
  customer: mockStripeCustomer.id,
  days_until_due: null,
  default_payment_method: null,
  default_source: null,
  default_tax_rates: [],
  description: null,
  discounts: [],
  ended_at: null,
  invoice_settings: {
    issuer: {
      type: 'self',
    },
    account_tax_ids: null,
  },
  items: {
    object: 'list',
    data: [{
      id: 'si_test123',
      object: 'subscription_item',
      billing_thresholds: null,
      created: Math.floor(Date.now() / 1000),
      metadata: {},
      price: {
        id: 'price_123',
        object: 'price',
        active: true,
        billing_scheme: 'per_unit',
        created: Math.floor(Date.now() / 1000),
        currency: 'usd',
        custom_unit_amount: null,
        livemode: false,
        lookup_key: null,
        metadata: {},
        nickname: null,
        product: 'prod_123',
        recurring: {
          aggregate_usage: null,
          interval: 'month',
          interval_count: 1,
          meter: null,
          trial_period_days: null,
          usage_type: 'licensed',
        },
        tax_behavior: 'unspecified',
        tiers_mode: null,
        transform_quantity: null,
        type: 'recurring',
        unit_amount: 1000,
        unit_amount_decimal: '1000',
      },
      quantity: 1,
      subscription: 'sub_test123',
      tax_rates: [],
      discounts: [],
      plan: {
        id: 'plan_123',
        object: 'plan',
        active: true,
        aggregate_usage: null,
        amount: 1000,
        amount_decimal: '1000',
        billing_scheme: 'per_unit',
        created: Math.floor(Date.now() / 1000),
        currency: 'usd',
        interval: 'month',
        interval_count: 1,
        livemode: false,
        metadata: {},
        nickname: null,
        product: 'prod_123',
        tiers_mode: null,
        transform_usage: null,
        trial_period_days: null,
        usage_type: 'licensed',
        meter: null,
      },
    }],
    has_more: false,
    url: '/v1/subscription_items',
  },
  latest_invoice: null,
  livemode: false,
  metadata: {},
  next_pending_invoice_item_invoice: null,
  on_behalf_of: null,
  pause_collection: null,
  payment_settings: {
    payment_method_options: null,
    payment_method_types: null,
    save_default_payment_method: 'off',
  },
  pending_invoice_item_interval: null,
  pending_setup_intent: null,
  pending_update: null,
  schedule: null,
  start_date: Math.floor(Date.now() / 1000),
  status: 'active',
  test_clock: null,
  transfer_data: null,
  trial_end: null,
  trial_settings: {
    end_behavior: {
      missing_payment_method: 'create_invoice',
    },
  },
  trial_start: null,
}

export const mockStripeMethods = {
  customers: {
    create: vi.fn().mockResolvedValue(mockStripeCustomer),
    retrieve: vi.fn().mockResolvedValue(mockStripeCustomer),
    update: vi.fn().mockImplementation((id, data) => Promise.resolve({
      ...mockStripeCustomer,
      ...data,
    })),
    del: vi.fn().mockResolvedValue({ ...mockStripeCustomer, deleted: true }),
  },
  subscriptions: {
    list: vi.fn().mockResolvedValue({
      object: 'list',
      data: [mockStripeSubscription],
      has_more: false,
      url: '/v1/subscriptions',
    }),
  },
}
