# How to redesign a website with customers in mind

If you're going through a website redesign, your site might look outdated and you feel it’s time for a change, or maybe there’s an issue of stagnant traffic and decreasing conversions you want to tackle by redesigning the experience.

Whatever the cause, in our experience a redesign can solve a lot of problems, but—if done wrong—can also ruin entire businesses. This guide is obviously here to help you carry out a successful redesign.

## What is a website redesign?

A website redesign is a significant change of the code, content, structure, and visuals of your current website to better serve your visitors. A great website redesign tends to boost revenue, lower bounce rates, and improve user experience.

## Some questions to ask before a website redesign

Research is a crucial part of your website redesign process: it’s the best way to find what’s working and isn’t, and to dig deeper into what your target customers want. When you start thinking about a redesign, there are some questions about your existing website and customers you must be able to answer:

- What pages and elements are working well?
- Who is coming to your website, and why?
- What are your most valuable pages right now?
- What specific, measurable customer need isn’t being met by the current website?
- What’s the rest of your business using the website for?
- How will you measure the success of the redesign?

Here is a redesign research process to help you get started to carry out a successful redesign: [Redesign research process](./website-redesign/research-process)
