# Tips to make your redesign as smooth as possible

We've heard quite a few horror stories about what happens when people do not follow a redesign process: terrible results include broken websites, plummeting conversions, or de-indexed pages. We decided to share the lessons we and others learned, so you can be warned about some of the most easily avoidable mistakes.

## 1. Don't do a hard reset on your existing design

A lot of companies treat a redesign like a hard reset. They don't try or think about learning lessons from the past. That’s the mistake: even if you plan to completely change the aesthetics of your website and even if you plan to reorganize the structure of it or introduce new pages, there is still a lot of insights on your existing site. There are so many lessons that you can take from how your customers behave and interact with the design and the copy you have now and translate that over to a new site.

## 2. Investigate what brings people to your site

The most powerful thing you can do as part of a website redesign is get to really understand why people come to your website. Make sure you’re meeting their needs and removing all obstacles for them.

For example: if someone lands on a page and the only thing they’re interested in is pricing information, the best thing you can do is to give them that. They don’t want to convert. That’s not on their mind right now. So don’t try to force them to buy—just provide them with the information they want.

## 3. Redesign with your customers in mind

It’s a common mistake to be so impressed with your own product that you want to tell the world everything about it. Your redesign plans include an extensive list of features and specifications, but that might not be what your customers want. The biggest problem you can face during a redesign is customer blind spots: not serving customers, not collecting data from customers, being very product-driven as opposed to customer-driven.

## 4. Don't use a design-first approach

Very often, a companies going through a redesign will get excited and launch straight into mockups and wireframes, without thinking about the words that will be needed on the page. They’ll design elegant solutions with blocks of placeholder text, and loop in a copywriter or content person at the end of the process—when all this person can do is either hope they can find good words that fit the frame.

If you launch into a design-first process, you forget a basic point: if the most wonderfully designed page uses weak, unconvincing words, it may actually underperform compared to a slightly uglier one where the copy is thoroughly persuasive and helps people do what they came to the site for.

## 5. Don't use vanity metrics to measure success

A popular metric for a website redesign is bounce rate. Designers often have a goal to lower the percentage of people who leave the website after viewing just the page they landed on; that difference often becomes the metric people use to compare an old site to a newly redesigned one.

But you have to ask yourself this: if the goal of your redesign is to give people what they’re looking for, they may now find it on the exact page they landed on so they don’t have to keep going through multiple pages. Your bounce rate will go up, which is a sign of success.
