# How to research for your website redesign

Just like you wouldn’t start a house remodel by knocking down walls without making sure they’re not load-bearing, you shouldn’t approach a website redesign by simply removing everything you have and restarting from scratch. You first need to understand what’s working and not working on the current site—so you know what can and should be preserved.

## Important things you need to know before and during a website redesign

Research is a crucial part of your website redesign process: it’s the best way to find what’s working and isn’t, and to dig deeper into what your target customers want.

Things you need to know when approaching, and then going through, a website redesign:

- Who is visiting your website, and why
- What your website’s most valuable pages are
- What propels or stops your customers
- How to measure success with Key Performance Indicators
- What to change—and how to test it

## 1. Who is visiting your website, and why

Redesigning with your customers in mind means knowing the intent that leads them there. One way to do it is by creating customer personas: semi-fictional representations of your existing and ideal customers, based on real demographic and psychographic data. Personas help you determine with a good degree of clarity:

- **Who your ideal customers are** (less in a ‘female, 42, has two dogs, lives in the city’ and more in a ‘project manager who leads a remote team of 5’ way)

- **What their main intent is** when visiting specific pages on your website (for example, the project manager who leads a team of 5 might be ‘looking to buy a piece of software that helps her automate 30% of her tasks’)

**Why this is important**: persona information helps you paint a clear picture of who you are redesigning for, and keep their needs and motivations in mind as you make redesign decisions.

For example: if customers get on your top landing page and the only thing they’re interested in is a store locator, the best thing you can do is to give them that. They don’t want to convert. That’s not on their mind right now. So don’t try to force them to buy—simply give them the information they want.

## 2. What your website’s most valuable pages are

Think of the website redesign process as a house remodel. You wouldn’t start a remodel by swinging your hammer in random directions and knocking down walls without first double-checking if they’re load-bearing. Likewise, before launching into a redesign, you should have a clear map of your website ecosystem and know which pages need to be handled with care versus which ones can be torn down and rebuilt from scratch.

One way to go about it is investigating the relationship between traffic and conversions; depending on how the two are connected, each of your website pages will fall into one of 4 likely categories:

- **High conversion, high traffic pages** → these are the most precious and valuable pages for your business: any mistake you make here could have disastrous consequences, which is why you need to approach them with caution and 10x more care compared to everything else you are going to redesign on your website.
- **High conversion, low traffic pages** → these pages are important because of the conversions they lead to, even if they don’t currently have a lot of traffic, which means you need to approach the redesign with care so as not to break anything that is already working.
- **High traffic, low conversion pages** → traffic is high on these pages, but something is obviously not working conversion-wise. Redesign while keeping improvement in mind: you’re not risking conversions with the changes you make, so you can afford to be more experimental than in the previous two categories.
- **Low traffic, low conversion pages** → changes to these pages are probably not going to be noticed because of the low traffic, and you’re not risking conversions anyway. Redesign all you want: these are the most risk-free pages on your site.

**Why this is important**: understanding which pages must be preserved and handled with care will help you get the most out of your website redesign while making sure you don’t break something that is working well and don’t tank conversions.

**How to do it**: Kaption helps you identify your most valuable (highest-traffic and/or highest-converting) pages.

## 3. Know what propels or stops your customers

Knowing what your most valuable pages are and who’s reaching them (and why) is a solid starting point for a website redesign—but it’s not enough for a successful one.

You must know what’s convincing/helping customers to complete the actions they came to take, and what’s stopping them along the way.

You can think of these as the ‘barriers’ and ‘hooks’ that your customers experience on the website:

Investigating barriers and hooks will help you form a clear idea of:

- Where people get stuck and experience issues
- What’s working and what isn’t on individual pages
- What people like or dislike about the overall experience
- What’s almost stopping people from converting
- What’s creating doubt and frustration

**Why this is important**: if you are not able to make the connection between the behavior of your customers and your website performance, and you can’t differentiate between elements that work and don’t, you won’t know what to keep and what to remove or re-think—and you might end up replicating a lot of the existing problems in the new design.

**How to do it**: when building this map of your website, it pays to combine insights from traffic analytics and internal sources with those you get from specialized behavior analytics software. These can include tools such as:

- Website [heatmaps](./heatmaps) and [session replay](./session-replay), which help you visualize your customers’ actual behavior and interactions with individual pages and elements

## 4. Know how to measure success with key performance indicators

If you are a business selling online, metrics related to your bottom line are the most accurate way to see whether your changes were successful. They get straight to the point: **did your redesign pay off for the business?**

Revenue-related metrics tie back to the point of your redesign: to create a site that your target customers love—and therefore, purchase from. They include:

- Number of conversions
- Conversion rate
- Revenue
- Average Order Value (AOV)
- Customer Lifetime Value (CLV)

You can also use qualitative metrics to determine the impact of your redesign. For example:

- Volume of support questions/tickets → has it decreased since the redesign?
- Customer Satisfaction Score (CSAT) → has the score improved? Are customers expressing more satisfaction with specific parts of your service (especially support)?
- Net Promoter Score (NPS) → has your score gone up, and has the distribution of your business’ detractors and promoters changed with the new website version?
- Customer Effort Score (CES) → a usual goal of a redesign is making the new website easier to use overall. Do people find that it takes less effort to use your website now, compared to before?

**Why this is important**: without clear KPIs, you won’t be able to determine if your website redesign was successful and by how much.

## 5. know what to change—and how to test it

You’ve done your research, you’ve lined up your KPIs, and you’re ready to start the redesign. The temptation to completely overhaul your site at once is probably lurking in the background—but a safer, more efficient way to go about it is **focusing on the small things that can make a big difference first, making changes, and testing the results**.

Variant testing is often a good solution with Kaption, especially if you have enough traffic to get to statistically significant results. You simply take one of your new elements and test the impact on your site’s goal in comparison to the current site. For example, you could:

- Test whether the video on your homepage (which existing customers have already told you they enjoyed) could be moved above the fold. If that works…
- Test whether social proof makes a difference to conversions on your checkout page. If it does…
- Continue with another change

**Why this is important**: a handful of landing pages likely form the bulk of your traffic and conversions. You do not want to break any of them. So take the most impactful idea that came out of your research, test it, implement if needed, and move on to the next one.

**How to do it**: Kaption's variant testing tool allows you to test hypotheses and add changes with a selected percentage of users, evaluate your variants based on goals, and pick the variant with the best results.

## Final thought: a website redesign is never really done

Customer preferences are always changing, and so are browser technologies, design practices, and accessibility standards. You’ll need to keep track of what your customers want and need—after all, they’re the people you’re designing the website for.
