# User-driven website analysis

User personas are a reflection of your real

Almost every guide to website analysis will tell you that you can evaluate a site’s performance by doing any or all of these actions:

- Analyze website traffic
- Test website speed
- Run an SEO audit
- Perform competitor analysis

They aren’t wrong, and we cover the same practices lower down the page. But we think website speed, SEO, and competitor and traffic analysis only ever tell part of the story behind your website’s performance.

The missing piece in your website analysis is understanding your visitors, users, and customers, and giving them what they came to your pages for so they don't just get onto your perfectly optimized site—they stay on it, and use it, and keep coming back. And that’s where our guide begins.

<!-- ![](./placeholder.jpg "placeholder") -->

## What is website analysis?

Website analysis is the practice of testing and analyzing a website's performance in relation to SEO, speed, competition, and traffic.

Any site can benefit from some form of website analysis if the results are then used to improve it—for example, by reducing page size to increase overall speed or optimizing a landing page with lots of traffic for more conversions.

## A user-driven approach to website analysis

We can all agree that it's important to have a site that ranks well on Google, is fast, and doesn’t have major usability issues. We can also agree that it's equally important for your business to understand your competitive landscape and maximize the traffic that gets to your website.

Standard website analysis helps you achieve all of the above—with a caveat: it won't give you a clear competitive advantage because your competitors are doing it, too. They all have access to the same SEO, performance, and traffic tools you use as well.

Another form of insight that you can leverage and is 100% unique to your website: **your users’ perspective**.

Finding out how **they** got to your site, what **they** want from it, how **they** are experiencing it, what’s working or not working for **them**—this will give you the holistic insight you need to build a great experience for the people who visit your website day in and day out.

![](./placeholder.jpg "A user-centric list of website analysis methods")

## Behavior analytics and feedback tools for website analysis

Your users are the extra source of knowledge you need to grow your website and business—they have all the information you need about what’s working, and isn’t, on your website. Kaption behavior analytics helps you collect this knowledge and answer valuable business questions, such as:

- How do people interact (or fail to) with individual page elements and sections?
- Where on a page do people get stuck and struggle before dropping off?
- What do they actually want from the website or product?
- What are they interested in or ignoring across the website?

## Behavior analytics tools

Behavior analytics tools, such as Kaption [heatmaps](/heatmaps) and [session replay](/session-replay), help you understand how people behave on and interact with your website. Heatmaps aggregate behavior on a page, highlighting the buttons, call to actions, and other clickable elements that your visitors are interacting with, scrolling past, and ignoring; session replay shows you how people navigate between pages and help you uncover potential bugs, issues, or pain points they experience across their journey.

<!-- ![](./placeholder.jpg "placeholder") -->

A combination of these tools will help you identify the drivers that lead people to your website, the barriers and the obstacles they encounter, and the hooks that ultimately make them stay and convert—check out the next chapter about user-driven website analysis for a more in-depth analysis and additional methods.
