# User-driven analysis methods

You and your competitors know the same things, and use the same tools.
Everybody knows this:

- It’s important to use the right analysis tools, understand the competitive landscape, and know how each site stacks up against its rivals
- It’s also important for a website to rank well on Google and other search engines so people can find it
- It's important for it to load quickly and have no major technical errors so people can use it

**How do you compete and stand out in a crowded field?** Leverage your most valuable resource: your users. Analyzing your website from their perspective reveals how people actually use specific features, what they want from you, and how to turn them into loyal customers—and that’s where your competitive advantage lies.

## What user-driven analysis means

User-driven analysis is a type of website analysis that involves collecting and evaluating data from, and about, website users to create a better experience for them.

By cultivating a deeper understanding of your users, you can tailor your website and services to better address their wants, needs, and goals. Effective user-driven analysis can lead to an improved user experience, more website traffic, and increased conversion rates.

## Why you need to run user-driven analysis

Most websites rely only on traditional analytics or SEO analysis as their main improvement tools to understand:

- How users reach a site and move from page to page once they're there
- How competitors perform in search engines
- How site pages are showing up in search engine results
- What keyword opportunities for growth there are
- What backlinks the pages have acquired
- Which pages customers most often convert on or leave the website from
- How differently segmented populations behave (e.g. by country, by traffic source)

There is one big caveat: these website analysis systems can tell you about the movement of visitors towards and across your site, but not why they took certain actions or how they really interact with the pages and product once they were there.

If you really want an in-depth, holistic understanding of your website’s current performance—so you can build a roadmap for its optimization—you need knowledge of the user experience.

## The solution: user-driven analysis

User-driven analysis is an essential companion to other long-established website analysis methods (traffic, speed, SEO etc.) because it reveals user behaviors and preferences that aren't otherwise measured. It places the focus on the user experience and gives insight into the minds of your website users:

- The drivers that motivate people to visit your website
- The hooks that persuade users to convert
- The barriers that prevent them from completing an action and/or converting

In essence, traditional analytics and SEO analysis might tell you the what, but user-driven analysis can help you understand the why.

## Types of user-driven analysis

There are several categories of commonly used user-driven analysis, ranging from methods that almost get you inside the users’ heads to ones that give you data about their actions and preferences. Let’s briefly run through what they are and how they work.

## 1. User personas

<!-- ![](./placeholder.jpg "placeholder") -->

**What they are**: user personas are semi-fictional characters that represent the real people who use your website.

**Why they’re important**: by creating a fleshed-out persona, you will get to know the motivations, fears, and concerns of your ideal website user. Creating user personas is a useful exercise for better understanding the different ways people search for, buy, and use your products or services.

**How to do it**: to create user personas, you first need to gather relevant psychographic (psychological characteristics) and demographic data about your users. It’s simple to collect it with an on-page survey on a highly trafficked page of your website.

Collect relevant demographic details, like age, occupation, and income, but also ask questions that address the following three overarching queries:

- Who are you?
- What’s your main goal?
- What’s your main barrier to achieving this goal?

Analyze the data (we have a user persona analysis template that can help), and use the most frequent answers to build a persona that represents the largest chunk of your user base.

## 2. Market research

<!-- ![](./placeholder.jpg "placeholder") -->

**What it is**: market research is a set of techniques used to better understand a company’s target market. Some common market research techniques are surveys, focus groups, 1-on-1 interviews, and customer observation.

**Why it’s important**: market research allows you to learn directly about the people who use your website. This helps you override false assumptions about your user base, improve the user experience, and even come up with marketing and ideas for future products.

**How to do it**: many people associate the term market research with external marketing agencies, but you can run lean market research on your own. For example, here is our four-step method of DIY market research:

1. Create user personas (as described in the previous section) using data gathered from user surveys.
2. Conduct observational research by watching users as they interact with your website, either in person or using a tool (for example, through session replays).
3. Run informational interviews with users to gather data on both how they interact with your site and their motivations and opinions.
4. Once you’ve collected all this data, analyze it to create flow models, customer journey maps, and other useful visualizations. These exercises are meant to help you visualize and categorize the data you’ve collected, and make it easier to share with your team/customers.

Remember: the point of lean market research is to find quick, actionable insights you can use to improve your website.

## 3. Usability testing

<!-- ![](./placeholder.jpg "placeholder") -->

**What it is**: usability testing is a way to evaluate the functionality of a website by observing real users as they attempt to complete tasks.

**Why it’s important**: usability testing helps to reveal issues with your website that you, as someone intimately familiar with it, may have become blind to over time. It can highlight technical glitches, misleading wording, design flaws, and bugs that affect your visitors and potential customers.

**How to do it**: there are many methods of usability testing, ranging from unmoderated and remote techniques (like session replays) to in-lab usability testing with moderators and participants.

If you are just getting started with usability testing, consider starting out with a cost-effective, easy method, like session replays. These allow you to watch videos of how users interact with your website to see the paths they take, the way they interact with important features, and any major obstacles they encounter.

Take notes on their actions and anything that surprises you or differs from how you expect users to behave. Analyze the data you collected to draw conclusions and improve your website’s usability.

## 4. Behavior analytics

<!-- ![](./placeholder.jpg "placeholder") -->

**What it is**: behavior analytics tools help you understand the behavior of your users as they interact with your website. Popular behavior analytics tools include user recordings (also a form of usability testing) and heatmaps.

**Why it’s important**: with web analytics, you usually see a ‘clean’ set of events (e.g., someone visited a homepage → clicked on a button → visited a pricing page, spent a lot of time on it) but you can’t quite know what happened in between those things—and how people behaved throughout the journey.

For example: maybe your users' time on page is high because they are trying to find something they can't immediately see; or maybe they got to the page by mistake and now they’re stuck because they don't know where else to go. Behavioral analytics allows you a close-up view of what’s happening on your site with clear visual data points.

**How to do it**: one of the most popular tools in this category are heatmaps. These are visual representations of data that show the most popular (hot) and unpopular (cold) elements on your webpage.

heatmaps are easy to set up and provide useful data for making decisions about website design. Use them to make sure people are seeing your most important content, clicking on the elements you want them to, and aren’t becoming confused or distracted when interacting with your pages.

## Get started

Empathizing with the user experience is the first step towards improving it. The data you collect during the user analysis process can help you get to know and understand your users better, which in turn will help you design improved customer experiences for them.

Ready to get started? [Set up an action checklist](./analysis-checklist) to run user analysis and begin learning more about your website and the people who visit it.
