# Website analysis checklists to evaluate your site

We all want fast, usable sites that search engines can crawl and index for the right terms. But we shouldn't ignore what happens later: once people do get onto an optimized website, they have to decide whether or not it’s worth staying.

Let's look at website analysis from both perspectives. First, we share a few valuable checklists to help you nail the basics of website speed, SEO, traffic, and performance, and then we cover our step-by-step method for running user-driven analysis.

## Why you need a website analysis checklist

Website analysis can look like an overwhelming task: there are so many potential metrics to measure and thousands of tools you could use to do it.

A website analysis checklist will:

- Prevent you from wasting time on unimportant or inefficient methods of evaluation
- Give you a roadmap to follow
- Guarantee that you’ve collected all of the data you need to draw conclusions for improvement

## Standard steps and checklists for website analysis

Classic website analysis employs traditional analytics tools, SEO investigation, page speed tests, and performance evaluations to make sure all the important components of your website are in optimal working order. It’s ideal for finding major technical or stylistic issues and understanding basic trends about your website’s traffic flows.

You can perform a comprehensive basic website analysis by following these approaches:

## 1. Analyze website traffic

Analyzing traffic helps you monitor the flow and activities of users on your site and identify the most successful pages and traffic-generation techniques.

Use the Kaption traffic analytics tool to look at traffic patterns on your site. Some key questions to focus on are:

- Is your website’s traffic trending up or down?
- Where is traffic coming from?
- What pages are generating the most traffic?
- What is the bounce rate? Where are people leaving your site?
- Is there a difference in mobile vs. desktop traffic and behavior patterns?

<!-- ![](./placeholder.jpg "placeholder") -->

Knowing the popularity of different pages and which ones draw in the most visitors or convert the best can help you re-evaluate your marketing campaigns and allocation of resources.

## 2. Audit your site’s SEO processes and results

Because SEO is a vast discipline, an SEO audit can take multiple shapes. Here are the three most common types of analysis you’ll want to run:

### A. Review your on-site SEO

There are certain elements every page should have in order to rank well in search engines. Make sure that every page on your site is formatted correctly with:

- Title tags
- Meta descriptions
- Proper subheading structure
- Internal links

Draw up a list of pages that are lacking in proper SEO structure, and make plans to optimize them to increase your rankings and traffic.

### B. Check your search engine rankings and authority

It’s not enough to optimize your website for SEO internally; you also need to understand how you stack up against other sites in your niche. This can be broken down in two ways:

- Competitive rankings: use a competitive analysis tool like Ahrefs, SEMrush, or SerpBook to see what keywords you rank well for and how well your chosen keywords are performing against the competition. You can use this information to optimize certain pages on your website to better compete and drive more traffic.

- Domain strength: third-party tools have simple metrics to estimate the ‘strength’ of a domain’s backlink profile and how realistic it is for a website to compete against others in the same niche. By doing their best imitation of Google, these tools assign a number from 1 (weak) to 100 (strong) to add up the value of link volume and link quality.

### C. Perform backlink analysis

Looking at domain strength is a necessary but surface-level action. To really understand what’s happening beyond an aggregate level, you want to see where competitors are getting backlinks so you can replicate their strategy in a way that works for you.

For example, you might see that sites in your niche are constantly listed on resource pages that mention adjacent tools. You can reach out to those exact sites if you aren’t already mentioned and linked (this is link building 101)—but also, take that learning to find similar sites you can then reach out to.

## 3. Measure your page speed

Websites that load slowly risk lower search engine rankings, in addition to driving away frustrated users—it’s a lose-lose situation.

There is no need for a checklist here: simply check your load time using [WebPageTest](https://www.webpagetest.org/) or Google’s [PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights/) for both desktop and mobile devices. In addition to telling you how quickly your site loads, both tools will also give insights on how to speed it up.

## 4. Check for website errors

Broken links and error pages can be frustrating for users and can cause search engine to penalize you. Use the [Google Search Console](https://developers.google.com/search#?modal_active=none) to identify and fix these errors.

## 5. Confirm mobile responsiveness

It's crucial for your webpages to function just as well on mobile devices as they do on computer screens, for at least three reasons Google officially shared:

- Mobile searches make up over 50% of Google.com searches
- Mobile-friendly sites show up higher in search engine page results
- Visitors are 5x likely to leave a website that isn’t mobile-friendly

Most importantly: Google rolled out the **mobile-first index** in 2018, which means that pages are evaluated for **all devices** based on their performance on mobile. So if you have a killer desktop experience but suffer on mobile, **all that matters is mobile for your search rankings**.

The first, necessary step of your analysis is making sure your website is mobile-friendly: that it looks and functions well on any size screen, and that it loads fast on mobile. You can do this check through a tool like [Google’s mobile responsiveness checker](https://www.thinkwithgoogle.com/feature/testmysite/).

## The user-centric checklist for performing website analysis

Established analysis methods and checklists like the ones above are crucial to bringing your website to a solid place performance-wise, but they are limited when it comes to making sure that the people you brought to your pages actually stay there.

User-driven analysis fills that void by focusing on actual visitors—and, specifically, on:

- The **Drivers** that bring people to your website
- The **Barriers** that might stop them or make them leave
- The **Hooks** that persuade them to convert

Read ahead for a step-by-step overview of user-driven analysis. We’ve also slimmed this information down into a handy one-page checklist that you can immediately download (click on this link or on the image below) and start following.

## Step 1: find what drives people to your website

Find out what’s bringing people to your website so that you can capitalize on the most lucrative traffic sources and make an action plan for less robust ones.

Instead of guessing or making assumptions, you can discover your visitors’ drivers by asking them to describe what they are looking for on your site, and why, in their own words.

### Use the data to create user personas

Use the data you’ve collected to create user personas who reflect your typical users. Personas will help you better understand who your website users are and what they are trying to achieve.

## Step 2: define the barriers that stop or drive users away

Figuring out the factors that cause users to leave your site can help you address their concerns and keep them on the page longer. To isolate these barriers, you can use a variety of behavioral analytics tools.

### Find your high-exit pages

Using Kaption's analytics tools, you can collect data on how customers move from page to page on your website. Identify the high-traffic exit pages where you lose most of your visitors.

### Find the most problematic section(s) on your drop-off pages

Once you know which page(s) your visitors are leaving from, take a closer look to get an overall idea of what may not be working. Analyzing a strategically placed heatmap can help you can investigate if people are:

- Reaching important content or failing to see it
- Finding and using a page’s main links, buttons, and CTAs
- Getting distracted by non-clickable elements
- Experiencing issues across devices

### Watch how people interact with each page

Once you know where people are dropping off, you can watch how individual visitors interact them using a session replays tool. Take notes on whether people:

- Encounter bugs and/or broken elements
- Can interact with buttons or clickable elements
- Hesitate when performing an action
- See all the content correctly
- Use ‘rage’ clicks when the browsing experience is frustrating

Pro tip: instead of just focusing on people who leave, review sessions of people who do make it to the final destination—comparing the two can help you spot obvious and useful differences in behavior and help you get closer to a solution.

## Tying it all together

As you go through this checklist, your website’s strongest and weakest points will become apparent. Some areas might need further investigation, but you should have enough information to make informed decisions on the areas of your website that need improvement.
