# The steps involved in building a user journey map

## Step 1: Create comprehensive user personas

User personas are a reflection of your real customers that help in understanding their needs and expectations. It is a good idea to start with baseline personas and then go on to creating multiple ones to get a deeper understanding of who your users are exactly. It also helps in introducing your workshop participants with the users involved in the customer journey.

To get you inspired, here’s an example of a user persona:

<!-- ![](./placeholder.jpg "placeholder") -->

## Step 2: Get a grasp of the user goals

Do you know what your users want to achieve with your products and services? If you are unsure, then getting a sense of your user goals should be your primary focus.

During the creation of a journey map, set up activities to unleash customer goals and then place them in a logical sequence. Such an arrangement can be used to provide structure to the map as you determine its specific stages.

Each stage can have one or more corresponding goals attached to it, and should be categorized as easy or difficult. As a result, you’ll be able to uncover any frustrations or unexpected positive surprises that customers experience throughout the journey. Once you’ve determined goals for all the different stages, you can then proceed to building your hypothetical user map.

## Step 3: Map out the user’s touchpoints

Maps are a great method of communicating the alignment between your customer’s expectations and their experiences throughout the user journey. Therefore, it is imperative to identify all the points of contact and situations (both online and offline) that arise when a client meets your brand. As you’ll notice, some touchpoints carry more weight than others. For instance, a bad check-in experience at a hotel can surely spoil your entire stay!

To avoid setbacks and keep your customers happy, it would be wise to keep a record of all potential touchpoints that occur between customers and your organization.

## Step 4: Figure out customer pain points and frustrations

Now is the time to focus on determining your customers’ pain points and roadblocks. This can be achieved by asking yourself user-centered questions and interviewing your customers and the customer-facing staff. A few potential questions to ask would be:

Can my customers achieve their goals with my website?
What are problems and areas for improvement?
At which part of the process are customers abandoning purchases and why?
Once you know the roadblocks, mark them down on the user journey map. Also, jot down the areas where you are performing well but could use some improvements.

## Step 5: Prioritize and eliminate the roadblocks

Identify the parts that must be fixed immediately and ask yourself if there are any particularly problematic features. For example, giving your sign-up process a face-lift would be a good idea if your customers are frequently complaining about it. The good news is, you don’t always need to implement radical changes! Breaking everything down and starting from scratch might not be needed, and just a few minor changes will suffice to improve your product.

## Step 6: Update and enhance

Last, but not least, make sure your user journey map is a living document and that it is not set in stone. Since your customers are constantly evolving, it is important to keep checking their satisfaction levels and improve the user journey map if such a need arises. If it is feasible, update and improve your journey map every six months or so. Also, keep in mind that whenever a significant change is introduced to your product, the customer journey map should be updated accordingly.

## Summary

A user journey map is a visual depiction of the entire customer experience. It provides ample benefits of viewing your product from a different perspective, identifying loopholes, analyzing differing user scenarios, and bringing the entire team on the same wavelength. If done efficiently, a user journey map is one of the most effective design tools and strategies for turning your product into a success.
