# The best usability testing questions

To get the most accurate and actionable results from any usability test, you must ask the right questions first. In fact, collecting qualitative and quantitative feedback from your users is as important as observing how they interact with your app or website.

Usability testing has at least four different stages

- Screening
- Pre-test
- Test
- Post-test

All stages provide the opportunity to collect important data from your participants. In each stage, your different goals will dictate the questions you ask.

## 4 Types of usability testing questions

### 1. Screening usability questions

Screening questions will help you pre-qualify your users for your UX testing. When you work on your usability testing, you need to establish a set of criteria and decide what types of participants you want to include in your test. You should ask about:

- Demographic data, such as gender, occupation, age, and income, or firmographic data, such as location, industry, company size, etc. This information will help you, for instance, determine if you’re targeting the right occupation from the right location.

- Tech-literacy, for example: how easy is it for your users to use mobile devices? Asking such a question will help you, for instance, choose only those people who have average-to-high tech skills.

### 2. Pre-test usability questions

Pre-test questions go beyond just collecting demographic data, these help you narrow down your users. These include:

- Behavioral questions, like: “How often do you shop online?” Their answer will reveal their buying habits and their familiarity with online shopping.
- What do you use the site or app for? – to understand separate use cases
- What problems does this product help you solve? – to understand and group user goals
- Which features do you use most? – to identify users, who are already familiar with your product vs those who are new to it

### 3. Test usability questions

These questions should be inquired as users engage with your site. Your goal is to collect data that explains why users make certain choices while navigating the assigned tasks.

Questions listed below help discover what the user is doing, and why:

- What did you think of the checkout experience? - to collect general impressions and nail down any UX/UI flaws
- When you log on, what’s the first thing you do? – to understand user motivation
- Why did you decide to leave this page? – to understand exit intent

### 4. Post-test usability questions

After a usability test, you have one final chance to ask the user questions that haven't been answered elsewhere. Common questions:

- Based on your experience, how frequently would you use this product/feature? – to find out how valuable the product is for users
- What were your feelings about the instructions? – to optimize user testing sessions in the future
- How likely are you to recommend this website or app to others? – to help you evaluate customer loyalty levels and understand key issues
- How would you compare [x] to [competitor]? - to see how different details of your website stack up against your competitors in the eyes of users.
