# The different types of usability testing methods

There isn’t just one usability test, there are various types. Let’s take a look at the main usability testing methods, when you should use them, and why.

## 1. In-person usability testing

This occurs in the same room as your users. There are different in-person usability testing methods which you use, including:

- **Eye-tracking**: see what parts of the interface get the most focus and which parts are overlooked.
- **Guerilla testing**: is about volume and involves testing with as many random people as possible.
- **Lab testing**: introduces a controlled environment where testers can be evaluated based on the target market characteristics. You can conduct it in-house or in a 3rd party facility.
- **Observational usability testing**: the participants are testing your product in a quiet location while you act as an observer but without being physically present. You may use screen recording or video recording to observe users’ behavior.

## 2. Remote usability testing

This takes place when you and your participants are in two separate locations. Here are the most common forms of remote usability testing:

- **Session recordings**: using screen recording tools enable you to remotely test ideas and observe how users interact with your interface.
- **Via phone**: one-on-one sessions where researchers interview participants through the phone. Both parties can ask questions.
- **Digital card sorting**: users receive digital cards and are asked to sort them in a way that will make the most sense to them. This helps with designing the right information architecture.

## 3. Comparative testing

It’s used to compare your product against two or more solutions. It can help you generate new ideas, features, and functionalities.

## 4. Exploratory testing

Users are given the opportunity to freely explore the product – you can check how they interact with the interface. Testing happens naturally and the evaluator has no influence over the participants.

## Start usability testing with Kaption

One of the easiest ways to get started with user testing is through session recordings: this helps you identify usability issues with your site by just watching real people interact with your pages and elements. It requires little setup and is a simple way to start improving the functionality and effectiveness of your website.
