# Usability evaluation and analysis

Once you've finished running your usability testing sessions, it's time to evaluate the findings. Learn how to extract the data from your results, analyze it, and turn it into an action plan for improving your website.

## What's a usability test report?

A usability test report is a document you prepare after evaluating all the feedback and insights from sessions with users. These include, notes and observations, evidence data (e.g. session replays), as well as quantitative and qualitative feedback from participants.

The process of turning a mass of qualitative data and observations into a report on usability issues can seem overwhelming at first—but you can follow the structure below:

## How to evaluate usability testing results

### Executive summary

The goal of the executive summary is to quickly onboard anyone who picks up your report to understand what it covers and what the key findings were in a simple paragraph.

### Background summary

This section should be written in a way that allows anyone who hasn’t been involved in the usability test to quickly understand why you ran the test.

- What the test objectives were
- What site pages/features were tested
- Who the testers were

### Methodology

Explain what methodology and tools you applied. Did you use user session recordings? Or maybe you performed lab tests? This is the section where you should also specify all the questions you asked your users.

### Audience

Describe your participants as thoroughly as possible. Make sure to include their demographic/firmographic data and why you’ve decided to recruit them in the first place.

### Test results

Create a detailed description of the results. To improve readability, we highly recommend that you include a table that clearly specifies all key data – the number of participants, task completion rates, types of assignments, and other data.

### Findings and recommendations

Make a bulleted list of findings and a separate list for recommendations. These should be findings that you observed, not merely assumed. Also, you can either make one overall list of your findings or have them segmented by scenarios.

## How to get started?

One of the easiest ways to get started with usability testing is through [session replays](/session-replay). Watching how users navigate your website can help you create the best user experience possible.
