# How to get started with session replays

When you are ready to create session replays for your website, you only need two things: a session replay generator software like Kaption to record user interaction, and a clear idea of which pages you need to analyze. Let’s take a look at both.

<!-- ![](./placeholder.jpg "placeholder") -->

## Start recording your user interactions on your site easily with Kaption

To get session replays of any page you are interested in, you will need to use a session replay tool like Kaption to record user interaction. And if you are new to Kaption, there is a free trial to begin.

Here's what to do:

- Follow the instructions to [install the tracking script](../../docs/add-script) on your website.

Once your script is installed and verified, go to your session replays page in the dashboard. **And that’s it!** you just need to wait for people to visit your site so Kaption can start recording their experience on your site.

## Optimize your session replays

### 1. Make sure your session replays are set up for variant testing

If you’re running an variant tests, recordings will show you how your visitors are reacting to and interacting with different variations of your site, pages, or features. Keep track of pages or page elements that you’re testing with variants. Plan to watch session replays after new launches, page updates, and other relevant changes or tests that you run on your site.

### 2. Combine session replays with other tools

Session replays can take a lot of the guesswork out of optimizing your site, but when you combine replays with other analytics tools—like heatmaps and traffic analytics- you can dig even deeper into user behavior to identify which changes need to be made to improve the user experience (UX) and increase conversion rates (CRO).
