# Getting actionable insights from session replays

Watching replays is a great way to understand what visitors do and how they interact with your website. It’s one of the closest things to being in the same room as them and see exactly what they do as they click, tap, scroll, and move on and across pages and screens.

<!-- ![](./placeholder.jpg "placeholder") -->

## 1. Get ready for a watching session

Before you start watching session replays, you will need to ‘get in the zone’ and create a focused watching environment.

## 2. Define the goal of your watching session

Whether you have tens or thousands of session replays to go through, start by identifying what you want to get out of your watching session: knowing what you want to achieve helps you determine which recordings you should start with.

## 3. Use your goal to narrow down the data

Once you know what you want to get out of your watching session, you’re ready to get onto the session replays page, which will look something like this:

<!-- ![](./placeholder.jpg "placeholder") -->

## 4. Know what to spot when you watch

Once you define your goals and narrowed down the recordings you have to watch, you’re ready to press play.

You usually need 10-20 recordings to get in a good viewing flow, after which you should be able to start seeing patterns and develop an understanding of where users hesitate and/or get confused, and what leads them to abandon the site/app.

This is what a Kaption session replays looks like:

<!-- ![](./placeholder.jpg "placeholder") -->

## 5. Find your first solutions

At the end of your watching session, you should have a clear list of things to fix, improve, investigate, and/or change that need adding to your pipeline. The final thing to do is decide which one(s) you are going to tackle first.

One way to make this decision easier is to take into account factors such as:

- How much research will be required to understand the situation in depth
- How much time/money/effort it will cost to implement a fix or deploy a change (including the time spent planning & getting approval for the fix itself, not just its implementation)
- How much this fix/change will improve the experience on your website/app
- How many people will be affected by it

If you prioritize your list based on these parameters, you’ll be able to pick the highest improvement - highest impact - fastest and easiest deployment solution(s) you need to start from—usually, these will be related to bugs, broken elements, or really obvious obstacles that make the user journey across your site or app impossible or extremely difficult.
