# Combining session replays with other tools for more insight

With session replays, you don’t need to guess what people are doing on your website: you can actually watch how they browse, interact with, and move across pages, so you can empathize with their journey and spot any issues they encounter—which in turn gives you valuable data to change and fix their user experience.

But replays alone can’t give you all the answers you need to improve and optimize your site: to super-charge your work, you have to combine them with other behavior and tools.

<!-- ![](./placeholder.jpg "placeholder") -->

## Session replays and traffic analytics

Kaption traffic web analytics give you plenty of quantitative data points about large-scale traffic and usage patterns. You can certainly make educated guesses about what’s happening based on numbers and charts—but you’re still missing some crucial context behind them both.

For example: what do you do after Kaption traffic analytics reveals that you have a page with lots of traffic but very few conversions? As a first step, you can find a list of relevant sessions, review 10-20 of them, and start observing what people actually do on the page.

## Session replays and variant testing

session replays and variant testing are very closely linked: you can use insight that you get from replays to define test hypotheses, and you can also watch replays of variant test page variations to understand what is making a page more successful than the other.

## Session replays and heatmaps

Session replays are generated for individual users and show you their actions across multiple pages, while heatmaps help you visualize data from page visitors in aggregate.

When you are interested in a specific page, heatmaps can give extra clarity to the insights you pick up from a set of replays. For example: if you notice the same behavior across 5 or 10 replays, you might be tempted to generalize and think that everybody visiting the page behaves in the same way. A heatmap will easily help you prove or disprove the assumption.
