# How to get started with heatmaps

When you are ready to create heatmaps for your website, you only need two things: heatmap generation software like Kaption to collect the data for you, and a clear idea of which pages you need to analyze. Let’s take a look at both.

<!-- ![](./placeholder.jpg "placeholder") -->

## Start viewing heatmaps on your site easily with Kaption

To get a heatmap of any site page you are interested in, you will need to use a heat-mapping tool like Kaption to collect and render the data for you. And if you are new to Kaption, there is a free trial to try out.

Here's what to do:

- Follow the instructions to [install the Kaption tracking script](../../docs/add-script) on your website.

Once your script is installed and verified, go to your heatmaps page in the Kaption dashboard.

Create your first heatmap by entering the path to a page on your site. **And that’s it!** you just need to wait for people to visit your site so Kaption can start recording their user interaction behavior.

## What your heatmap data will look like

<!-- ![](./placeholder.jpg "placeholder") -->

Once your Kaption tracking script is installed and verified, you need to wait for people to visit your page so Kaption can start recording their behavior.

It only takes one person to visit the page for Kaption heatmaps to start working, but data based on just one visitor might not be very useful. As more and more data gets recorded, Kaption generates the heatmap visualization for pages on your site.

In addition to the at-a-glance understanding that you will get from your heatmaps, you and your UX design team can easily find exactly where you need to place elements to capture users’ attention.

## Best pages to view heatmap data on

Heatmaps allow you to take a deeper dive into any of your website pages, but it makes logical sense to view the ones that are most important to you in terms of traffic, usability, and business objectives.

### 1. Homepage and landing pages

Your homepage and main landing page(s) are the main entry points into your website. They are often responsible for your website visitors’ first impressions and for their decision to continue browsing or abandon the website. A heatmap on these pages will help you determine how much information gets seen or interacted with, and what elements are being clicked on or ignored.

### 2. Top pages

Your best-performing pages (the most viewed product page, the most commented blog post, etc.) are obviously doing something right: eye tracking with a heatmap can help you understand what is working well, so you can replicate the success elsewhere.

### 3. Under-performing pages

Your worst-performing pages are as important as the previous ones, but for the opposite reason: there is likely something wrong with them, and viewing a heatmap there can help you understand what your visitors are (not) seeing or interacting with, so you can take action.

### 4. New pages

Your newest web pages don’t have a lot of data: if you recently added a page to your website, viewing a heatmap there might be a good way to get some initial information about how the page is performing.
