# The complete guide to website Heatmaps

Heatmaps are a powerful way to understand what users do on your website pages—where they click, how far they scroll, what they look at or ignore.

In this guide, you’ll find an introduction to different types of
heatmaps and how to create and analyze them. You’ll also get real case
studies and practical examples, so you can see for yourself just how
valuable and useful heatmaps are when it comes to improving and
growing your website.

## What is a heatmap?

A heatmap is a graphical representation of data where values are depicted by color. Heatmaps make it easy to visualize complex data and understand it at a glance:

<!-- ![Placeholder Image](./placeholder.jpg "placeholder") -->

A heatmap is a graphical representation of data where values are depicted by color. Heatmaps make it easy to visualize complex data and understand it at a glance:

<!-- ![](./placeholder.jpg "placeholder") -->

## What is a website heatmap?

Website heatmaps visualize the most popular (hot) and unpopular (cold) elements of a webpage using colors on a scale from red to blue.

By aggregating user behavior, heatmaps facilitate data analysis and give an at-a-glance understanding of how people interact with an individual website page—what they click on, scroll through, or ignore—which helps identify trends and optimize for further engagement.

Heatmaps also usually display the average fold, which is the portion of the page people see on their screen without scrolling as soon as they land on it.

## Types of heatmap

Heatmap is really an umbrella term for different heatmapping tools: scroll maps, click maps, and move maps. Knowing the difference is handy, as each type helps you investigate a slightly different aspect of your website performance.

### Scroll maps

<!-- ![](./placeholder.jpg "placeholder") -->

Scroll maps show you the exact percentage of people who scroll down to any point on the page: the redder the area, the more visitors saw it.

### Click maps

<!-- ![](./placeholder.jpg "placeholder") -->

Click maps show you an aggregate of where visitors click their mouse on desktop devices and tap their finger on mobile devices (in this case, they are known as touch heatmaps). The map is color-coded to show the elements that have been clicked and tapped the most (red, orange, yellow).

### Move maps

<!-- ![](./placeholder.jpg "placeholder") -->

Move maps track where desktop users move their mouse as they navigate the page. The hot spots in a move map represent where users have moved their cursor on a page, and research suggests a correlation between where people are looking and where their mouse is—meaning that a move map gives you an indication of where people might be looking as they go through your page.

### Desktop & mobile heatmaps

<!-- ![](./placeholder.jpg "placeholder") -->

Desktop and mobile heatmaps help you compare the performance of your website on different devices. For example, content that is prominent on a desktop page might sit much further below the fold on a phone—and you need to see if interaction differs, and how.
