# What is heatmap analysis: how to analyze a heatmap

Heatmap analysis is not rocket science, and it’s very easy to pick up insights just by looking through examples. The best way to analyze any heatmap is to go through the specific user experience questions about how people interact with your page, and use the insights to make immediate-benefit changes and come up with ideas for further research.

<!-- ![](./placeholder.jpg "placeholder") -->

## What is heatmap analysis?

Heatmap analysis is the process of reviewing and analyzing heatmap data to gather insights about user interaction on the page. This data analysis can lead to improved site designs with lower bounce rates, fewer drop-offs, more pageviews, and better conversion rates. These results can be even more effective by running usability tests (like website variants testing).

## A checklist for heatmap analysis

There are some questions you can answer through heatmap analysis grouped into this handy checklist:

- Are people seeing important content?
- Are people getting distracted?
- Are people clicking on key page elements (links, buttons, and CTAs)?
- Are people confused by non-clickable elements?
- Are people experiencing issues across devices?

## 1. Are people seeing important content?

To understand if people are actually seeing important content elements or sections on your page, take a look at a scroll map: the heatmap that shows you how far down the page people scroll.

Start by reviewing the position of the average fold, which is the portion of the page people see on their screen without scrolling as soon as they land on your site:

<!-- ![](./placeholder.jpg "placeholder") -->

Knowing where the average fold lies helps you **confirm whether people are accessing all the most important information on landing**. For example, you might have very persuasive content that sits a little below the fold, which means people will only see it if you’ve managed to capture their attention enough that they are willing to scroll down.

Continue the analysis by reviewing the entire scroll map and looking at the percentage of visitors who make it to specific page points; this data can be particularly useful on longer pages, such as a landing page, with a lot of information you want people to see.

Also, look out for sharp changes in color: they indicate that a significant percentage of people stopped scrolling—they might be thinking they have reached the end of the page and can’t figure out, from context, that there is more content below.

Using scroll map information, you will have enough data to determine whether key information is getting ignored by the majority of your users and needs moving to a more visible place.

## 2. Are people getting distracted?

When multiple web page elements compete for people’s attention, they can cause users to **lose focus on the most important action(s) they need to take**.

Review your move heatmaps and observe whether cursor activity is spread all over the page instead of being focused on its key messages and call-to-action buttons and links. Also, check if there are areas of the page that receive no interaction: you may need to redistribute your content or remove/replace content that is taking up valuable space on the page.

## 3. Are people clicking on key page elements (buttons, links, and CTAs)?

While a scroll map helps you understand if people are seeing specific content elements, a click map quickly confirms if users are clicking on them or not:

<!-- ![](./placeholder.jpg "placeholder") -->

Your website exists so people can fulfill goals such as find information, sign up for a service, or buy a product. When reviewing a click map, look out for the main calls-to-action (CTAs), buttons, and links that allow users to take those actions: are these elements being clicked—or, in the case of a mobile heatmap, tapped? How much interaction are they receiving? Are people ignoring something you’d rather they focused on?

Use this insight to either make successful design changes or justify the need for more in-depth user research. If and when you end up changing the page, referring back to the click map will help you compare behaviors and understand if your new design is successful.

## 4. Are people confused by non-clickable elements?

Non-clickable elements that look like they might be clickable can cause confusion and frustration for users who waste their clicks while expecting to be taken elsewhere.

<!-- ![](./placeholder.jpg "placeholder") -->

In the example above, it seems like somebody tapped on one of the testimonial logos, probably **expecting some interaction to take place**. Keep this scenario in mind as you review your click maps and look for non-clickable elements like images, titles, or graphical shapes that show evidence of click and tap activity.

If you see this type of user behavior, you might need to make a few visual changes to differentiate your clickable and non-clickable elements, or add links where previously there were none.

## 5. Are people experiencing issues across devices?

Your website can look quite different for desktop and mobile users: important content that is immediately visible on a desktop could end up well below the fold on a phone, where fewer users see it; vice-versa, your page content could look very compact and well-structured on a mobile device, but sparse and poorly organized on very large screen

<!-- ![](./placeholder.jpg "placeholder") -->

Compare mobile and desktop scroll maps of the same page to see if people are consuming more/less content depending on the device they are on; pair scroll maps with click maps to see if clicking behavior changes and people interact more/less/differently on desktop versus mobile. If you spot any glaring differences, your next steps can go from applying successful changes to completely restructuring your page.
