# User-centric conversion rate optimization guide

Forget about best practices and quick hacks: to increase website conversion rate, your best move is to understand your visitors, users, and customers, and give them what they need.

In this guide, we dispel a few myths about conversion optimization, and show you a CRO plan to help you gather the data you need to improve your conversion rates over and over again.

## What is conversion rate optimization (CRO)?

Conversion rate optimization is the practice of increasing the percentage of users who perform a desired action on a website. Desired actions can include purchasing a product, signing up to your newsletter, signing up for a service, clicking on a link, or completing a form.

### A user-centric definition of CRO:

Standard definitions of CRO place their focus on conversion percentages, averages, and benchmarks. A user-centric way of defining CRO: think of it as **the process of focusing on understanding what drives, stops, and persuades your users**, so you can give them the best user experience possible that makes them convert and improves your CRO.

We believe this definition works better because many things happen before the final action (the conversion):

- Specific **drivers** bring people to your website
- Specific **barriers** make them leave
- Specific **hooks** persuade them to convert

**Drivers**: what is bringing visitors to your site?
**Barriers**: where and why are your users leaving your site?
**Hooks**: what persuaded your users to act?

When you’re working to improve conversions, not every problem is backed by hard numbers, and with a clear-cut answer.

Whether you own an e-commerce site or manage online marketing or search engine optimization, CRO will constantly be a prioritized topic to help you grow.

<!--
## How to calculate conversion rate
Conversion rate is calculated by dividing the number of conversions (desired actions taken) by the total number of visitors and multiplying the result by 100 to get a percentage.

![](./placeholder.jpg "placeholder")

### What is the average conversion rate?
Depending on what you read, the average conversion rate is anywhere between 1% and 4%.

But let us come out and say it: this figure is sort of meaningless, since:

- Conversion rates differ wildly depending on the conversion goal (ad clicks, checkout completions, newsletter signups, etc.)
- Every website, page, and audience is different
Most people don't share their conversion data publicly anyway

You’re better off focusing on developing an in-depth understanding of what actually matters to your users, so you can give it to them—and then, conversions will naturally follow. -->

## The best conversion rate optimization tools

Your brain, ears, eyes, and mouth are the primary tools you need to understand your customers, empathize with their experience, draw conclusions based on the data, and ultimately make the changes that improve your conversion rates.

How do you use these free tools?

- Listen to what your users have to say about your website
- Watch how people use your website
- Immerse yourself in the market
- Talk to whoever designed and built your site
- Speak to the team that sells and supports your product/service
- Draw connections between different sources of feedback

All the other optimization tools are simply the means that help you do it.
