# 3-step CRO plan to improve your conversion rate

If you were playing a game of chess, your ultimate goal would be to checkmate your opponent; but before you got there, you’d need to evaluate the whole board carefully, and repeatedly.

It’s the same with your website: before making any sort of move, you need to look at the big picture.

## CRO plan

There's three things you need to know in order to get a full overview of your website so you can optimize it efficiently:

- The **drivers** that bring people to your website
- The **barriers** that might stop them or make them leave
- The **hooks** that persuade them to convert

The best way to get the big picture and make your next moves is to narrow your focus and go through specific actions.

1. Find what drives people to your website
2. Find what might stop potential users
3. Find what really persuades visitors to act

## Step 1: find what drives people to your website

If you want to convert your traffic, you need to understand why people are reaching your website. They could be coming from a specific Google search for your product, simply doing some research, or following someone’s recommendation without knowing anything about you—if you treat them all the same, you cannot tailor the experience and prioritize the right messages for the demographics that matter most to your business.

Instead of guessing or making assumptions, find out your visitors’ **drivers** by asking them to describe what they are looking for, and why they want it, in their own words.

### Define your top personas and what they need from your website

**Why**: user personas are realistic representations of your visitors that help you get a better sense of who your users and customers are, and what they need.

**How**: set up a quick survey and ask your visitors:

- A question to identify the demographic that matters most to you:
  > How would you describe yourself in one sentence?
- A driver-related question to understand what is driving them:
  > What’s the main reason for your visit today?
- A final question to identify what may be stopping them from doing something (you can re-use this data in the barriers step):
  > What, if anything, is stopping you from [action] today?

Keep collecting answers until you reach a number that makes sense for your traffic: for example, if you have little traffic, 80 clear answers might be enough.

**Add the top drivers and user personas to your CRO action plan.**

## Step 2: find what might stop potential customers

Without knowing where and why visitors are leaving your site, you cannot really improve their experience and your conversion rates. Instead of making changes based on opinion or standard best practices and hoping for the best, put on your detective’s hat and focus on finding the biggest barriers to conversion.

### Identify where people leave your website

Your first step towards understanding and defining BARRIERS is assessing where you are losing the most people. We’ll start by identifying your most problematic pages, and then we'll zoom into their weakest parts.

#### 1. Find your high-exit pages

**Why**: identifying the high-traffic exit pages where you lose most visitors helps focus your optimization efforts on the biggest opportunities.
**How**: Kaption's conversion-tracking tools help you track how your users enter and leave your site, what pages are the most visited, and where your users exit your site.

#### 2. Find the most problematic sections on your drop-off pages

<!-- ![](./placeholder.jpg "placeholder") -->

**Why**: once you know that people leave on a specific page, take a more in-depth look at their experience and interaction right before they drop off.

**How**: Kaption tracks user behavior on all your pages automatically without manual setup. Continuous heatmaps show you what users do on your site and their interactions before leaving.

**Add the top barriers to your CRO action plan.**

### Discover why people leave your website

After you determine the problematic pages, you must gather some context that will help you fix them.

#### 1. Watch how people interact with each page

**Why**: watching how people interact and abandon your website lets you empathize with their journey and spot any issues they encounter. This gives you some of the visual data you need to fix and improve their experience.

**How**: review Kaption's session replays that end on the drop off page. As you watch them, try to assess if visitors:

- Hesitate when performing an action
- Experience loading issues across devices/browsers
- See all the content correctly
- Can interact with buttons or clickable elements
- Encounter bugs and/or broken elements

**Add the top 3 reasons people leave your site to your CRO action plan.**

## Step 3: find what persuades visitors to act

Knowing what persuaded your existing users and customers to act gives you a clear picture of what you need to do more (and what you need to stop doing), to increase conversion of future visitors.

### Ask your customers what persuaded them to convert, and what almost caused them not to.

**Why**: asking people who have converted what persuaded them to act will help you discover conversion-boosting insights you can then emphasize for all other customers. You will also hear about elements that almost stopped them, which you can similarly address for potential future customers.

**How**: set up a post-goal survey to show up as soon as a customer sees reaches your conversion goal. Ask three questions

1. How would you rate your overall experience?
2. a) If the answer to question 1 is positive, ask: What did you love the most about the experience?
3. b) If the answer to question 1 is negative, ask: What can we do to improve the experience?
4. What almost stopped you from completing your purchase?

**Add the top 3 hooks to your CRO action plan.**

## What's next?

After you fill your CRO action plan, you will find that your conversion issues will be more specific. Some areas might need further exploring, but you should have enough insight to understand how your conversion optimization strategy should unfold, and why.

Present your discovery to your teammates/clients. Summarizing the important user information in one page helps everyone see the issues clearly. Focus on solving the easiest and most impactful solutions first.

Remember that conversion rate optimization is an continuous process. CRO is not complete after the first run. Once you've start making changes to address your users' drivers, barriers, and hooks. Re-do the process all over again and discover your next big conversion improvement.
