import * as cdk from 'aws-cdk-lib'

// import * as cp from "aws-cdk-lib/aws-codepipeline"
// import * as cpa from "aws-cdk-lib/aws-codepipeline-actions"
// import * as pipelines from "aws-cdk-lib/pipelines"
// import * as codebuild from "aws-cdk-lib/aws-codebuild"
// import { PrimaryStage } from "./stage-primary"
import type { Construct } from 'constructs'
import type { CustomStackProps } from '../config'

/**
 * The pipeline stack adds resources needed for the CI/CD deployment
 */
export class PipelineStack extends cdk.Stack {
  constructor(scope: Construct, id: string, props: CustomStackProps) {
    super(scope, id, props)

    // Artifacts are code/files stored in CodePipeline S3 Bucket
    //  const sourceArtifact = new cp.Artifact() // Holds the source code in s3 artifact
    // const cloudAssemblyArtifact = new cp.Artifact() // Holds cloud assembly generated by steps in s3 artifact

    // // Get the code from Github on commit to [branch]
    // const sourceAction = new cpa.GitHubSourceAction({
    //   actionName: "GitHub",
    //   output: sourceArtifact,
    //   oauthToken: cdk.SecretValue.secretsManager("github-repo-token"),
    //   owner: "kaption-co",
    //   repo: "darwin-api",
    //   branch: "release",
    // })

    // const stackName = stageId(props.stage, "PipelineStack")

    // Synthesize CloudFormation template from the CDK app
    // const synthAction = new pipelines.SimpleSynthAction({
    //   sourceArtifact,
    //   cloudAssemblyArtifact,
    //   installCommand: "yarn install --frozen-lockfile",
    //   buildCommand: `yarn build  --NODE_ENV production --no-sourcemap`,
    //   synthCommand: `npx cdk synth "${stackName}"`,
    //   testCommands: ["yarn test-eslint && yarn test-types && yarn test-unit"],
    //   environment: { buildImage: codebuild.LinuxBuildImage.STANDARD_5_0 },
    //   environmentVariables: {
    //     GIT_COMMIT: { value: sourceAction.variables.commitId },
    //   },
    // })

    // // Create the pipeline construct
    // const pipeline = new pipelines.CdkPipeline(this, baseId("Pipeline"), {
    //   cloudAssemblyArtifact,
    //   sourceAction,
    //   synthAction,
    // })

    /**
     * Pre-Production
     */
    // const preStage = new PrimaryStage(this, StageId.Pre, props)
    // const preCdkStage = pipeline.addApplicationStage(preStage)

    // /**
    //  * Set up environment variables for testing
    //  */
    // const useOutputs: Record<string, pipelines.StackOutput> = {}

    // preStage.urls.forEach(({ name, output }) => {
    //   useOutputs[`DARWIN_URL_${name.toUpperCase()}`] = pipeline.stackOutput(
    //     output,
    //   )
    // })

    // /**
    //  * Run integration testing
    //  */
    // preCdkStage.addActions(
    //   new pipelines.ShellScriptAction({
    //     actionName: "IntegrationTests",
    //     runOrder: preCdkStage.nextSequentialRunOrder(),
    //     additionalArtifacts: [sourceArtifact],
    //     commands: [
    //       "printenv | grep DARWIN", // log injected vars for debugging
    //       "yarn install --frozen-lockfile",
    //       "yarn test-integration",
    //     ],
    //     useOutputs,
    //   }),
    // )

    /**
     * Create manual approval to go to production
     */
    // preCdkStage.addManualApprovalAction({
    //   runOrder: preCdkStage.nextSequentialRunOrder(),
    // })

    /**
     * Production
     */
    // const prodApp = new PrimaryStage(this, "prod", {
    //   ...props,
    //   env: awsEnv(),
    // })
    // pipeline.addApplicationStage(prodApp)

    cdk.Tags.of(this).add('Stack', id)
    cdk.Tags.of(this).add('CreatedBy', 'cdk')
  }
}
