---
title: Privacy & Kaption
description: Privacy and data security are a top priority at Kaption Analytics
---

## Encryption, security, and stability

Kaption was designed with privacy in mind. The primary goal of the product is to improve user experiences while maintaining their privacy. In fact, we believe Kaption can help companies manage their user privacy better.

For this reason, Kaption is careful both about what information we store and how it is stored. In addition, we diligently follow best practices for authentication, security and data encryption.

## Improving websites, for you

**Online businesses use Kaption to create better website experiences.**

Nobody wants to waste their time on a website that is confusing and hard to navigate.

You know it, we know it, and website owners know it too—which is why they turn to Kaption.

Website owners use Kaption to better understand user behavior: what actions people take on a website, what elements of a page they click or ignore, what they enjoy, where they struggle. With this insight, website owners can then make changes that improve the overall experience for all website users. And that includes you.

## We record interactions, not your sensitive data

**Kaption is designed for websites to get insights. And respect your privacy.**

When you browse a website that has Kaption installed, we collect data about your interactions (e.g. where you click, scroll your mouse, move in between pages) and use it to create visual representations of the experience. Website owners get these insights without tracking IP/MAC addresses-- the stuff that relates to the device you use.

Some Kaption tools, like session replay, reconstruct the individual actions you took during a website visit; others, like heatmaps, aggregate data points from you and hundreds of other visitors in one report.

But in all cases, by default, sensitive data that you might enter on the site (your credit card details or phone numbers) will never reach our servers: we cannot see it, and neither can the website owner. Kaption customers viewing a session recording will only see asterisks (‘\*\*\*’ ) instead of numbers.

## We will never share or sell your data

**Not to advertisers. Not to third-party services. Not to anyone.**

Nobody here at Kaption likes the idea of tools following us around different websites or companies sharing and selling our data without our permission. We are committed to making sure this doesn’t happen to you, either.

Kaption is designed to help make websites easier to use, and the data we track about your website visit is only used for this purpose. We don’t follow you around the Internet: website owners who use Kaption cannot see or find out about your activity on sites they don’t own. Likewise, we don’t harvest personal data or sell it to anyone for any reason. Nor do we mine it for profiling or advertising purposes.

## Request and access your data, anytime

**Your data is stored securely, and you can ask to see it whenever you want.**

As a website visitor, you have the right to request access to the personal identifiable information a website owner collected and stored about you. You also have the right to request that this information is deleted.

At any time, you can request a website owner who uses Kaption to give you access to your data. They can run a search for personal data from inside the Kaption dashboard; the system will then generate and email you a report that lets you view, and delete, any data connected with you.

## Tracking: we'll always give you options

**If you prefer websites not to track data about your visit, we can help.**

If you want to stop a website using Kaption from collecting data about your visit, you should know that the website owner is responsible for getting your consent to collect and process data about your visit (and must allow you to withdraw that consent as well).

But we understand that you might want Kaption to not process data about you regardless of whether a site owner asks for permission or not, so we want to give you an extra option. If you put a ‘Do Not Track’ flag on your browser, Kaption will look for it before we collect any data about your site visit. Not everybody does that, but we do.

## Compliance commitment: GDPR, CCPA, and more

**Our customers can use Kaption in a compliant manner, for you.**

We follow a ‘privacy by design’ approach, so we’re big supporters of privacy acts and regulations like the General Data Protection Regulation (GDPR), and the California Consumer Privacy Act (CCPA) that enhance your privacy rights and protection as a consumer.

We have built the necessary controls around anonymity and consent to make sure website owners who use Kaption can do it in a compliant manner. Plus, our legal team is fully committed to keeping up-to-date with any changes in the law and making sure they are reflected in our product.
