---
title: Analytics Overview
description: How Kaption captures data and provides analytics.
---

Kaption is an event based analytics tool that gives you cutting edge information capture which measures everything that happens in your website and app. In this section, we'll dive into some of Kaption's analytics features.

## Configuring Tracking

The first step in working with Kaption is [creating custom events](./events-goals) including macro and micro conversion goals. Then you'll want to review your [site configuration and tracking settings](./site-settings) to make sure it complies with any specific requirements of your business.

## The Dashboard

Once you've installed the tracking script and configured your site. You're ready to use Kaption's dashboard. Here you'll get access to all sorts of [free analytics tools](https://www.kaption.co) for your website.

![Visualization Dashboard](../dashboard/dashboard.webp "Visualization Dashboard")

To learn about using the standard dashboards, filtering by dates and dimensions, and creating custom dashboards of your own; check out this doc on [using Kaption's dashboard](./dashboard).

## Using Analytics Features

Now you're all set up. It's time to learn about the individual tools that Kaption provides and how to leverage them for maximum benefit.

### Traffic and Reports

Learn how Kaption tracks your visitors and how to create [web traffic data visualizations](./trafficReports).

### Interaction Heatmaps

Visualize how people are interacting with your web pages with [interaction heatmaps](./heatmaps). This is a great way to see visually what is sticking out to your visitors.

### AB Testing / Experiments

Create different versions of text and CSS with simple visual tools then capture conversion data based on each. Watch your analytics to see which version performs better. Check out Kaption's [AB analytics](./ab-analytics)

### Session Replay

Watch user's as they interact on your site or sign up for your app. Monitor any errors or issues and make sure problems only happen once. Read up on [session replay](./session-replay)

### Tracking Clicks, Scrolls, Touches, and More

Tracking user interaction data is a much more concrete way of knowing if you're seeing real users and also if they are interacting with your site. Learn about [behavior tracking](./behavior-tracking)

### Performance and Debugging

As Kaption tracks most of what happens during a user's visit, it's great for front-end monitoring. For example, tracking errors and UI issues.

Learn about the [performance and debugging](./performace) panel.
