---
title: Install Guides
description: The Kaption Tracking Code needs to be installed within your site in order to start collecting data. Install manually or follow a platform specific guide.
---

## Install Guides

Kaption is installed via a typical JavaScript snippet that should be added to your app or site's HTML code. However, providers have different ways of doing this so here we provide some helpful guides for popular providers.

## Platform Specific Guides

If you are using one of the below platforms, we recommend referring to the installation guide for step-by-step instructions.

### Installation Guides

- [BigCommerce](./bigcommerce-installation)
- [ClickFunnels](./clickfunnels-installation)
- [Google Tag Manager](./google-tag-manager-installation)
- [Hubspot](./hubspot-installation)
- [Instapage](./instapage-installation)
- [Joomla](./joomla-installation)
- [Shopify](./shopify-installation)
- [Squarespace](./squarespace-installation)
- [Webflow](./webflow-installation)
- [Weebly](./weebly-installation)
- [Wix](./wix-installation)
- [WordPress](./wordpress-installation)

Don't see something you need on this list? Please [let us know](/support).

## Get Kaption Tracking Code and Install Manually

If you prefer to install the Tracking Code manually, or if your specific platform is not listed above, follow the instructions below.

### Get Tracking Code

Login to [Kaption's Dashboard](https://app.kaption.co/login) and select the site you want to track in the navigation dropdown.

![Select Site](./install1.webp "Kaption - Select Site")

Once your site is selected, visit "Tracking Code" in the navigation.

![Tracking Code](./install2.webp "Kaption - Tracking Code")

Copy the tracking code HTML that you'll find there.

![Copy Tracking Code](./install3.webp "Kaption - Copy Tracking Code")

### Add Tracking Code

Add the tracking code in the `<head>` section of your website and save changes.

![Add Tracking Code](./install4.webp "Kaption - Add Tracking Code")

### Verify Installation.

Once you've saved your changes, you can verify your install on the Kaption dashboard.

![Verify Tracking](./install5.webp "Kaption - Verify tracking code")
