---
title: 0 to 100k monthly visitors within 4 months
description:
excerpt: Website heatmaps are a conversion optimization tool that helps you understand how pages on your website are performing.
authorName: Andrew Powers
authorWebsite: https://linkedin.com/in/arpowers
authorTwitter: arpowers
authorEmail: andrew@fiction.com
---

## Your SEO Process

If you're here you probably are reading this because you have a website and you'd like to get more traffic?

At Darwin we have years of experience building all sorts of traffic from organic/SEO to PPC to partnerships. So far we've created a decent amount of traffic for the site and here we'll be showing in exact detail the process we use to create organic search visitors.

We'll be going over the following:

- Ways to increase your site's performance to perform better for SEO
- How to analyze and focus on direct attention to get more high quality traffic
- How to create great content that will resonate with your audience (and search engines)
- Ways to get backlinks without spamming
- Tips and tricks along with recommended tools

## Technical Optimization and On Page SEO

The first step in the SEO initiative is going to be getting the technical SEO set up. (This part is a bit technical, so you may want to pass it along to your developers and move on to the next section.)

### Using WordPress?

- Most blogs are running on WordPress. Compared to newer tech, WordPress is like an antique which runs sometimes 50 database queries before the page is even loaded. That's why it's _critical_ that you use a caching plugin. There are [free caching plugins](https://wordpress.org/plugins/w3-total-cache/) or premium ones like WP Rocket. These plugins essentially keep the results of those dozens of DB queries in the server's memory (cache) and just respond with that. It can lead to a 10x speed improvement and drastic changes in ability to scale.
- To optimize your images, use [SMUSH](https://wordpress.org/plugins/wp-smushit/) which will compress your images to the extent possible. Images can lead to big loading problems, if you don't have anything in place.

### Technical SEO Tips and Tricks

This part is a little technical, but stay with me.

#### Sitemap.xml

In JavaScript apps, sitemaps are difficult to create as they need to be generated by the server or a utility. I've heard people say they aren't important, but they definitely are if you want your content to rank in search.

WordPress excels in this area, there are several plugins that make sitemaps a breeze. Otherwise there are several sitemap generation tools you can use online.

#### Robots.txt

Another "easy" technical SEO tip is to make sure you have a `robots.txt` file and that it points to your `sitemap.xml`. Ours looks like this:

```bash
Sitemap: https://www.darwin.so/sitemap.xml

User-agent: *
Disallow:
```

Of course, if you don't need your pages on Google, you don't need a robots.txt.

#### Site Organization

- You should not deeply nest pages that you'd like to rank. Typically we only have 3 levels of page depth in any of the sites we manage.
- No more than 3 clicks. Steve Jobs used to say "nothing should take more than 3 clicks" ... the same is true for finding specific pages on your site.

#### Serving Images

There are several modern formats for images that are designed for good compression and small size. This means better images for the same file size.

These formats are WebP, Jpeg2000, JpegXR and they are massively superior to JPG, PNG, etc.

If you're able to use a plugin or a CDN that can optimize these images for you, we highly recommend it. Otherwise, there are plugins for Photoshop and other tools which will allow you to export them yourself.

### Plagiarized and Duplicate Content

Due to understandably difficult problems with spam and plagiarism, Google can't stand duplicate content. If they detect duplicated or plagiarized content on your site, you will be penalized, heavily.

If you have duplicate content on your own site, then just merge the pages. There are many tools you can use to test for duplicate content, or what Google perceives is duplicated.

For plagiarized content, if you hire people to write for you, then you will want to have a step that verifies that content isn't plagiarized. There are many free tools for this also, just do a search.

> **SEMRush** - Although it's expensive, Darwin uses SEMRush to help with all aspects of technical SEO as outlined above. They have an excellent site audit tool that continually runs and audits your site.

Optimize all your pages by best practice. There’s a bunch of general best practices that Google wants you to follow for your web pages (maintain keyword density, have an adequate # of outbound links, etc.). Install YoastSEO or RankMath and use them to optimize all of your web pages.

### Technical SEO (Pro Level)

Have some technical chops? Cool, let's talk about the tricks you can do if you do.

For both desktop and mobile, you should shoot to have a website that loads in roughly 3 seconds or less. Google has been increasingly vocal about including this in ranking factors, for reasons I won't go into here.

You'll want to look at your page vitals, you can use your Darwin Analytics [page vitals and performance report](https://www.darwin.so/features/performance) to see how those are performing over time and across devices.

There are many reasons loading time may be slow, but here are some common things to look at:

- Use [GTMetrix](https://gtmetrix.com/analyze.html) to run a quick audit of your site's loading performance
- Optimize the loading of static assets like images. You can often lazy load them or `preload` them as needed using relevant metatags.
- Make sure compression is enabled. We highly recommend using Brotli compression if it's available. Cloudflare is great for this.
- Assets should be minified to remove unneeded characters likes spaces. This can improve size by ~30%.

### CDN

You should make sure you're using a CDN and fully customize it to meet the requirements of your website (caching). Check out Cloudflare for DNS and BunnyCDN for further optimization.

Most CDNs are super cheap for traffic below 1M visitors a month, and even after that stay affordable unless you are doing something crazy.

Want to make your life easier AND fix up all these issues and more? Use WP Rocket. The tool basically does all your optimization for you (if you’re using WordPress, of course).

### Google's Page Speed Initiative

In May 2020, Google officially rolled its "page vitals" update. This update takes a few "vitals" that are judged as the usability related performance metrics, and factors them into your ranking.

You can check out how your site performs using the [Page Speed insights tool](https://developers.google.com/speed/pagespeed/insights/).

These are the primary metrics measured:

- **FID** - First Input Delay (under 100ms) - How long does it take until your page becomes usable.
- **CLS** - Cumulative Layout Shift (under 0.1) - Do you have changes that may make it an awkward loading experience.
- **LCP** - Largest Contentful Paint (under 2.5s) - This describes how long it takes your page to render.

## Keyword Research

Now that you've optimized your website to the extent possible, the next step is to think deeply about your goals with SEO.

This manifests itself in keyword research. Which comes down to the question which search terms are interesting and attainable?

### Create A Document

You'll need a document, which we can a research sheet, to manage your planning process. The sheet is used for:

- Prioritizing content
- Keeping track of the schedule and process for each piece of content

And the sheet covers:

- **Target Search Terms** or search phrases
- **Search Volume** How many people might search for a specific term each month
- **Priority of keywords**
  - Top priority: Words seen as low competition, high traffic and targeted (converting)
  - Mid priority: Attainable words but not necessarily highly desireable
  - Low priority: Nice to have but not something to focus on
- **Status:** What is the status of a piece of content?
  - Planned: The content has been added to the plan and prioritized (not written)
  - Picked Up: The content has been assigned to a creator
  - In Draft: The content is being created or written
  - Editing: The content needs to be edited or is being edited
  - Published: Content is live on the website
- **Topic Group:** Which category content belongs to.
- **CPC** The high and low bid regarding cost per click for a specific keyword can tell you a lot about your ability to rank for it. Also it will tell you how well it will convert if you actually do. Higher CPC words generally convert at higher rates.

## Step-by-Step Keyword Research

Here is a simple step by step guide to doing your keyword research. Let's go...

Start off by creating a list of your top 5 SEO competitors.

Get started by listing your top 5 competitors relating only to SEO. Don't worry about whether or not they are actually competitors. Do they have a strong SEO presence in your niche? They are a competitor.

If you're not really sure who your competitors are, just search for your most desired keywords and see who comes up.

Next, lets run those companies through SEMRush and see how well they are doing. Where they are getting their traffic and if it's growing or shrinking.

Run each competitor through the organic research tool in SemRush and you'll be given a list of keywords that these companies rank on. Grab the relevant ones and add them to the long keyword list on your sheet.

This is the primary way we will get the 'initial' list of target keywords we can work with. Run these keywords through the SEMRush keyword magic tool and you'll get further ideas to add to your sheet.

For now, we're ready to move on to the next step. Over time, you'll discover and add new keywords to sheet but perfection takes time.

## Build SEO Landing Pages

Now that we have some basic keywords selected, let's discuss the ways of targeting them with content: landing pages and blog posts. Starting with landing pages...

This step is a lot more straightforward that you may think, you don't need to create a custom landing page for every term. The trick is to develop a nice and readable template that can be reused to focus on different terms. Copy and paste the general layout between pages, and simply change the content and images. If it helps, you might want to just compile the images for each landing page ahead of time, that way you can just type and replace images as you go.

So now that you've only had to design 1 landing page template, let's customize it for every different use case related to the keywords you're targeting.

Now optimize for keywords.

For each page, run it through SEMRush's SEO writing assistant or you can try using SurferSEO.

Both these tools will give you suggestions on how to optimize for readability and also specific search terms.

Next just make the pages live and link to them from any blog posts or other places on your site. Internal linking is a part of your process that is critical in getting new content ranked.

Landing pages are harder to rank than standard long form content. This is because they are usually less readable and focused on "selling" something instead of being informational content. That's why I recommend you create these pages as a hybrid between the two. Focus on making them readable and your content paragraphs should generally be longer if you're optimizing for search.

Make sure your landing pages are actually readable. Don't hop from left to right, and between different text layouts for marketing purposes. Focus on articulating a key idea related to your search term.

Later on, you'll need to optimize for backlinks and internal linking to help your landing pages rank better than the competition.

## Blog Content

Now, let’s talk about the other side of the coin: content keywords, and how to create content that ranks.

Content on your blog or articles is where the bulk of SEO is focused. Let's go over the techniques to focus on here.

Informational blog content is what's known as 'indirect' intent. Visitors that land on these pages aren't necessarily looking for what you're selling, however, awareness is all part of the journey. You can also try and capture emails and other information you'll be able to use down the road.

The trick is to think through 'intent' when you create content. Is the intent of people viewing your content at least tangentially related to your product or service?

Two create high quality long form content, the most important aspects are:

- Does the content have a logical flow?
- Is it readable?
- Is it useful?

### Creating an Outline

The outline centers around the most important piece of your content the headers and subheaders you should use. Most people, 80%, will only spend the time to read the headers and the conclusion of your blog posts. Sad but true.

In addition, the outline will help you isolate the information and the flow of the information in your piece. After all, content needs to be understandable.

An outline is also important for writers as it takes a lot of the SEO strategy and boils it into a simple structure they won't need to understand.

Steps:

- What's the target word count? Typically aim for 1.5x - 2x whatever your competitor wrote, or keep it the same length but add better images and media. If a competitor was super "wordy" aim for better images. If they were too simple, go for a longer article.
- Outline the structure of headers. Reference the competition and copy where necessary.
- Borrow ideas from the top 5 ranking articles to figure out what your headers should be.
- For each header create a bulleted list of ideas to be written about
- Look at comments on social aggregators like Reddit. Try and understand the questions and frustrations people are having around a specific topic.

### Writing for Value

The "first principle" of SEO is simply to create value for people looking for content. That means you need to write in a way that is readable and hopefully you'll create a little brand equity in the process.

**Write for your target** The first question is who are you writing for? What are they used to? You'll probably want to break the mold tastefully to make an impression.

**No bloat** Above all don't add in fluff or bloat just for word counts. Lately AI generators are becoming more common and writers using them create massive bloated posts that are hard to use for anything. Over time, Google will do a better job at figuring out what content is useless vs useful. You can count on it.

**Don't assume knowledge** In other words, don't assume your readers understand the basics. If you need to skip some prerequisite skillset, provide an aside and a link to read up on expected knowledge.

**Quickly Fix Grammar** There are some good AI powered tools these days that are great at helping you avoid grammar mistakes. You've probably heard of Grammarly and Hemingway. Check them out if you haven't already.

## Link Building

As you may know, Google exists because of their insight about the value of backlinks in deciding what should rank well. There are many reasons why this is a strong signal.

While you may be able to create amazing content, if you have 0 links to your site or specific posts; you likely won't rank well in competitive areas.

In super profitable and competitive niches, its not uncommon for there to be dozens of high quality posts or content pieces for a single search term. From there the deciding factor is links and associated information.

Because of the difficulty in building backlinks. Big companies spend a lot of money to do it. Not to fear, here are some tricks you can use to win at this game.

As with everything in business, unless you're a billion dollar company, you'll need to start small. Most competitive niches are going to be out of reach until you're further along so... start small!

Take a larger category and break it down into areas that are close to your business; but not hugely competitive areas.

So how do you get links?

There are many approaches to getting links and these have been well documented across the web. So this won't be an exhaustive list; however let's look at the approaches that work well for most use cases and don't require a huge budget or large time investment.

Our 3 favorite and most reliable techniques are:

**Skyscraper technique.** Find something on the web that gets a decent amount of attention but is done poorly, is old and unmaintained. Then, simply create a newer and better version of it.

**Guest posting.** This is= the most popular link building strategy. Find blogs that accept guest posts, and ask them if they allow guest posts. They usually let you include 1-2 do-follow links back to your website.

**Create a free giveaway working linking** linkable asset is a resource that is so useful that people are just going to link to it. Infographics, templates, tools, you get the idea.

**The Launch Technique** You can also spend a large amount of time to create a piece of content that is super comprehensive like an eBook. When you do this you can use PR techniques to reach out to news outlets and similar around the launch of your book. IF you do something useful, this can generate a ton of links from high quality news sites and publications.

With these you can post them on sites like Hacker News, Reddit, and various niche boards and really juice it.

## Review and Update Your Content

If you think about it, it really makes sense for Google to take a look at how long people view your website to determine how well your content performed for the visitor.

As such, you'll need to do what you can to keep users looking at your site. This might be done with internal links from your posts, but also by creating relevant "related articles" and content to show them in areas like the page sidebar and footer.

As a rule, each post or page should be linked to from every related piece of content on your site. From one to three times.

Proper internal linking can have a significant impact on your site and it's rankings in search. If you have done a poor job of this, you can expect a 100% increase in results by fixing it.

So, how do you do interlinking “right?”

So how do you approach interlinking?

If you hire writers, we recommend you set a guideline of providing 5 tp 10 links to other parts of your content or site.

In the first run, writers generally only get about 50% of potential linking opportunities. For this reason you'll need to implement a content updating policy to enhance your linking and update areas of content.

### The `site:` trick

To find applicable cross-linking opportunities, we recommend you try a search of your site using the `site:example.com [keyword]` strategy. That will source all relevant content to a specific topic on your site.

From there, the linking opportunities should start to become more or less obvious as you dig into specific pieces of content.

## Monitor Your Click Throughs

The click-through-rate (CTR) of users searching for terms is relevant to how Google ranks your content.

Google uses human signals for many portions of its algorithm and they use machine learning along with CTR to decide if people are finding your page relevant to their searches.

For example, if the average click through for an article in the 3rd position is 18% but yours gets a click through of 20%, they will take this as a signal that people are finding the content more valuable than its position connotes.

This also works in the opposite fashion.

For that reason, the title and description tags associated with your pages can have a huge impact on the way they rank. You need to be very scientific about how you set these.

While things change across Google, here is the handy CTR rule of thumb for each position:

1. 32%
2. 25%
3. 19%
4. 14%
5. 10%
6. 6%
7. 4%

To see how your pages are doing in terms of CTR. Check out the Screaming Frog Spider tool or SEMRush's position tracking tools.

To test and improve your CTRs we recommend keeping a spreadsheet and monitoring your current state, along with changes. It generally takes around a month to test a series of changes; so in the spirit of data driven marketing, you'll need to be precise about what you change and what results these changes create.

## Making Improvements Over Time

Optimizing for search is an ongoing process. You'll need to stay on top of it to get ranked and then to keep your ranking once you get there. Google understands that newer and fresher content is going to be more relevant than older articles.

So you'll probably want to think about an auditing process for you content. Once you've been creating content for 2+ years we recommend you implement a program where 25% of your time on content is spent simply updating older content to make it relevant today.

Now it's time to stay consistent and build content production into your ongoing workflows. It needs to be a fundamental part of your business process.

## Recap

If you've read and followed this guide, you should have a great start for SEO. If this guide helped you create some results, please let us know.
