import { AppRoute } from '@factor/api'

export default [
  new AppRoute({
    name: 'billing',
    niceName: () => 'Billing',
    path: '/manage/billing',
    parent: 'app',
    menus: ['organization'],
    icon: `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
  </svg>`,
    component: () => import('./BillingMain.vue'),
  }),
  new AppRoute({
    name: 'billingPlans',
    niceName: () => 'Plans and Pricing',
    path: '/manage/billing/plans',
    parent: 'app',
    icon: `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4" />
  </svg>`,
    component: () => import('./BillingPlans.vue'),
  }),
  new AppRoute({
    name: 'billingHistory',
    niceName: () => 'Invoice History',
    path: '/manage/billing/history',
    parent: 'app',
    icon: `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
  </svg>`,
    component: () => import('./BillingHistory.vue'),
  }),
  new AppRoute({
    name: 'billingPaymentMethods',
    niceName: () => 'Payment Methods',
    path: '/manage/billing/methods',
    parent: 'app',
    icon: `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
    </svg>`,
    component: () => import('./BillingPaymentMethods.vue'),
  }),
  new AppRoute({
    name: 'billingUpgrade',
    niceName: () => 'Upgrade',
    path: '/manage/billing/upgrade',
    parent: 'app',
    icon: `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
    </svg>`,
    component: () => import('./BillingUpgrade.vue'),
  }),
]
