---
title: GDPR Commitment
description: The GDPR (General Data Protection Regulation) is an important piece of legislation that is designed to strengthen and unify data protection laws for all individuals within the European Union.
---

The GDPR (General Data Protection Regulation) is a piece of legislation designed to unify data protection laws for all individuals within the European Union. The regulation became effective and enforceable on the 25th May 2018.

**PageLines's commitment**: PageLines has undertaken the required business and technology steps to operate in a manner compliant with GDPR.

## What do PageLines Customers need to do?

There are two things that you might need to do depending on your situation and jurisdiction. Below are the only impactful changes that we can foresee that might affect you as a result of using PageLines:

1. Make sure your Terms of Service or Privacy Policy properly communicate to your users how you are using PageLines (and any other similar services) on your website or app. This requirement has always been part of PageLines’s Terms of Service, but the GDPR can heavily penalize you if you’ve not done this clearly. We recommend you ensure your policies are up to date and clear to your readers.

2. If you are in the European Union you may want to sign a Data Processing Agreement with PageLines. You can request a Data Processing Agreement via email at [hello@pagelines.co](mailto:hello@pagelines.co).

## What is the GDPR?

The General Data Protection Act (GDPR) is a significant piece of European data protection legislation. It was introduced in the European Union (EU) to replace the the 1995 Data Protection Directive.

The GDPR regulates the processing of personal data about individuals in the European Union including its collection, storage, transfer or use. Importantly, under the GDPR, the concept of “personal data” is very broad and covers any information relating to an identified or identifiable individual (also called a “data subject”).

It gives people more rights and control over their data by overseeing how companies handle and store the personal data they collect. The GDPR also enforces compliance by imposing greater fines should the provisions of the GDPR be breached.

The GDPR enhances EU individuals’ privacy rights and places significantly enhanced obligations on organizations handling data.

In summary, here are some of the key changes to come into effect with the upcoming GDPR:

- **More Rights for Individuals**: The GDPR provides expanded rights for individuals in the European Union by granting them, amongst other things, the right to be forgotten and the right to request a copy of any personal data stored in their regard.

- **Compliance**: The GDPR requires organizations to implement appropriate policies and security protocols, conduct privacy impact assessments, keep detailed records on data activities and enter into written agreements with vendors.

- **Data breach notification and security**: The GDPR requires organizations to report certain data breaches to data protection authorities, and under certain circumstances, to the affected data subjects. The GDPR also places additional security requirements on organizations.

- **New requirements for profiling and monitoring**: The GDPR places additional obligations on organizations engaged in profiling or monitoring behavior of EU individuals.

- **Increased Enforcement**: Under the GDPR, authorities can fine organizations up to the greater of €20 million or 4% of a company’s annual global revenue, based on the seriousness of the breach and damages incurred. Also, the GDPR provides a central point of enforcement for organizations with operations in multiple EU member states by requiring companies to work with a lead supervisory authority for cross-border data protection issues.

If you are a company outside the EU, you should still be aware of this. The provisions of the GDPR apply to any organization that processes personal data of individuals in the European Union, including tracking their online activities, regardless of whether the organization has a physical presence in the EU.

If you have any questions, please don't hesitate to contact us at [hello@pagelines.co](hello@pagelines.co).
