---
title: When Persistence Matters - The Rocket Rule
---

Overcoming obstacles, persevering through tough times, and maintaining passion for long-term goals is what sets successful people apart from the crowd.

And while you might know that persistence is important, not everyone knows why.

The reason is because failure is a critical step in success. Messing up is human, but we only learn and improve from the mistakes we make. So, giving up early makes you lose the opportunity to learn from your mistakes. Which means you miss the important part: what you need to do to succeed.

### Celebrate Failure, It Means You Took Action

Have you ever heard about ostriches burying their head in the sand? Well actually, they don’t do that. They dig holes in the ground to use as nests for their eggs.

But strangely, humans do this all the time. Our first instinct is to close their mind, ignore, blow-off something if we're not confident in its success.

For example, you might want to write an article a day. But instead, you just read about writing. You might want to start a company, but just watch videos about it on Youtube. Ultimately, you're afraid of putting something out there; because it inevitably means risking failure.

The thing you need to know is failure, real failure, is the first step on the path to success.

Failure (done right) is going to teach you exactly what you need to create, learn, do, become, etc..

**So How Does One Fail "Right?"**

Elon Musk’s first SpaceX launch failed 33 seconds after lift off due to a rusty nut back in 2006. SpaceX failed four more times between 2007 and 2016, but Musk didn’t give up, his team's persistence and failure-based improvements allowed them to succeed. In March 2017, SpaceX successfully launched a used rocket for the first time and the rest is history. SpaceX plans to send astronauts to the International Space Station in June 2019.

### Efficient Repetition

If you want to master something, you must focus on repetition, not perfection.

Your product has to be great and making a great product takes repetition. Having a high pain threshold is also necessary since pain and failure are part of the process. But make sure your activity is shaped like an upward spiral not like a dog chasing its tail, your repetition must include improvements.

![Repetition Must Include Improvements](https://fiction-com.s3.us-west-1.amazonaws.com/5df9369b982d4c002c6b4bbb.jpeg)

The more you repeat an activity, the more your brain becomes efficient at that activity and eventually the actions become automatic behavior.

> Failure is simply the opportunity to begin again, this time more intelligently. - Henry Ford

It’s easy to find successful people who focused on repetition and improvement like Thomas Edison. It took him more than 1,000 attempts before inventing the “first” light bulb. By the time Edison started working on it, the light bulb had been around for a while but in a different form and not as efficient.

Edison’s persistency allowed him to test different materials, their duration efficiency and their cost to develop the first practical incandescent lighting system. He even invented the way light bulbs get screwed into sockets, his contribution to the perfection of the light bulb is impressive.

### Seek Constant Criticism

A lot of times, when you speculate instead of seeking criticism, you tend to waste months of work going the wrong direction, or switching between ideas because of your own thinking.

Customer feedback helps you avoid this, it saves you time and allows you to persist on valuable items. It helps you improve your product or services, and allows you to learn.

> A well thought out critique of whatever you’re doing is as valuable as gold. -Elon Musk

For example, Henry Ford's first batch of the Model A’s had many issues. He had so many problems that the Ford Motor Company had to send mechanics to fix cars. But when these mechanics came back, they came back with feedback. This feedback allowed Ford to implement fixes in his assembly line. They kept selling, shipping and the company kept learning.

It would take Ford 5 more years of failures, repetition, and criticism before dominating the market with the model T. His persistence and improvements made him successful.

### Summary

Hopefully the above principles help you avoid mistakes while staying persistent and guide you on the path to success.

- Failure is the first step on the path to success.
- Focus on repetition, not perfection.
- Seek constant criticism.
