---
title: Managing Remote Workers - The Hub Model
---

_Remote work is a challenge to maintain and manage. The key is using a 3-person "hub model" which solves the quality and culture problems while still allowing people to be location independant._

In 1758, The Way to Wealth, was printed by Poor Richard, otherwise known as Ben Franklin. In this book, Franklin describes many of the maxims for managing money and people.

While today many things are different, one thing hasn't changed: managing people is hard. And if you want to do it remotely, well, then its even harder.

Franklin has a quote I find relevant:

> Want of care does us more damage than want of knowledge. Not to oversee workmen is to leave them your purse open. Trusting too much in the others care is the ruin of many. For in the affairs of this world men are saved, not by faith, but by the want of it.

And in the case of remote work, managing people from afar, we have the above scenario only multiplied exponentially.

So how does one effectively conduct business in a remote environment? For that, I'd like to introduce the "Hub Model," but first let's discuss the problems...

## The Problems in Remote Based Companies

In my first company, [PageLines](https://www.pagelines.com), I ran the company completely remote. Although that wasn't always the intention. Working from San Francisco, I quickly discovered the most difficult (and expensive) place to hire competent talent and to keep them focused.

In this environment, I made every mistake, the first of which was drinking the Koolaid about being "remote" without considering all the caveats regarding implementation and sanity. Anyway, some of the problems I faced:

- **Quality Control** - Keeping the quality of implementation to an exacting standard is nearly impossible in a purely remote company. (That's why you rarely see a remote business that makes you admire the brilliance of their execution.)

- **Communication Overhead** - In remote companies, if you want any chance, you need to spend somewhere along the lines of 3x more time on communication. This can be a huge dent to overall productivity.

- **Missed Expectations, Frustration and Bottlenecks** - Something that seems to happen in the remote environment, due to a lack of quality feedback, is missed expectations. Often time the initial meetings don't tell the whole story and the remote worker than delivers something a few days later that is way of the mark.

Also, the tools don't work. Slack, Teamspeak, whatever, they all just lead to more distractions than help. People start to think "working" is just saying "Hey guys!" on Slack -- (even though they are super hungover and at the pool.)

These are the main problems, and as you likely know, managing things in a remote work environment comes with some nice advantages. Namely, costs for talent, a larget talent pool and a better lifestyle for everyone.

So how to we rectify these things and maximize our results? Yep the Hub Model!

## The Remote Hub Model

![](https://fiction-com.s3.us-west-1.amazonaws.com/5df938b2982d4c002c6b4bc2.jpeg)

The hub model is simple and is based somewhat on the 3-person idea that [37Signals often evangelizes](https://m.signalvnoise.com/threes-company/).

**The idea is this:**

- 3 People Rule - Allow remote work but only in teams of 3 people or more.
- Time Chunk Rule - Set up company wide time chunks that allow teams to sync up. i.e. "this quarter lets all work from Sweden."
- Together Rule - The team must spend working hours together in a coworking location at the location

Ok, so if we have three people, isn't that like opening an office somewhere? No! The difference is that an "office" is permanent a "remote hub" moves with the team. This team of three people can work from wherever they want, basically the office moves and the team that goes there is interchangeable on a monthly or quarterly basis.

Let's say for example that we have a 15 person agency. One person would like to go check out Argentina for a month, well then just allow the employee to slot the time and recruit at least two others that want to try it as well.

## Conclusion: Why Does This Work?

Managing a remote team is impossible if done incorrectly and difficult even if you try super hard. Thats why you should try the Hub Model.

The hub model works because people need to work together. It solves the problems in the following way:

- Quality - A team working together will give each other feedback and drive each other towards better results.
- Communication - Teams have less of a need for communication since they mostly will communicate amongst themselves and report weekly.
- Missed Expectations - Its harder for a team to miss expectations than a hungover individual.

Yet all the benefits of the remote environment remain. See? Hopefully we learned something today =D",
