---
title: The Picasso Method
---

I’ll start this article with a question: do you respect Picasso as an artist?

I do, but today I appreciate Picasso more as an entrepreneur and businessman than an artist. (As an artist I actually think he was the ultimate sell out.)

Why? Well that’s the subject of this article. Today I’ll explain Picasso’s story and how you can use some of his techniques to sell your art and find ultimate success.

## The “real” story of Picasso

Almost no one knows the real story behind how Picasso got his start. Well, it goes something like this…

When he was a young man he moved to Paris to chase his dream of being an artist. Like most artists, Picasso struggled to find a way to get people to pay for his art. Because of this he spent these early years nearly destitute in severe poverty. The wikipedia article on Picasso says that he actually burned some of his art to stay warm. He was the quintessential starving artist.

> “What would have become of us if Kahnweiler hadn’t had a business sense?” – Picasso

Luckily about this time Picasso met a man named [Daniel-Henry Kahnweiler](http://en.wikipedia.org/wiki/Daniel-Henry_Kahnweiler), who was a local art dealer in Paris and a business man.

Kahnweiler offered Picasso a deal. Specifically, he offered to buy all of Picasso’s pieces and even give him a place to sleep in the back of his gallery. He didn’t give Picasso much in terms of pay, the equivalent of today’s minimum wage, but at least Picasso was surviving from his art and so he was happy.

## Fabricating The “Picasso Story”

> “Fake it ’til you make it.”

As an art dealer, Kahnweiler had some very important insights into what makes someone buy a piece of art.

Kahnweiler knew that people don’t buy “art” at all. They buy a story and a brand; and maybe most importantly, people buy art as a status symbol.

So that’s what he tapped into.

While Picasso had been used to either giving his art away or selling it extremely cheap; Kahnweiler marked his art up to astronomical prices.

He fabricated a story to tell people about Picasso and let them know he was the “next big thing.” He created urgency by telling the buyer they would be missing a hell of an investment if they passed on the opportunity to buy a Picasso.

And while these original buyers were more or less duped; **they actually did make a hell of an investment.** As they say, “fake it til you make it.”

## Selling Out

One of Picasso's 5-second "masterpieces" or mind hack. You decide.
Masterpiece or mind hack?
A couple of years ago, I went to look at an original Picasso for sale at a local art gallery. The piece was for sale for only $1.3 million dollars; a hell of a deal for an original Picasso, I thought.

![Masterpiece or mind hack?](https://fiction-com.s3.us-west-1.amazonaws.com/5df93786982d4c002c6b4bbf.jpeg)

The piece itself looked like it had been drawn by a kindergarten student with crayon in approximately 5 minutes. But hey, it was an original Picasso, right?

There was a roman number IV written on the piece. I asked the dealer what that meant, and she said “oh, that means this is the fourteenth piece Picasso did… **that day.**”

So I asked, “What? That day? How did Picasso make fourteen pieces of art in a day?” and the dealer responded, “Actually, later on in his career Picasso didn’t actually paint or draw most his pieces, he would do the original and have his apprentices emulate them, then he would sign them and sell them as his own. He would sometimes sign 30 pieces or more in a day.”

That’s when I realized that when Picasso got older, he became the ultimate sellout. He realized that people would pay crazy money for anything with an original Picasso signature on it, it didn’t matter what the content of the art was.

At this point Picasso ceased to be an artist, he became exclusively a businessman with a very lucrative brand.

## The Moral of the Story

![Picasso's Signature](https://fiction-com.s3.us-west-1.amazonaws.com/5df93786982d4c002c6b4bbe.jpeg)

What can we learn from the story of Picasso?

Well, the most important take away is that people don’t buy art for the art. They buy the brand; or specifically, they will buy their perception of a brand. Often times they are buying that art as a status symbol they can use to subtly show off to their friends.. (“Wow, you have a Picasso?!” “Ohhh, the crayon and roman numeral IV in this piece just spoke to me and I had to have it.”)

As an artist, what does this mean for you?

- **Build a Recognizable Brand**
  Create a focused brand and reinforce it in all your work. It doesn’t matter if you’re a painter, musician, dancer, etc.. you need a brand that you can build and imbue with meaning. For that, start by reading the Fiction article on {% post_link how-to-create-a-name-for-your-company How to Name Your Company. %}

- **Create A Story**
  Any good brand in art has a story. It doesn’t have to be a great story, it just has to be one that others can tell about you.
- **Fake It ‘Til You Make It**
  Your gonna need to find a way to make people believe you are already a big deal, even when you’re just starting out. There are many ways of doing this. For another example of this, watch the [Movie Exit Through the Gift Shop](http://www.imdb.com/title/tt1587707/) by Banksy.
- **Be Expensive**
  In branding, we talk about price positioning a lot. Is your brand the cheap generic, or the expensive premium version. In art, you ALWAYS want to be positioned as an expensive product. Just by insisting on a high price, people will appreciate your art more and will pay a lot more for it.
