If you're starting a company, then choosing the name is one of the first and most important things you'll have to decide on.

Naming is a skill and somewhat counter-intuitive; there are places where people spend way too much time and some major mistakes that can be made.

## Principle #1 – Naming is not a group activity.

There are many nuances to naming a business. It’s an art. This is why you should never try and name something with a group of people. One person, with a solid knowledge of branding and naming dynamics, should present some solid options from the rest to pick from.

If you attempt to name something with a group you will end up with the blandest, most typical, boring name. Simply because groups tend to remove the edge and move towards conformity. Also, the other members of the group may not be familiar with naming pitfalls and will argue with you endlessly about some of the following points…

## Principle #2 – A good name does NOT explain what you do.

A lot of people think that a brand name should somehow explain what there company does.
These category of naming is called “descriptive” branding and there are many downsides to it.

Think about it, your brand is always presented with _context_ so adding a description in the name is unnecessary and redudant. Imagine, if Google had named themselved "Good Search Inc," then every time a journalist would introduce the company it would go something like this:

> Good Search is a, ah, um, a good search company that makes it easier to search for stuff.

See what I mean?

Primarily, this naming strategy will always tax your marketing budget because the brands are pulled from a small group of keywords hence they blend together. Ultimately, you end up spending your advertising dollars building the brands you’ve incorporated into your name (in this case WordPress). This makes descriptive names are the opposite of good marketing. Other reasons they’re bad:

- They’re boring
- They’re unoriginal
- They have no personality
- You can’t build brand awareness
- Undifferentiated from competition

### Pitfalls

So why do people fall for this? Here are the common pitfalls”

- **How will people know what we do if it’s not in the name?** Your company name will always be presented with context. For example, if Google had named themselves GreatSearchEngine, then a journalist writing about the company would have to say something like this.. “Today, we’re writing about GreatSearchEngine, they are a… um, great search engine for searching the web.” See? That’s redundant.

- **When can this work?**
  Descriptive naming can be a good strategy when you want do deflect brand awareness towards a parent brand. For example, Facebook seems to be using this strategy with their apps, using descriptive names like Messenger and Pages, etc.., which focus you on the parent Facebook brand instead.

## Principle #3 – Don’t negatively break down a name

![](https://fiction-com.s3.us-west-1.amazonaws.com/5df93480982d4c002c6b4bb3.jpeg)

Another common mistake in branding is to take every name candidate and break it down, trying to think of every possible negative connotation the name can have with customers. This is a mistake because customers never take a company name and dissect it for negative meaning. To a customer, they use the name to understand a brand’s personality and build up from there. For example, if I suggested I wanted to name a new airline something like… oh, Virgin, here’s what a naming committee might say:

- Virgin Airlines?
- People will think we are new at this, and that’s not what we want!
- People will think we’re a sex toy company
- That name nothing to do with flying

Now clearly, the reality is that Virgin is one of the most admired and recognized brands in the space. So all those people would have been wrong.

A brand name should simply represent the personality of a company. In Virgin’s case, the brand exemplifies ‘sexy’ (as they hire lots of attractive flight attendants!) so it’s a perfect fit.

## Principle #4 – Don’t choose a name because you can get the .com (but think about the trademark)

Seems pretty straightforward, but over the last 20 or so years, there have been many-a-company named simply because the domain name was available. Even I fell for this trap with my first company the admittedly poorly named, eDoctr.

People make this mistake because they want people to easily be able to get to the website.

The reality is that, yes, it’s always nice to have a nice domain name but it is exponentially more important to have a solid brand than a good domain.

My suggestion is that you choose a good brand, and then find a clever domain that makes sense around that brand. Also you can consider .io or .co domain names as well. Like [Angel.co](https://angel.co) for AngelList; which is solid!

One caveat is that you definitely _should_ pay attention to trademark right as this has legal implications. Simply, if you choose the same name as someone else in your space, that is a deal killer. A quick Google search for the [name] +

should let you know if you’ll have a problem.

## Principle #5 – The best names are two syllables long and easy to spell (phonetically)

This one is basic psychology. People tend to build basic schemas for things that make them easier to say, spell, and remember. Because of this, people naturally gravitate towards brands that have low cognitive load (how’s that for a first principle?).

So when it comes to phonetics, that is, how your brand sounds when it’s said out loud, it’s important it has only two syllables, at least, as pronounced. For example, do you ever wonder why we call Los Angeles, “LA”; but we never call New York, “NY”? This is because people tend to want to shorten things to two syllables. The same goes for one syllable brands, people tend to lengthen those. So you might see many one syllable brands get the ‘.com’ thrown in with the brand for this reason (e.g. Moz.com instead of just Moz).

Some brands like Amazon or my friend Maren’s company, Zirtual, are technically more than two syllables; however, when they are said out loud they are typically pronounced with two syllables. Try it! Amazon is typical said “Am-Zon” and Zirtual “Zirch-ul”.. neat concept huh?

The same goes for spelling, people want names that are easy to spell and type on a keyboard. You may want to do some testing regarding this. Ask people to spell the name, if most can’t on the first try, then you probably want to keep looking. Try typing the name, make sure it’s not awkward and you can do it fast, this might be for your own benefit as much as your customers!

## Principle #6 – Name to represent a brand’s (hence company’s) personality.

Over time your name tends to help shape the personality of your company’s brand and hence its culture, values, and more. This again underlines why the name is so important. Here are some examples of this:

- Apple: Human
- Virgin: Sexy, Youthful
- Google: Playful
- Twitter: Playful, child-like
- Microsoft: evil corporate empire (lol)
  .

## Conclusion

Hopefully the above principles help you on your way to naming a company. Again there are 6 key principles:

- Don't choose a descriptive brand
- Don't choose a name because a URL is available
- Brand to the personality of a company (not its function)
- Don't negatively deconstruct
- Don't name by committee
- Consider how easy the name is to say and type
