---
title: King of One Trade
---

In the game of chess, there are several strategies that lead to success. You can attack quickly or slowly. You can try memorized tricks and pick from a number of well-defined openings.

However, nearly all the top players use a single positioning-based approach. That's because at the top levels, all the "tricks" stop working and getting too aggressive too fast often leads to punishment.

Positioning means setting up the right spots _before you need to use them_. That way, when finally&mdash;at some point&mdash;something breaks lose, you're there to take maximum advantage.

Success is sorta like that. It never comes down to one thing or one key event, it's always a series of things. Setting things up to optimize your chances when you finally get that small opportunity, then building from there.

However, I see [quite a few remote-job applications](https://www.fiction.com/careers) and I'd say roughly 99% of these folks have fundamental issues with the setup(positioning). In other words, people are always trying to attack before they've property set up their pieces.. In effect, jumping straight to "hire me!" instead of becoming the type of professional that I would want to hire.

So I thought I'd spend a minute to give you some insights&mdash;from someone who has been on both sides of the table&mdash; about [finding remote work](https://www.fiction.com).

![The Three Positions](https://fiction-com.s3.us-west-1.amazonaws.com/5df93807982d4c002c6b4bc0.jpeg)

## Niche

> The Riches Are In The Niches Bitches! &mdash; A Wise Man

No one respects the generalist. Being the "jack of all trades, master of none," might have an appeal from a hobbyist perpsective, but employeers want the opposite. They want the "king of one trade, ignorant of the rest" type people that ultimately bring companies an advantage.

You will not get anywhere until you drop your ego, and reflect on the one skillset where you have the potential to be the best in the world. People will respect you more.

## Skip The Resume

If you're applying to remote jobs with a resume attachment, then you need to stop now. This practice, which I see roughly 50% of the time, is simply a demonstration that you don't understand the remote work paradigm at all.

Think about it, remote work is about using the latest tools and tech to work from anywhere, yet you're using a PDF resume instead of building a portfolio using any of a million different options to do so? Think about it.

I recommend building a nice AngelList or [Fiction profile](https://www.fiction.com/profile) first, and ideally building a [simple yet beautiful website](https://factor.fiction.com) that demonstrates your key skill set.

(Note: As for a website, it's considered advantageous to build something instead of some quick builder tool. It shows you can build something on your own. However, keep it simple.)

## A Good vs Bad Portfolio

We also see quite a few porfolios these days, and a good portfolio remains the crux of finding good work. But the problem here is that most portfolios are simply missing the point.

The point is to demonstrate your ability to create value for your potential employer or customer.

There is a new phenomenon I call the "coding-school" porfolio. These portfolios consist of a few quick demo websites that are designed to show basic understanding of 101 level web tech. Typically, they look like a mish-mash of different features and ideas, are broken in places and use Google's Material Design framework (bleh!).

I understand why coding schools require that people do this. But if your portfolio looks like this, you're only showing that you have the ability to create stuff that is incomplete and broken.

The solution is to take your time and create something impressive. If you don't have the skills to do that, get them. Then you'll have no problem finding a job.

## Your Online Persona

> "Wow that's Lisa Berger?! &mdash; Butters

One of the funniest South Park ever, "The Hobbit," is all about how Photoshop affects people's opinion. In this episode Wendy photoshops a picture of Lisa Berger to demonstrate how much it can improve someone's appearance. And instead of realizing this, Butters just thinks that the Photoshop version represents her real appearance and she's "hot."

People actually do think that way. However you look on Instagram _et al_ is reality to them. And it may be unfortunate, but you can't change it.

One of the quickest and easiest things you can do for your online career is to recognize that your online persona&mdash;your appearance on social networks, blogs, email, etc..&mdash; is not only what is important, it's what defines you.

What this means is that all your photos need to not only look professional, they also should represent the person you would like to be. That means remove those festival shots where you were hammered. Or those poorly lit iPhone 4 photos from 2010.

**Less is more.**

Another thing you should consider is your "paper trail" online. If you have political posts, angry tweets, whatever; these can easily derail employment opportunities. No one outside of political organizations would knowingly hire someone with a habit of screaming on social media.

Finally, once you've got a simple online persona; you need to stay consistent. People learn through repeated exposure so changing things up all the time is a lost opportunity.

## Summary

You can't skip steps. The key to success is first to drop the get rich quick mentality and focus on how you best position your pieces to optimize your chances when you get that first small opportunity.

Some specific advise is to:

- Reflect on what your niche is (King-of-One-Trade)
- Drop the resume and focus on building a simple website that demonstrates the value you can provide.
- Consider minimizing and cleaning up your online persona. Do this by removing unprofessional pictures and cleaning up any unsavory social media posts.
- Once you have an online persona down, don't change it often (of ever). Impressions are made through repetition.
