You'll never change your life, if you don't change your approach.

That's why the most critical component in change comes down to habit.

**Habits From Identity**

An interesting point that James Clear makes in his book ["Atomic Habits"](https://www.jamesclear.com) is that identity and habits are related. What he says is that often times your behavior is out of alignment with the person you would like to become.

This inevitably leads to unhappiness and failure. The solution is to first reflect on the person you would like to become and the habits that person would have.

### Step 1 - Identify

So, the first step in changing your life is to decide who you want to be.

What do you want to stand for? If you could be any specific person, in essence, who would that person be?

These are abstract questions, and it may be hard to be specific; but most people know the things they are most looking to achieve: start a company, leave my [job, home town], give an inspirational speech, write a book, etc..

So ..start there and work backward...

who is the type of person that could achieve these things?
What would their day look like?

### Step 2 - Visualize

Next you need to visualize the type of routines you'll need to have to become that person.

Want to start a company? Well, you will likely need to start by building some insights in a key niche area and learning about the basics of business. How would the person you would like to become start to figure these things out?

If you're like me, I think of a person that fights hard to find the information I need to make better decisions. Whether that means, finding a mentor and embarrasing myself cold calling relevant people than peppering them with questions.

### Step 3 - Strategize

For most people, the strategize phase is where the mistakes are made. It's not becuase people don't create a strategy, it's that they create strategies that aren't sustainable.

For instance, someone might resolve to lose weight, but only resolve to eat healthier and "get to the gym." Well, inevitably these vague goals fall apart the minute it is convenient to do so and that person is back to square one.

That's why to strategize correctly you simply need to do two things:

1. Say when and how often you're going to do something.

- e.g. I'm going to hit the gym 5 times a week, after work. I'm going to write at least one page a day for 30 days...

2. Make sure the task is sustainable. Be careful not to pick a goal that is simply too much to handle without serious compromise. For example, don't resolve to write a chapter every day, because you'll miss one day, then two, then you'll give up.

### Step 4 - Chart

The final step in changing your life, is to measure how well you maintain your habits. Note that we aren't necessarily measuring progress, only now well we are sticking to our strategy.

Many of the habits you'll need to change won't be giving you instant feedback, and because of the this most people don't get the immediate gratification or knowledge of progress. For example, if you eat well for a week you still might not see a lot of progress on the scale; although presumably you'll see it eventually.

Because humans have an innate need for instant positive feedback, thats why its important to track the positive things you do instead of the results which may be delayed days, weeks or even months.

Thats why you need to implement a charting solution. Personally, I track my progress using a simple Google Sheet, a daily google form I email myself, and some generated charts that get emailed me nightly based on all my tracked information.

Although this solution is just for myself, I can see how my actions are changing over time and affecting my results. If nothing else, it helps me see how well I'm staying disciplined and if any balls are getting dropped across all my goals.

### Summary

Today is the day. You're ready for something different, so get started.

All you need to do is start by

**(1) Identify** as your future self by figuring out who you would like to be,

**(2) Visualize** what habits your preferred future self needs to have,

**(3) Strategize** how you are going to make a change, and what those specific changes need to be (when and how often)

**(4) Chart** how well you behave each day, giving yourself the feedback you need to stay positve and keep going.
