---
title: The 21 Top Rules for Copywriting
---

Copywriting is a challenging art and there are lots of unwritten rules. In my time, I've taken note of a few ideas that I feel help you write better copy, more quickly.

Some of these “laws” are non-obvious, so my goal is that even experienced copywriters will learn something from this guide. Newer writers will get a strong framework to build from.

First, why are these rules important?

> “Worry not that no one knows of you; seek to be worth knowing.” – Confucius

Copywriting is much more that simply writing to convince people to buy your product. You can use it to do things which are much more powerful.

**Good copy lets you**

- Build a tribe / following
- Create loyal customers that love your brand
- Create a feeling of kinship in the reader
- Start a movement or new trend

And these laws are also needed to prevent the effects of bad copy (which I’ve had to learn the hard way).

**Bad copy can easily let you be perceived as:**

- Greedy
- Arrogant
- Inexperienced
- Boring

Ok, so now hopefully you get the point. Let’s get into the 21 Laws of Good Copywriting…

## The 21 Laws of Good Copywriting

1. **The First Rule: Always Be Human**

- Act and write as a human would. If saying something out loud would sound out of context, arrogant, stiff/corporate, boring, then you are not doing good copywriting.
- For example, a human would never say “Buy this now!” they would say, “Check this out, we think you’ll like it.“

2. **Assign ownership to the reader**

- Maximize the words “You”, “Your”
- Never user “I”, “we”, or “our”. Using self-centered language like “I” and “we” gives the impression that you only care about yourself or your business/solutions rather than the customer.

3. **Provide explanation**

- Use the word ‘because’ often, because it gives context and explanation.
- Imagine every point you make followed by the question Why? in the customers mind.

4. **Avoid the cliche’**

- Endeavor to entertain, write uniquely yet simply.
- Cliche copywriting is comparable to the stock images of business people giving each other high five.

5. **Never mention competition by name**

- Speaking badly about the competition will always make you look bad instead.
- Usually seen as arrogant
- What To do instead: Discuss the competitive approach or category and why it might not be right for the reader

6. **Don’t use the word “very”**

- Why? Unoriginal. Use the extreme form of the word instead.
- Example: instead of ‘very tired’ use ‘exhausted‘, instead of ‘very cold’ use ‘freezing’ and so on…

7. **Start sentences with Verbs and Active Voice**

- If you’re struggling on starting a sentence, then follow this rule: add power to your sentences by starting them with verbs.

8. **Don’t use exclamation points!**

- Exclamation points are often be seen as trying to hard, yelling or selling (as in used car selling). Good writing doesn’t do any of these. In my opinion, exclamation points are for use by experts only.

9. **Use “advanced” punctuation**

- What I call “advanced” punctuation allows you to be read in a way that is closer to your intent (and also makes you look smart).
- For example, use m-dashes–they’re great for asides–and semi-colons; they are nice for combining closely related sentences.

10. **Different Headline Styles are OK**

- There are different formats for headings and titles. Using a full sentence is okay and good style (used by Apple). These should be formatted with Capitalized first letter and period.
- Example: “[Whatever] for the rest of us.”
- If not a sentence, use all caps except for common connecting words like ‘the’, ‘as’, ‘in’ and ‘of’.
- Example: Build the Best Websites in the World

11. **And old preposition rules can be broken**

- They say don’t start or end a sentence with a preposition. It’s ok to do this, it adds a conversational tone and shows you’re not afraid to break some rules.

12. **Icons, images, and media are copy**

- These days icons, images and media are very important to copy. People have short attention spans and need to be persuaded quickly. Learn basic graphic design and how and when to use these formats.

13. **Never compliment yourself**

- One of the most common mistakes by beginning (and sometimes advanced) writers is complimenting yourself.
- For example, “join the amazing community” is a form of complimenting yourself and the community.
- Instead compliment what it will do for the reader: ““Join this community which will help you to do amazing things.”

14. **Be inclusive, don’t use the word “our”**

- You always want to instill a feeling of kinship or ownership in the part of the reader.
- Instead of using the word “our” you should usually be using the word “your” instead.

15. **Use bulleted lists Often**

- Use bulleted lists as often as possible. They provide the reader a clear way of seeing differing points or attributes.
- They also increase the speed at which a reader can scan your copy.

16. **Don’t use fluff, shorter is better**

- Remove wording that is overly descriptive, complimentary or trying too hard.
- People have an adverse reaction when they notice pointless or redundant text.

17. **Don’t try too hard**

- Why? Trying to hard makes people feel like they are being sold, which makes them feel like they are not getting a good deal.
- Your attitude should NOT be: “Try this super cool widget, it’s amazing and will change your life forever OMG!”
- Your attitude should be “Here’s what we’ve got for you, we think it will help you with your goals. Try it, we’d love to be a part of your success.”

18. **Use humor and jokes**

- Don’t be boring. Add jokes and other humor to your writing as you might in a conversation. (Copywriting isn’t boring right?)

19. **The best copywriting is education**

- Steve Jobs used to say “the best marketing is education.” This applies fully to copywriting. Speak as if you’re advising someone on a purchase or action, educate them to the features and tradeoffs.

21. **Use the correct format for the job**

- There are four stages reader go through as they are reading copy: A-I-D-A. You always want to use the correct communication format for each…

1.  **Awareness** – Landing page format. Use the 3 second rule: “Let the know what you do and how it can help them within 3 seconds”
2.  **Interested** – Use product tours, media, comparison tables. Help people understand where your product fits in the world.
3.  **Decision** – Use long format text and stories. Make the user feel safe and that there is a safety net for any decisions they make.
4.  **Action** – This is where you take money or information from users. Remove all distractions and guide them through each step.

5.  **Even the best rules are meant to be broken**

- As they say, to be an artist you need to learn the rules in order to break them.
- Except for these laws, never break these ;)
